/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.itemindicator.render;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cotrin8672.itemindicator.ItemIndicator;
import io.github.cotrin8672.itemindicator.render.ItemOverlay;
import io.github.cotrin8672.itemindicator.util.BeeInstanceFactory;
import io.github.cotrin8672.itemindicator.util.MatrixStackExtensionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u00020\u0010R\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR&\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110 0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lio/github/cotrin8672/itemindicator/render/BeeOverlayRenderer;", "Lio/github/cotrin8672/itemindicator/render/ItemOverlay;", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/gui/Font;", "textRenderer", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "xOffset", "yOffset", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)Z", "Lnet/minecraft/client/Minecraft;", "", "x", "y", "", "renderBee", "(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/GuiGraphics;FF)V", "level", "renderHoneyLevel", "(Lnet/minecraft/client/gui/GuiGraphics;III)V", "Lnet/minecraft/client/DeltaTracker$Timer;", "beeRenderTickCounter", "Lnet/minecraft/client/DeltaTracker$Timer;", "getBeeRenderTickCounter", "()Lnet/minecraft/client/DeltaTracker$Timer;", "", "Lkotlin/Pair;", "translate", "[Lkotlin/Pair;", "itemindicator"})
public final class BeeOverlayRenderer
implements ItemOverlay {
    @NotNull
    public static final BeeOverlayRenderer INSTANCE = new BeeOverlayRenderer();
    @NotNull
    private static final DeltaTracker.Timer beeRenderTickCounter = new DeltaTracker.Timer(3.0f, 0L, BeeOverlayRenderer::beeRenderTickCounter$lambda$0);
    @NotNull
    private static final Pair<Float, Float>[] translate;

    private BeeOverlayRenderer() {
    }

    @NotNull
    public final DeltaTracker.Timer getBeeRenderTickCounter() {
        return beeRenderTickCounter;
    }

    @Override
    public boolean render(@NotNull GuiGraphics guiGraphics, @NotNull Font textRenderer, @NotNull ItemStack stack, int xOffset, int yOffset) {
        Integer honeyLevel;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!ItemIndicator.INSTANCE.getCONFIG().getRenderBeeOverlay()) {
            return false;
        }
        GuiGraphics $this$render_u24lambda_u242 = guiGraphics;
        boolean bl = false;
        Minecraft $this$render_u24lambda_u242_u24lambda_u241 = Minecraft.getInstance();
        boolean bl2 = false;
        List list = (List)stack.getComponents().get(DataComponents.BEES);
        int i = 1;
        int numBee = list != null ? list.size() : 0;
        if (i <= numBee) {
            while (true) {
                INSTANCE.renderBee($this$render_u24lambda_u242_u24lambda_u241, $this$render_u24lambda_u242, (float)xOffset + ((Number)translate[i - 1].getFirst()).floatValue(), (float)yOffset + ((Number)translate[i - 1].getSecond()).floatValue());
                if (i == numBee) break;
                ++i;
            }
        }
        BlockItemStateProperties blockItemStateProperties = (BlockItemStateProperties)stack.getComponents().get(DataComponents.BLOCK_STATE);
        Integer n = honeyLevel = blockItemStateProperties != null ? (Integer)blockItemStateProperties.get((Property)BlockStateProperties.LEVEL_HONEY) : null;
        INSTANCE.renderHoneyLevel($this$render_u24lambda_u242, xOffset, yOffset, n != null ? n : 0);
        return true;
    }

    private final void renderBee(Minecraft $context_receiver_0, GuiGraphics $context_receiver_1, float x, float y) {
        PoseStack poseStack = $context_receiver_1.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        MatrixStackExtensionKt.withMatrixContext(poseStack, arg_0 -> BeeOverlayRenderer.renderBee$lambda$3(x, y, $context_receiver_0, $context_receiver_1, arg_0));
    }

    private final void renderHoneyLevel(GuiGraphics $context_receiver_0, int x, int y, int level) {
        if (level == 0) {
            return;
        }
        int barXStart = x + 13;
        int barYStart = y + 15;
        int barXEnd = barXStart + 2;
        int barYEnd = barYStart - 29;
        PoseStack poseStack = $context_receiver_0.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        MatrixStackExtensionKt.withMatrixContext(poseStack, arg_0 -> BeeOverlayRenderer.renderHoneyLevel$lambda$4(y, $context_receiver_0, barXStart, barYStart, barXEnd, barYEnd, level, arg_0));
    }

    private static final float beeRenderTickCounter$lambda$0(float value) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        return RangesKt.coerceAtLeast((float)value, (float)(clientLevel != null && (clientLevel = clientLevel.tickRateManager()) != null ? clientLevel.millisecondsPerTick() : 0.0f));
    }

    private static final Unit renderBee$lambda$3(float $x, float $y, Minecraft $$context_receiver_0, GuiGraphics $$context_receiver_1, PoseStack $this$withMatrixContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMatrixContext, (String)"$this$withMatrixContext");
        $this$withMatrixContext.translate($x, $y, 160.0f);
        $this$withMatrixContext.scale(6.0f, -6.0f, 6.0f);
        $this$withMatrixContext.mulPose(new Quaternionf(0.0, 1.0, 0.0, Math.toRadians(-120.0)).normalize());
        float partialTicks = beeRenderTickCounter.getGameTimeDeltaPartialTick(true);
        BeeInstanceFactory.INSTANCE.getBeeRenderer($$context_receiver_0).render((LivingEntity)BeeInstanceFactory.INSTANCE.getBee($$context_receiver_0), 0.0f, partialTicks * (float)2 >= 1.0f ? (float)2 - partialTicks * (float)2 : partialTicks * (float)2, $this$withMatrixContext, (MultiBufferSource)$$context_receiver_1.bufferSource(), 0xF000F0);
        return Unit.INSTANCE;
    }

    private static final Unit renderHoneyLevel$lambda$4(int $y, GuiGraphics $$context_receiver_0, int $barXStart, int $barYStart, int $barXEnd, int $barYEnd, int $level, PoseStack $this$withMatrixContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMatrixContext, (String)"$this$withMatrixContext");
        $this$withMatrixContext.scale(1.0f, 0.5f, 1.0f);
        $this$withMatrixContext.translate(0.0f, (float)$y + 15.0f, 160.0f);
        $$context_receiver_0.fill(RenderType.guiOverlay(), $barXStart, $barYStart, $barXEnd, $barYEnd, -16777216);
        for (int i = 0; i < $level; ++i) {
            $$context_receiver_0.fill(RenderType.guiOverlay(), $barXStart, $barYStart - 6 * i, $barXEnd - 1, $barYStart - 6 * i - 5, -27619);
        }
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Float.valueOf(7.0f), (Object)Float.valueOf(6.0f)), TuplesKt.to((Object)Float.valueOf(4.0f), (Object)Float.valueOf(12.0f)), TuplesKt.to((Object)Float.valueOf(10.0f), (Object)Float.valueOf(12.0f))};
        translate = pairArray;
    }
}

