/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.itemindicator.render;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cotrin8672.itemindicator.ItemIndicator;
import io.github.cotrin8672.itemindicator.render.ItemOverlay;
import io.github.cotrin8672.itemindicator.util.GuiGraphicsExtensionKt;
import io.github.cotrin8672.itemindicator.util.MatrixStackExtensionKt;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015R>\u0010\u001a\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00110\u0011 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u00100\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/github/cotrin8672/itemindicator/render/PotionOverlayRenderer;", "Lio/github/cotrin8672/itemindicator/render/ItemOverlay;", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/gui/Font;", "textRenderer", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "xOffset", "yOffset", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)Z", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/alchemy/Potion;", "isTurtleMaster", "(Lnet/minecraft/core/Holder;)Z", "glowStone", "Lnet/minecraft/world/item/ItemStack;", "redStone", "turtleScute", "", "kotlin.jvm.PlatformType", "longPotions", "Ljava/util/Set;", "itemindicator"})
public final class PotionOverlayRenderer
implements ItemOverlay {
    @NotNull
    public static final PotionOverlayRenderer INSTANCE = new PotionOverlayRenderer();
    @NotNull
    private static final ItemStack glowStone = new ItemStack((ItemLike)Items.GLOWSTONE_DUST);
    @NotNull
    private static final ItemStack redStone = new ItemStack((ItemLike)Items.REDSTONE);
    @NotNull
    private static final ItemStack turtleScute = new ItemStack((ItemLike)Items.TURTLE_SCUTE);
    @NotNull
    private static final Set<Holder<Potion>> longPotions;

    private PotionOverlayRenderer() {
    }

    @Override
    public boolean render(@NotNull GuiGraphics guiGraphics, @NotNull Font textRenderer, @NotNull ItemStack stack, int xOffset, int yOffset) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!ItemIndicator.INSTANCE.getCONFIG().getRenderPotionOverlay()) {
            return false;
        }
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return false;
        }
        PotionContents potionContent = potionContents;
        Iterable iterable = potionContent.getAllEffects();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllEffects(...)");
        if (CollectionsKt.firstOrNull((Iterable)iterable) == null) {
            return false;
        }
        Optional optional = potionContent.potion();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"potion(...)");
        Holder holder = (Holder)OptionalsKt.getOrNull((Optional)optional);
        if (holder == null) {
            return false;
        }
        Holder potion = holder;
        Iterable iterable2 = potionContent.getAllEffects();
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"getAllEffects(...)");
        if (CollectionsKt.toList((Iterable)iterable2).size() > 1 && !this.isTurtleMaster((Holder<Potion>)potion)) {
            return false;
        }
        Iterable iterable3 = potionContent.getAllEffects();
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"getAllEffects(...)");
        Holder effect = ((MobEffectInstance)CollectionsKt.first((Iterable)iterable3)).getEffect();
        Iterable iterable4 = potionContent.getAllEffects();
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"getAllEffects(...)");
        int amplifier = ((MobEffectInstance)CollectionsKt.first((Iterable)iterable4)).getAmplifier();
        boolean isAmplifiedDuration = longPotions.contains(potion);
        MobEffectTextureManager mobEffectTextureManager = Minecraft.getInstance().getMobEffectTextures();
        Holder holder2 = potion;
        if (Intrinsics.areEqual((Object)holder2, (Object)Potions.TURTLE_MASTER) || Intrinsics.areEqual((Object)holder2, (Object)Potions.LONG_TURTLE_MASTER) || Intrinsics.areEqual((Object)holder2, (Object)Potions.STRONG_TURTLE_MASTER)) {
            GuiGraphicsExtensionKt.renderItemModel(guiGraphics, (float)xOffset + 3.0f, (float)yOffset + 3.0f, 7.0f, turtleScute);
        } else {
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            MatrixStackExtensionKt.withMatrixContext(poseStack, arg_0 -> PotionOverlayRenderer.render$lambda$0(guiGraphics, xOffset, yOffset, mobEffectTextureManager, effect, arg_0));
        }
        if (amplifier > 0) {
            GuiGraphicsExtensionKt.renderItemModel(guiGraphics, (float)xOffset + 12.0f, (float)yOffset + 12.0f, 6.0f, glowStone);
        } else if (isAmplifiedDuration) {
            GuiGraphicsExtensionKt.renderItemModel(guiGraphics, (float)xOffset + 12.0f, (float)yOffset + 12.0f, 6.0f, redStone);
        }
        return true;
    }

    private final boolean isTurtleMaster(Holder<Potion> $this$isTurtleMaster) {
        return $this$isTurtleMaster.is(Potions.TURTLE_MASTER) || $this$isTurtleMaster.is(Potions.LONG_TURTLE_MASTER) || $this$isTurtleMaster.is(Potions.STRONG_TURTLE_MASTER);
    }

    private static final Unit render$lambda$0(GuiGraphics $guiGraphics, int $xOffset, int $yOffset, MobEffectTextureManager $mobEffectTextureManager, Holder $effect, PoseStack $this$withMatrixContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMatrixContext, (String)"$this$withMatrixContext");
        $this$withMatrixContext.translate(0.0f, 0.0f, 160.0f);
        $guiGraphics.blit($xOffset, $yOffset, 0, 7, 7, $mobEffectTextureManager.get($effect));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Holder[]{Potions.LONG_POISON, Potions.LONG_SWIFTNESS, Potions.LONG_STRENGTH, Potions.LONG_REGENERATION, Potions.LONG_FIRE_RESISTANCE, Potions.LONG_WATER_BREATHING, Potions.LONG_LEAPING, Potions.LONG_SLOWNESS, Potions.LONG_TURTLE_MASTER, Potions.LONG_NIGHT_VISION, Potions.LONG_INVISIBILITY, Potions.LONG_SLOW_FALLING, Potions.LONG_WEAKNESS};
        longPotions = SetsKt.mutableSetOf((Object[])objectArray);
    }
}

