/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.itemindicator.render;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cotrin8672.itemindicator.ItemIndicator;
import io.github.cotrin8672.itemindicator.render.ItemOverlay;
import io.github.cotrin8672.itemindicator.util.GuiGraphicsExtensionKt;
import io.github.cotrin8672.itemindicator.util.ItemStackExtensionKt;
import io.github.cotrin8672.itemindicator.util.MatrixStackExtensionKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/github/cotrin8672/itemindicator/render/ShulkerBoxOverlayRenderer;", "Lio/github/cotrin8672/itemindicator/render/ItemOverlay;", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/gui/Font;", "textRenderer", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "xOffset", "yOffset", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)Z", "itemindicator"})
public final class ShulkerBoxOverlayRenderer
implements ItemOverlay {
    @NotNull
    public static final ShulkerBoxOverlayRenderer INSTANCE = new ShulkerBoxOverlayRenderer();

    private ShulkerBoxOverlayRenderer() {
    }

    @Override
    public boolean render(@NotNull GuiGraphics guiGraphics, @NotNull Font textRenderer, @NotNull ItemStack stack, int xOffset, int yOffset) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!ItemIndicator.INSTANCE.getCONFIG().getRenderShulkerBoxOverlay()) {
            return false;
        }
        Pair<Set<ItemStack>, Double> pair = ItemStackExtensionKt.getContainerInfo(stack);
        Set displayStacks = (Set)pair.component1();
        double fillLevel = ((Number)pair.component2()).doubleValue();
        switch (displayStacks.size()) {
            case 1: {
                GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
                boolean bl = false;
                GuiGraphicsExtensionKt.renderItemModel($this$render_u24lambda_u240, (float)xOffset + 5.0f, (float)yOffset + 11.0f, 9.0f, (ItemStack)CollectionsKt.elementAt((Iterable)displayStacks, (int)0));
                break;
            }
            case 2: {
                GuiGraphics $this$render_u24lambda_u241 = guiGraphics;
                boolean bl = false;
                GuiGraphicsExtensionKt.renderItemModel($this$render_u24lambda_u241, (float)xOffset + 3.0f, (float)yOffset + 11.0f, 6.25f, (ItemStack)CollectionsKt.elementAt((Iterable)displayStacks, (int)0));
                GuiGraphicsExtensionKt.renderItemModel($this$render_u24lambda_u241, (float)xOffset + 9.25f, (float)yOffset + 11.0f, 6.25f, (ItemStack)CollectionsKt.elementAt((Iterable)displayStacks, (int)1));
                break;
            }
            case 3: {
                GuiGraphics $this$render_u24lambda_u242 = guiGraphics;
                boolean bl = false;
                GuiGraphicsExtensionKt.renderItemModel($this$render_u24lambda_u242, (float)xOffset + 3.0f, (float)yOffset + 12.0f, 6.25f, (ItemStack)CollectionsKt.elementAt((Iterable)displayStacks, (int)0));
                GuiGraphicsExtensionKt.renderItemModel($this$render_u24lambda_u242, (float)xOffset + 9.25f, (float)yOffset + 12.0f, 6.25f, (ItemStack)CollectionsKt.elementAt((Iterable)displayStacks, (int)1));
                GuiGraphicsExtensionKt.renderItemModel($this$render_u24lambda_u242, (float)xOffset + 6.25f, (float)yOffset + 5.75f, 6.25f, (ItemStack)CollectionsKt.elementAt((Iterable)displayStacks, (int)2));
            }
        }
        if (fillLevel > 0.0) {
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            MatrixStackExtensionKt.withMatrixContext(poseStack, arg_0 -> ShulkerBoxOverlayRenderer.render$lambda$3(xOffset, yOffset, guiGraphics, fillLevel, arg_0));
        }
        return true;
    }

    private static final Unit render$lambda$3(int $xOffset, int $yOffset, GuiGraphics $guiGraphics, double $fillLevel, PoseStack $this$withMatrixContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMatrixContext, (String)"$this$withMatrixContext");
        int barXStart = $xOffset + 13;
        int barYStart = $yOffset + 15;
        int barXEnd = barXStart + 2;
        int barYEnd = barYStart - 12;
        $guiGraphics.fill(RenderType.guiOverlay(), barXStart, barYStart, barXEnd, barYEnd, -16777216);
        $guiGraphics.fill(RenderType.guiOverlay(), barXStart, barYStart, barXEnd - 1, barYStart - (int)((double)12 * $fillLevel), -16336452);
        return Unit.INSTANCE;
    }
}

