/*
 * Decompiled with CFR 0.152.
 */
package dev.alinco8.xaeromaps_waystones;

import dev.alinco8.xaeromaps_waystones.WaystonePointHelper;
import dev.alinco8.xaeromaps_waystones.config.Config;
import dev.alinco8.xaeromaps_waystones.packets.WaystoneActivatedPacket;
import dev.alinco8.xaeromaps_waystones.packets.WaystoneRemovedPacket;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/alinco8/xaeromaps_waystones/XaerosMapsWaystonesMod;", "", "<init>", "()V", "", "initialize", "onClientTickPost", "Lnet/blay09/mods/waystones/api/event/WaystoneActivatedEvent;", "e", "onWaystoneActivated", "(Lnet/blay09/mods/waystones/api/event/WaystoneActivatedEvent;)V", "Lnet/blay09/mods/waystones/api/event/WaystoneUpdateReceivedEvent;", "onWaystoneUpdateReceived", "(Lnet/blay09/mods/waystones/api/event/WaystoneUpdateReceivedEvent;)V", "Lnet/blay09/mods/waystones/api/event/WaystoneRemovedEvent;", "onWaystoneRemoved", "(Lnet/blay09/mods/waystones/api/event/WaystoneRemovedEvent;)V", "Lnet/blay09/mods/waystones/api/event/WaystonesListReceivedEvent;", "onWaystonesListReceived", "(Lnet/blay09/mods/waystones/api/event/WaystonesListReceivedEvent;)V", "", "MOD_ID", "Ljava/lang/String;", "xaeromaps_waystones"})
public final class XaerosMapsWaystonesMod {
    @NotNull
    public static final XaerosMapsWaystonesMod INSTANCE = new XaerosMapsWaystonesMod();
    @NotNull
    public static final String MOD_ID = "xaeromaps_waystones";

    private XaerosMapsWaystonesMod() {
    }

    public final void initialize() {
        Config.Companion.getINSTANCE().load();
        BalmEvents events = Balm.getEvents();
        events.onEvent(WaystoneActivatedEvent.class, this::onWaystoneActivated);
        events.onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        events.onEvent(WaystoneRemovedEvent.class, this::onWaystoneRemoved);
        events.onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
    }

    public final void onClientTickPost() {
        if (!((Collection)WaystonePointHelper.Companion.getQueue()).isEmpty() && class_310.method_1551().field_1724 != null && ((MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession()).getWorldManager().getCurrentWorld() != null) {
            WaystonePointHelper.Companion.processQueue();
        }
    }

    public final void onWaystoneActivated(@NotNull WaystoneActivatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0 || e.getPlayer().method_7340()) {
            return;
        }
        Waystone waystone = e.getWaystone();
        class_2338 class_23382 = waystone.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getPos(...)");
        String string2 = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = waystone.getWaystoneType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        WaystoneActivatedPacket packet = new WaystoneActivatedPacket(class_23382, string2, string3);
        if (e.getPlayer() instanceof class_3222) {
            class_1657 class_16572 = e.getPlayer();
            Intrinsics.checkNotNull((Object)class_16572, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            ServerPlayNetworking.send((class_3222)((class_3222)class_16572), (class_8710)packet);
        }
    }

    public final void onWaystoneUpdateReceived(@NotNull WaystoneUpdateReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        Waystone waystone = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone, (String)"getWaystone(...)");
        WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
    }

    public final void onWaystoneRemoved(@NotNull WaystoneRemovedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        Waystone waystone = e.getWaystone();
        class_2338 class_23382 = waystone.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getPos(...)");
        String string2 = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        WaystoneRemovedPacket packet = new WaystoneRemovedPacket(class_23382, string2);
        class_310 instance = class_310.method_1551();
        class_1132 class_11322 = instance.method_1576();
        if (class_11322 == null) {
            return;
        }
        for (class_3222 player : PlayerLookup.all((MinecraftServer)((MinecraftServer)class_11322))) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    public final void onWaystonesListReceived(@NotNull WaystonesListReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (Waystone waystone : e.getWaystones()) {
            String string = waystone.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (((CharSequence)string).length() == 0) continue;
            Intrinsics.checkNotNull((Object)waystone);
            WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
        }
    }
}

