/*
 * Decompiled with CFR 0.152.
 */
package dev.alinco8.xaeromaps_waystones;

import dev.alinco8.xaeromaps_waystones.WaystonePointHelper;
import dev.alinco8.xaeromaps_waystones.config.Config;
import dev.alinco8.xaeromaps_waystones.packets.WaystoneActivatedPacket;
import dev.alinco8.xaeromaps_waystones.packets.WaystoneRemovedPacket;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/alinco8/xaeromaps_waystones/XaerosMapsWaystonesMod;", "", "<init>", "()V", "MOD_ID", "", "initialize", "", "onClientTickPost", "onWaystoneActivated", "e", "Lnet/blay09/mods/waystones/api/event/WaystoneActivatedEvent;", "onWaystoneUpdateReceived", "Lnet/blay09/mods/waystones/api/event/WaystoneUpdateReceivedEvent;", "onWaystoneRemoved", "Lnet/blay09/mods/waystones/api/event/WaystoneRemovedEvent;", "onWaystonesListReceived", "Lnet/blay09/mods/waystones/api/event/WaystonesListReceivedEvent;", "xaeromaps_waystones"})
public final class XaerosMapsWaystonesMod {
    @NotNull
    public static final XaerosMapsWaystonesMod INSTANCE = new XaerosMapsWaystonesMod();
    @NotNull
    public static final String MOD_ID = "xaeromaps_waystones";

    private XaerosMapsWaystonesMod() {
    }

    public final void initialize() {
        Config.Companion.getINSTANCE().load();
        BalmEvents events = Balm.getEvents();
        events.onEvent(WaystoneActivatedEvent.class, this::onWaystoneActivated);
        events.onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        events.onEvent(WaystoneRemovedEvent.class, this::onWaystoneRemoved);
        events.onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
    }

    public final void onClientTickPost() {
        if (!((Collection)WaystonePointHelper.Companion.getQueue()).isEmpty() && Minecraft.getInstance().player != null && ((MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession()).getWorldManager().getCurrentWorld() != null) {
            WaystonePointHelper.Companion.processQueue();
        }
    }

    public final void onWaystoneActivated(@NotNull WaystoneActivatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0 || e.getPlayer().isLocalPlayer()) {
            return;
        }
        Waystone waystone = e.getWaystone();
        BlockPos blockPos = waystone.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        String string2 = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = waystone.getWaystoneType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        WaystoneActivatedPacket packet = new WaystoneActivatedPacket(blockPos, string2, string3);
        Player player = e.getPlayer();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void onWaystoneUpdateReceived(@NotNull WaystoneUpdateReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        Waystone waystone = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone, (String)"getWaystone(...)");
        WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
    }

    public final void onWaystoneRemoved(@NotNull WaystoneRemovedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        Waystone waystone = e.getWaystone();
        BlockPos blockPos = waystone.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        String string2 = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        WaystoneRemovedPacket packet = new WaystoneRemovedPacket(blockPos, string2);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void onWaystonesListReceived(@NotNull WaystonesListReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (Waystone waystone : e.getWaystones()) {
            String string = waystone.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (((CharSequence)string).length() == 0) continue;
            Intrinsics.checkNotNull((Object)waystone);
            WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
        }
    }
}

