/*
 * Decompiled with CFR 0.152.
 */
package dev.alinco8.xaeromaps_waystones;

import dev.alinco8.xaeromaps_waystones.WaystonePointHelper;
import dev.alinco8.xaeromaps_waystones.config.Config;
import dev.alinco8.xaeromaps_waystones.packets.WaystoneActivatedPacket;
import dev.alinco8.xaeromaps_waystones.packets.WaystoneRemovedPacket;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ldev/alinco8/xaeromaps_waystones/XaerosMapsWaystonesMod;", "", "<init>", "()V", "MOD_ID", "", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "initialize", "", "onClientTickPost", "onWaystoneActivated", "e", "Lnet/blay09/mods/waystones/api/event/WaystoneActivatedEvent;", "onWaystoneUpdateReceived", "Lnet/blay09/mods/waystones/api/event/WaystoneUpdateReceivedEvent;", "onWaystoneRemoved", "Lnet/blay09/mods/waystones/api/event/WaystoneRemovedEvent;", "onWaystonesListReceived", "Lnet/blay09/mods/waystones/api/event/WaystonesListReceivedEvent;", "xaeromaps_waystones"})
public final class XaerosMapsWaystonesMod {
    @NotNull
    public static final XaerosMapsWaystonesMod INSTANCE = new XaerosMapsWaystonesMod();
    @NotNull
    public static final String MOD_ID = "xaeromaps_waystones";
    private static final Logger LOGGER = LogManager.getLogger((String)"xaeromaps_waystones");

    private XaerosMapsWaystonesMod() {
    }

    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final void initialize() {
        LOGGER.info("Initializing XaerosMapsWaystonesMod...");
        Config.Companion.getINSTANCE().load();
        BalmEvents events = Balm.getEvents();
        events.onEvent(WaystoneActivatedEvent.class, this::onWaystoneActivated);
        events.onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        events.onEvent(WaystoneRemovedEvent.class, this::onWaystoneRemoved);
        events.onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
    }

    public final void onClientTickPost() {
        if (!((Collection)WaystonePointHelper.Companion.getQueue()).isEmpty() && ((MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession()).getWorldManager().getCurrentWorld() != null) {
            WaystonePointHelper.Companion.processQueue();
        }
    }

    public final void onWaystoneActivated(@NotNull WaystoneActivatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LOGGER.debug("Waystone activated: {} at {}", (Object)e.getWaystone().getName().getString(), (Object)e.getWaystone().getPos());
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0 || e.getPlayer().isLocalPlayer()) {
            return;
        }
        Waystone waystone = e.getWaystone();
        BlockPos blockPos = waystone.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        String string2 = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = waystone.getWaystoneType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        WaystoneActivatedPacket packet = new WaystoneActivatedPacket(blockPos, string2, string3);
        Player player = e.getPlayer();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void onWaystoneUpdateReceived(@NotNull WaystoneUpdateReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LOGGER.debug("Waystone update received: {} at {}", (Object)e.getWaystone().getName().getString(), (Object)e.getWaystone().getPos());
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        Waystone waystone = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone, (String)"getWaystone(...)");
        WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
    }

    public final void onWaystoneRemoved(@NotNull WaystoneRemovedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LOGGER.debug("Waystone removed: {} at {}", (Object)e.getWaystone().getName().getString(), (Object)e.getWaystone().getPos());
        String string = e.getWaystone().getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        Waystone waystone = e.getWaystone();
        BlockPos blockPos = waystone.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        String string2 = waystone.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        WaystoneRemovedPacket packet = new WaystoneRemovedPacket(blockPos, string2);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void onWaystonesListReceived(@NotNull WaystonesListReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LOGGER.debug("Waystones list received: {} waystones", (Object)e.getWaystones().size());
        for (Waystone waystone : e.getWaystones()) {
            String string = waystone.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (((CharSequence)string).length() == 0) continue;
            Intrinsics.checkNotNull((Object)waystone);
            WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
        }
    }
}

