/*
 * Decompiled with CFR 0.152.
 */
package dev.alinco8.xaeromaps_waystones;

import dev.alinco8.xaeromaps_waystones.ManagerWatcher;
import dev.alinco8.xaeromaps_waystones.WaystonePointHelper;
import dev.alinco8.xaeromaps_waystones.XaerosMapsWaystonesModKt;
import dev.alinco8.xaeromaps_waystones.config.Config;
import dev.alinco8.xaeromaps_waystones.network.NetworkUtils;
import dev.alinco8.xaeromaps_waystones.network.WaystoneActivatedPacket;
import dev.alinco8.xaeromaps_waystones.network.WaystoneRemovedPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Ldev/alinco8/xaeromaps_waystones/XaerosMapsWaystonesMod;", "", "<init>", "()V", "MOD_ID", "", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "initialize", "", "onLeaveWorld", "onWaystoneActivated", "e", "Lnet/blay09/mods/waystones/api/event/WaystoneActivatedEvent;", "onWaystoneUpdateReceived", "Lnet/blay09/mods/waystones/api/event/WaystoneUpdateReceivedEvent;", "onWaystoneRemoved", "Lnet/blay09/mods/waystones/api/event/WaystoneRemovedEvent;", "onWaystonesListReceived", "Lnet/blay09/mods/waystones/api/event/WaystonesListReceivedEvent;", "xaeromaps_waystones"})
public final class XaerosMapsWaystonesMod {
    @NotNull
    public static final XaerosMapsWaystonesMod INSTANCE = new XaerosMapsWaystonesMod();
    @NotNull
    public static final String MOD_ID = "xaeromaps_waystones";
    @NotNull
    private static final Logger LOGGER;

    private XaerosMapsWaystonesMod() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final void initialize() {
        Config.Companion.getINSTANCE().load();
        BalmEvents events = Balm.getEvents();
        events.onEvent(WaystoneActivatedEvent.class, this::onWaystoneActivated);
        events.onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        events.onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
        events.onEvent(WaystoneRemovedEvent.class, this::onWaystoneRemoved);
    }

    public final void onLeaveWorld() {
        ManagerWatcher.INSTANCE.stopWatching();
    }

    public final void onWaystoneActivated(@NotNull WaystoneActivatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Waystone waystone = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone, (String)"getWaystone(...)");
        if (((CharSequence)XaerosMapsWaystonesModKt.nameString(waystone)).length() == 0 || e.getPlayer().isLocalPlayer()) {
            return;
        }
        Waystone waystone2 = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone2, (String)"getWaystone(...)");
        LOGGER.debug("Activated waystone: {} at {}", (Object)XaerosMapsWaystonesModKt.nameString(waystone2), (Object)e.getWaystone().getPos());
        Waystone waystone3 = e.getWaystone();
        BlockPos blockPos = waystone3.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        Intrinsics.checkNotNull((Object)waystone3);
        String string = XaerosMapsWaystonesModKt.nameString(waystone3);
        String string2 = waystone3.getWaystoneType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        WaystoneActivatedPacket packet = new WaystoneActivatedPacket(blockPos, string, string2);
        Player player = e.getPlayer();
        if (player instanceof ServerPlayer) {
            NetworkUtils.Companion.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet);
        }
    }

    public final void onWaystoneUpdateReceived(@NotNull WaystoneUpdateReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Waystone waystone = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone, (String)"getWaystone(...)");
        if (((CharSequence)XaerosMapsWaystonesModKt.nameString(waystone)).length() == 0) {
            return;
        }
        Waystone waystone2 = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone2, (String)"getWaystone(...)");
        LOGGER.debug("Updated waystone: {} at {}", (Object)XaerosMapsWaystonesModKt.nameString(waystone2), (Object)e.getWaystone().getPos());
        Waystone waystone3 = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone3, (String)"getWaystone(...)");
        WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone3);
    }

    public final void onWaystoneRemoved(@NotNull WaystoneRemovedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Waystone waystone = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone, (String)"getWaystone(...)");
        if (((CharSequence)XaerosMapsWaystonesModKt.nameString(waystone)).length() == 0) {
            return;
        }
        Waystone waystone2 = e.getWaystone();
        Intrinsics.checkNotNullExpressionValue((Object)waystone2, (String)"getWaystone(...)");
        LOGGER.debug("Removed waystone: {} at {}", (Object)XaerosMapsWaystonesModKt.nameString(waystone2), (Object)e.getWaystone().getPos());
        Waystone waystone3 = e.getWaystone();
        BlockPos blockPos = waystone3.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        Intrinsics.checkNotNull((Object)waystone3);
        String string = XaerosMapsWaystonesModKt.nameString(waystone3);
        String string2 = e.getWaystone().getWaystoneType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        WaystoneRemovedPacket packet = new WaystoneRemovedPacket(blockPos, string, string2);
        NetworkUtils.Companion.sendToAllPlayers((CustomPacketPayload)packet);
    }

    public final void onWaystonesListReceived(@NotNull WaystonesListReceivedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (Waystone waystone : e.getWaystones()) {
            Intrinsics.checkNotNull((Object)waystone);
            if (((CharSequence)XaerosMapsWaystonesModKt.nameString(waystone)).length() == 0) continue;
            LOGGER.debug("Loaded waystone: {} at {}", (Object)XaerosMapsWaystonesModKt.nameString(waystone), (Object)waystone.getPos());
            WaystonePointHelper.Companion.createOrUpdateWaystonePoint(waystone);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

