/*
 * Decompiled with CFR 0.152.
 */
package net.pnordovician.world.dimension.ordovician;

import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.lepidodendron.LepidodendronConfig;
import net.lepidodendron.block.BlockPortalBlock;
import net.lepidodendron.block.BlockPortalBlockOrdovician;
import net.lepidodendron.util.BlockSounds;
import net.lepidodendron.util.Functions;
import net.lepidodendron.util.ModTriggers;
import net.lepidodendron.util.ParticlePNPortal;
import net.lepidodendron.world.biome.ordovician.BiomeOrdovician;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.pnordovician.ElementsPNOrdovicianMod;
import net.pnordovician.world.biome.ordovician.BiomeOrdovicianSeaIce;
import net.pnordovician.world.dimension.ordovician.BiomeProviderOrdovician;
import net.pnordovician.world.dimension.ordovician.ChunkProviderOrdovician;
import net.pnordovician.world.dimension.ordovician.SkyRendererOrdovician;

@ElementsPNOrdovicianMod.ModElement.Tag
public class WorldOrdovician
extends ElementsPNOrdovicianMod.ModElement {
    public static int DIMID = LepidodendronConfig.dimOrdovician;
    public static final boolean NETHER_TYPE = false;
    @GameRegistry.ObjectHolder(value="lepidodendron:ordovician_portal")
    public static final BlockCustomPortal portal = new BlockCustomPortal();
    public static DimensionType dtype;
    public static final IRenderHandler skyRenderer;

    public WorldOrdovician(ElementsPNOrdovicianMod instance) {
        super(instance, 1590);
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new BlockCustomPortal());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (DimensionManager.isDimensionRegistered((int)DIMID)) {
            System.err.println("Prehistoric Nature loading error! Dimension ID for the Ordovician dimension is already registered by another mod: " + DIMID);
            return;
        }
        dtype = DimensionType.register((String)"ordovician", (String)"_ordovician", (int)DIMID, WorldProviderMod.class, (boolean)false);
        DimensionManager.registerDimension((int)DIMID, (DimensionType)dtype);
    }

    static {
        skyRenderer = new SkyRendererOrdovician();
    }

    public static class GenLayerBiomesCustom
    extends GenLayer {
        private Biome[] allowedBiomes = new Biome[]{(Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("lepidodendron:ordovician_land")), (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("lepidodendron:ordovician_biome")), (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("lepidodendron:ordovician_sea"))};

        public GenLayerBiomesCustom(long seed) {
            super(seed);
        }

        public int[] func_75904_a(int x, int z, int width, int depth) {
            int[] dest = IntCache.func_76445_a((int)(width * depth));
            for (int dz = 0; dz < depth; ++dz) {
                for (int dx = 0; dx < width; ++dx) {
                    this.func_75903_a(dx + x, dz + z);
                    dest[dx + dz * width] = Biome.func_185362_a((Biome)this.allowedBiomes[this.func_75902_a(this.allowedBiomes.length)]);
                }
            }
            return dest;
        }
    }

    public static class BlockCustomPortal
    extends BlockPortal {
        public BlockCustomPortal() {
            this.func_149711_c(-1.0f);
            this.func_149663_c("pf_ordovician_portal");
            this.setRegistryName("lepidodendron:ordovician_portal");
            this.func_149715_a(0.0f);
        }

        public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        }

        public boolean portalSpawn(World worldIn, BlockPos pos) {
            Size portalsize = new Size(worldIn, pos, EnumFacing.Axis.X);
            if (portalsize.isValid() && portalsize.portalBlockCount == 0) {
                portalsize.placePortalBlocks();
                return true;
            }
            portalsize = new Size(worldIn, pos, EnumFacing.Axis.Z);
            if (portalsize.isValid() && portalsize.portalBlockCount == 0) {
                portalsize.placePortalBlocks();
                return true;
            }
            return false;
        }

        public BlockPattern.PatternHelper func_181089_f(World worldIn, BlockPos p_181089_2_) {
            EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
            Size blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.X);
            LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
            if (!blockportal$size.isValid()) {
                enumfacing$axis = EnumFacing.Axis.X;
                blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.Z);
            }
            if (!blockportal$size.isValid()) {
                return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
            }
            int[] aint = new int[EnumFacing.AxisDirection.values().length];
            EnumFacing enumfacing = blockportal$size.rightDir.func_176735_f();
            BlockPos blockpos = blockportal$size.bottomLeft.func_177981_b(blockportal$size.getHeight() - 1);
            for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
                BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
                for (int i = 0; i < blockportal$size.getWidth(); ++i) {
                    for (int j = 0; j < blockportal$size.getHeight(); ++j) {
                        BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                        if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                        int n = enumfacing$axisdirection.ordinal();
                        aint[n] = aint[n] + 1;
                    }
                }
            }
            EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
            for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
                if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
                enumfacing$axisdirection1 = enumfacing$axisdirection2;
            }
            return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
        }

        public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
            Size blockportal$size1;
            EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
            if (enumfacing$axis == EnumFacing.Axis.X) {
                Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X);
                if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                    worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    BlockPortalBlock.unsetPortalAnimation((World)worldIn, (BlockPos)pos, (boolean)true);
                }
            } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                BlockPortalBlock.unsetPortalAnimation((World)worldIn, (BlockPos)pos, (boolean)false);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
            SoundEvent soundEvent;
            if (random.nextInt(80) == 0 && (soundEvent = Functions.getDimensionLivingSound((int)3, (World)world)) != null) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (random.nextInt(160) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BlockSounds.PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
            }
            for (int i = 0; i < 4; ++i) {
                double d0 = (float)pos.func_177958_n() + random.nextFloat();
                double d1 = (float)pos.func_177956_o() + random.nextFloat();
                double d2 = (float)pos.func_177952_p() + random.nextFloat();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                int j = random.nextInt(2) * 2 - 1;
                if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                    d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    d3 = random.nextFloat() * 2.0f * (float)j;
                } else {
                    d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    d5 = random.nextFloat() * 2.0f * (float)j;
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticlePNPortal.PortalParticleFactory.createParticle((World)world, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)0.3164f, (float)0.5664f, (float)0.5586f));
            }
        }

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            if (!worldIn.field_72995_K && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn instanceof EntityPlayerMP) {
                EntityPlayerMP thePlayer = (EntityPlayerMP)entityIn;
                if (thePlayer.field_71088_bW > 0) {
                    thePlayer.field_71088_bW = 10;
                } else if (thePlayer.field_71093_bK != DIMID) {
                    thePlayer.field_71088_bW = 10;
                    ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)thePlayer, (Object)true, (String)"invulnerableDimensionChange", (String)"field_184851_cj");
                    if (LepidodendronConfig.oneWayPortals) {
                        BlockCustomPortal.transferPlayerToDimensionPN(thePlayer.field_71133_b.func_184103_al(), thePlayer, DIMID, BlockCustomPortal.getTeleporterForDimension((Entity)thePlayer, pos, DIMID));
                    } else {
                        thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, DIMID, (Teleporter)BlockCustomPortal.getTeleporterForDimension((Entity)thePlayer, pos, DIMID));
                    }
                    if (thePlayer.field_71093_bK == DIMID) {
                        BlockPos spawnPos = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v).func_177972_a(thePlayer.func_174811_aO());
                        if (thePlayer.field_70170_p.func_180495_p(spawnPos).func_185913_b()) {
                            spawnPos = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v).func_177972_a(thePlayer.func_174811_aO().func_176734_d());
                        }
                        if (thePlayer.field_70170_p.func_180495_p(spawnPos).func_185913_b()) {
                            spawnPos = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v);
                        }
                        thePlayer.func_180473_a(spawnPos, true);
                        ModTriggers.ENTER_ORDOVICIAN.trigger(thePlayer);
                    }
                } else if (!LepidodendronConfig.oneWayPortals) {
                    thePlayer.field_71088_bW = 10;
                    ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)thePlayer, (Object)true, (String)"invulnerableDimensionChange", (String)"field_184851_cj");
                    thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, 0, (Teleporter)BlockCustomPortal.getTeleporterForDimension((Entity)thePlayer, pos, 0));
                    if (thePlayer.field_71093_bK == 0) {
                        BlockPos spawnPos = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v).func_177972_a(thePlayer.func_174811_aO());
                        if (thePlayer.field_70170_p.func_180495_p(spawnPos).func_185913_b()) {
                            spawnPos = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v).func_177972_a(thePlayer.func_174811_aO().func_176734_d());
                        }
                        if (thePlayer.field_70170_p.func_180495_p(spawnPos).func_185913_b()) {
                            spawnPos = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v);
                        }
                        thePlayer.func_180473_a(spawnPos, true);
                    }
                }
            }
        }

        public static void transferPlayerToDimensionPN(PlayerList playerList, EntityPlayerMP player, int dimensionIn, Teleporter teleporter) {
            BlockCustomPortal.transferPlayerToDimensionPN(playerList, player, dimensionIn, (ITeleporter)teleporter);
        }

        public static void transferPlayerToDimensionPN(PlayerList playerList, EntityPlayerMP player, int dimensionIn, ITeleporter teleporter) {
            int i = player.field_71093_bK;
            WorldServer worldserver = playerList.func_72365_p().func_71218_a(player.field_71093_bK);
            player.field_71093_bK = dimensionIn;
            WorldServer worldserver1 = playerList.func_72365_p().func_71218_a(player.field_71093_bK);
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, worldserver1.func_175659_aa(), worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            playerList.func_187243_f(player);
            worldserver.func_72973_f((Entity)player);
            player.field_70128_L = false;
            BlockCustomPortal.transferEntityToWorldPN(playerList, (Entity)player, i, worldserver, worldserver1, teleporter);
            playerList.func_72375_a(player, worldserver);
            player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(worldserver1);
            player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
            playerList.func_72354_b(player, worldserver1);
            playerList.func_72385_f(player);
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
            }
            AttributeMap attributemap = (AttributeMap)player.func_110140_aT();
            Collection watchedAttribs = attributemap.func_111160_c();
            if (!watchedAttribs.isEmpty()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(player.func_145782_y(), watchedAttribs));
            }
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, i, dimensionIn);
        }

        public static void transferEntityToWorldPN(PlayerList playerList, Entity entityIn, int lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn, ITeleporter teleporter) {
            double moveFactor = oldWorldIn.field_73011_w.getMovementFactor() / toWorldIn.field_73011_w.getMovementFactor();
            double d0 = MathHelper.func_151237_a((double)(entityIn.field_70165_t * moveFactor), (double)(toWorldIn.func_175723_af().func_177726_b() + 16.0), (double)(toWorldIn.func_175723_af().func_177728_d() - 16.0));
            double d1 = MathHelper.func_151237_a((double)(entityIn.field_70161_v * moveFactor), (double)(toWorldIn.func_175723_af().func_177736_c() + 16.0), (double)(toWorldIn.func_175723_af().func_177733_e() - 16.0));
            double d2 = 8.0;
            float f = entityIn.field_70177_z;
            oldWorldIn.field_72984_F.func_76320_a("moving");
            IBlockState portalBlockState = Functions.getPortalBlockState((int)lastDimension);
            IBlockState portalState = Functions.getPortalState((int)lastDimension);
            if (entityIn.field_71093_bK == 1 && teleporter.isVanilla()) {
                BlockPos blockpos = lastDimension == 1 ? toWorldIn.func_175694_M() : toWorldIn.func_180504_m();
                d0 = blockpos.func_177958_n();
                entityIn.field_70163_u = blockpos.func_177956_o();
                d1 = blockpos.func_177952_p();
                entityIn.func_70012_b(d0, entityIn.field_70163_u, d1, 90.0f, 0.0f);
                if (entityIn.func_70089_S()) {
                    oldWorldIn.func_72866_a(entityIn, false);
                }
            }
            oldWorldIn.field_72984_F.func_76319_b();
            if (lastDimension != 1 || !teleporter.isVanilla()) {
                oldWorldIn.field_72984_F.func_76320_a("placing");
                d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
                d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
                if (entityIn.func_70089_S()) {
                    entityIn.func_70012_b(d0, entityIn.field_70163_u, d1, entityIn.field_70177_z, entityIn.field_70125_A);
                    oldWorldIn.func_72866_a(entityIn, false);
                    ((TeleporterDimensionMod)teleporter).placeEntityPN((World)toWorldIn, entityIn, f, portalBlockState, portalState);
                    toWorldIn.func_72838_d(entityIn);
                    toWorldIn.func_72866_a(entityIn, false);
                }
                oldWorldIn.field_72984_F.func_76319_b();
            }
            entityIn.func_70029_a((World)toWorldIn);
        }

        public static TeleporterDimensionMod getTeleporterForDimension(Entity entity, BlockPos pos, int dimid) {
            BlockPattern.PatternHelper bph = portal.func_181089_f(entity.field_70170_p, new BlockPos((Vec3i)pos));
            double d0 = bph.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)bph.func_181117_a().func_177952_p() : (double)bph.func_181117_a().func_177958_n();
            double d1 = bph.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? entity.field_70161_v : entity.field_70165_t;
            d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(bph.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)bph.func_181118_d())));
            double d2 = MathHelper.func_181160_c((double)(entity.field_70163_u - 1.0), (double)bph.func_181117_a().func_177956_o(), (double)(bph.func_181117_a().func_177956_o() - bph.func_181119_e()));
            return new TeleporterDimensionMod(entity.func_184102_h().func_71218_a(dimid), new Vec3d(d1, d2, 0.0), bph.func_177669_b());
        }

        public static class Size {
            private final World world;
            private final EnumFacing.Axis axis;
            private final EnumFacing rightDir;
            private final EnumFacing leftDir;
            private int portalBlockCount;
            private BlockPos bottomLeft;
            private int height;
            private int width;

            public Size(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_) {
                this.world = worldIn;
                this.axis = p_i45694_3_;
                if (p_i45694_3_ == EnumFacing.Axis.X) {
                    this.leftDir = EnumFacing.EAST;
                    this.rightDir = EnumFacing.WEST;
                } else {
                    this.leftDir = EnumFacing.NORTH;
                    this.rightDir = EnumFacing.SOUTH;
                }
                BlockPos blockpos = p_i45694_2_;
                while (p_i45694_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i45694_2_.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(p_i45694_2_.func_177977_b()).func_177230_c())) {
                    p_i45694_2_ = p_i45694_2_.func_177977_b();
                }
                int i = this.getDistanceUntilEdge(p_i45694_2_, this.leftDir) - 1;
                if (i >= 0) {
                    this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
                    this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                    if (this.width < 2 || this.width > 21) {
                        this.bottomLeft = null;
                        this.width = 0;
                    }
                }
                if (this.bottomLeft != null) {
                    this.height = this.calculatePortalHeight();
                }
            }

            protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
                BlockPos blockpos;
                int i;
                for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c()) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c(); ++i) {
                }
                Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
                return block == BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c() ? i : 0;
            }

            public int getHeight() {
                return this.height;
            }

            public int getWidth() {
                return this.width;
            }

            protected int calculatePortalHeight() {
                this.height = 0;
                block0: while (this.height < 21) {
                    for (int i = 0; i < this.width; ++i) {
                        BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                        Block block = this.world.func_180495_p(blockpos).func_177230_c();
                        if (!this.isEmptyBlock(block)) break block0;
                        if (block == portal) {
                            ++this.portalBlockCount;
                        }
                        if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c() : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c()) break block0;
                    }
                    ++this.height;
                }
                for (int j = 0; j < this.width; ++j) {
                    if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c()) continue;
                    this.height = 0;
                    break;
                }
                if (this.height <= 21 && this.height >= 3) {
                    return this.height;
                }
                this.bottomLeft = null;
                this.width = 0;
                this.height = 0;
                return 0;
            }

            protected boolean isEmptyBlock(Block blockIn) {
                return blockIn.func_176223_P().func_185904_a() == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == portal;
            }

            public boolean isValid() {
                return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
            }

            public void placePortalBlocks() {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                    for (int j = 0; j < this.height; ++j) {
                        this.world.func_180501_a(blockpos.func_177981_b(j), portal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                        BlockPortalBlock.setPortalAnimation((World)this.world, (BlockPos)blockpos.func_177981_b(j), (this.axis != EnumFacing.Axis.Z ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    public static class TeleporterDimensionMod
    extends Teleporter {
        private Vec3d lastPortalVec;
        private EnumFacing teleportDirection;

        public TeleporterDimensionMod(WorldServer worldServer, Vec3d lastPortalVec, EnumFacing teleportDirection) {
            super(worldServer);
            this.lastPortalVec = lastPortalVec;
            this.teleportDirection = teleportDirection;
        }

        public boolean func_85188_a(Entity entityIn) {
            int i = 16;
            double d0 = -1.0;
            int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int k = MathHelper.func_76128_c((double)entityIn.field_70163_u);
            int l = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            int i1 = j;
            int j1 = k;
            int k1 = l;
            int l1 = 0;
            int i2 = this.field_77187_a.nextInt(4);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j2 = j - 16; j2 <= j + 16; ++j2) {
                double d1 = (double)j2 + 0.5 - entityIn.field_70165_t;
                for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                    double d2 = (double)l2 + 0.5 - entityIn.field_70161_v;
                    block2: for (int j3 = this.field_85192_a.func_72940_L() - 1; j3 >= 0; --j3) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2))) continue;
                        while (j3 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2))) {
                            --j3;
                        }
                        for (int k3 = i2; k3 < i2 + 4; ++k3) {
                            int l3 = k3 % 2;
                            int i4 = 1 - l3;
                            if (k3 % 4 >= 2) {
                                l3 = -l3;
                                i4 = -i4;
                            }
                            for (int j4 = 0; j4 < 3; ++j4) {
                                for (int k4 = 0; k4 < 4; ++k4) {
                                    for (int l4 = -1; l4 < 4; ++l4) {
                                        int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                        int j5 = j3 + l4;
                                        int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                        blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                        if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() && this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                    }
                                }
                            }
                            double d5 = (double)j3 + 0.5 - entityIn.field_70163_u;
                            double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                            if (!(d0 < 0.0) && !(d7 < d0)) continue;
                            d0 = d7;
                            i1 = j2;
                            j1 = j3;
                            k1 = l2;
                            l1 = k3 % 4;
                        }
                    }
                }
            }
            if (d0 < 0.0) {
                for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                    double d3 = (double)l5 + 0.5 - entityIn.field_70165_t;
                    for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                        double d4 = (double)j6 + 0.5 - entityIn.field_70161_v;
                        block10: for (int i7 = this.field_85192_a.func_72940_L() - 1; i7 >= 0; --i7) {
                            if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6))) continue;
                            while (i7 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6))) {
                                --i7;
                            }
                            for (int k7 = i2; k7 < i2 + 2; ++k7) {
                                int j8 = k7 % 2;
                                int j9 = 1 - j8;
                                for (int j10 = 0; j10 < 4; ++j10) {
                                    for (int j11 = -1; j11 < 4; ++j11) {
                                        int j12 = l5 + (j10 - 1) * j8;
                                        int i13 = i7 + j11;
                                        int j13 = j6 + (j10 - 1) * j9;
                                        blockpos$mutableblockpos.func_181079_c(j12, i13, j13);
                                        if (j11 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() && this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h || j11 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                    }
                                }
                                double d6 = (double)i7 + 0.5 - entityIn.field_70163_u;
                                double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                                if (!(d0 < 0.0) && !(d8 < d0)) continue;
                                d0 = d8;
                                i1 = l5;
                                j1 = i7;
                                k1 = j6;
                                l1 = k7 % 2;
                            }
                        }
                    }
                }
            }
            int i6 = i1;
            int k2 = j1;
            int k6 = k1;
            int l6 = l1 % 2;
            int i3 = 1 - l6;
            if (l1 % 4 >= 2) {
                l6 = -l6;
                i3 = -i3;
            }
            if (d0 < 0.0) {
                k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
                for (int j7 = -1; j7 <= 1; ++j7) {
                    for (int l7 = 1; l7 < 3; ++l7) {
                        for (int k8 = -1; k8 < 3; ++k8) {
                            int k9 = i6 + (l7 - 1) * l6 + j7 * i3;
                            int k10 = k2 + k8;
                            int k11 = k6 + (l7 - 1) * i3 - j7 * l6;
                            boolean flag = k8 < 0;
                            this.field_85192_a.func_175656_a(new BlockPos(k9, k10 + 1, k11), flag ? BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c().func_176223_P() : Blocks.field_150350_a.func_176223_P());
                            if (!flag) continue;
                            BlockPortalBlock.setPortalAsActive((World)this.field_85192_a, (BlockPos)new BlockPos(k9, k10 + 1, k11), (boolean)true, (int)90);
                        }
                    }
                }
            }
            IBlockState iblockstate = portal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(l6 == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
            for (int i8 = 0; i8 < 4; ++i8) {
                for (int l8 = 0; l8 < 4; ++l8) {
                    for (int l9 = -1; l9 < 4; ++l9) {
                        int l10 = i6 + (l8 - 1) * l6;
                        int l11 = k2 + l9;
                        int k12 = k6 + (l8 - 1) * i3;
                        boolean flag1 = l8 == 0 || l8 == 3 || l9 == -1 || l9 == 3;
                        this.field_85192_a.func_180501_a(new BlockPos(l10, l11 + 1, k12), flag1 ? BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c().func_176223_P() : iblockstate, 2);
                        if (flag1) {
                            BlockPortalBlock.setPortalAsActive((World)this.field_85192_a, (BlockPos)new BlockPos(l10, l11 + 1, k12), (boolean)true, (int)90);
                            continue;
                        }
                        BlockPortalBlock.setPortalAnimation((World)this.field_85192_a, (BlockPos)new BlockPos(l10, l11 + 1, k12), (l6 != 0 ? 1 : 0) != 0);
                    }
                }
                for (int i9 = 0; i9 < 4; ++i9) {
                    for (int i10 = -1; i10 < 4; ++i10) {
                        int i11 = i6 + (i9 - 1) * l6;
                        int i12 = k2 + i10;
                        int l12 = k6 + (i9 - 1) * i3;
                        BlockPos blockpos = new BlockPos(i11, i12 + 1, l12);
                        this.field_85192_a.func_175685_c(blockpos, this.field_85192_a.func_180495_p(blockpos).func_177230_c(), false);
                    }
                }
            }
            return true;
        }

        public void placeEntityPN(World world, Entity entity, float yaw, @Nullable IBlockState portalBlockstate, @Nullable IBlockState portalState) {
            if (entity instanceof EntityPlayerMP) {
                this.placeInPortalPN(entity, yaw, portalBlockstate, portalState);
            } else {
                this.placeInExistingPortalPN(entity, yaw, portalBlockstate, portalState);
            }
        }

        public void placeInPortalPN(Entity entityIn, float rotationYaw, @Nullable IBlockState portalBlockstate, @Nullable IBlockState portalState) {
            if (portalBlockstate == null) {
                this.placeInExistingPortalPN(entityIn, rotationYaw, portalBlockstate, portalState);
            } else if (!this.placeInExistingPortalPN(entityIn, rotationYaw, portalBlockstate, portalState)) {
                this.makePortalPN(entityIn, portalBlockstate, portalState);
                this.placeInExistingPortalPN(entityIn, rotationYaw, portalBlockstate, portalState);
            }
        }

        public boolean placeInExistingPortalPN(Entity entityIn, float rotationYaw, @Nullable IBlockState portalBlockstate, @Nullable IBlockState portalState) {
            if (portalBlockstate == null) {
                return true;
            }
            int i = 128;
            double d0 = -1.0;
            int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            boolean flag = true;
            BlockPos blockpos = BlockPos.field_177992_a;
            long l = ChunkPos.func_77272_a((int)j, (int)k);
            if (this.field_85191_c.containsKey(l)) {
                Teleporter.PortalPosition teleporter$portalposition = (Teleporter.PortalPosition)this.field_85191_c.get(l);
                d0 = 0.0;
                blockpos = teleporter$portalposition;
                teleporter$portalposition.field_85087_d = this.field_85192_a.func_82737_E();
                flag = false;
            } else {
                BlockPos blockpos3 = new BlockPos(entityIn);
                for (int i1 = -128; i1 <= 128; ++i1) {
                    for (int j1 = -128; j1 <= 128; ++j1) {
                        BlockPos blockpos1 = blockpos3.func_177982_a(i1, this.field_85192_a.func_72940_L() - 1 - blockpos3.func_177956_o(), j1);
                        while (blockpos1.func_177956_o() >= 0) {
                            BlockPos blockpos2 = blockpos1.func_177977_b();
                            if (this.field_85192_a.func_180495_p(blockpos1).func_177230_c() == portalState.func_177230_c()) {
                                blockpos2 = blockpos1.func_177977_b();
                                while (this.field_85192_a.func_180495_p(blockpos2).func_177230_c() == portalState.func_177230_c()) {
                                    blockpos1 = blockpos2;
                                    blockpos2 = blockpos2.func_177977_b();
                                }
                                double d1 = blockpos1.func_177951_i((Vec3i)blockpos3);
                                if (d0 < 0.0 || d1 < d0) {
                                    d0 = d1;
                                    blockpos = blockpos1;
                                }
                            }
                            blockpos1 = blockpos2;
                        }
                    }
                }
            }
            if (d0 >= 0.0) {
                if (flag) {
                    this.field_85191_c.put(l, (Object)new Teleporter.PortalPosition((Teleporter)this, blockpos, this.field_85192_a.func_82737_E()));
                }
                double d5 = (double)blockpos.func_177958_n() + 0.5;
                double d7 = (double)blockpos.func_177952_p() + 0.5;
                BlockPattern.PatternHelper blockpattern$patternhelper = portal.func_181089_f((World)this.field_85192_a, blockpos);
                boolean flag1 = blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
                double d2 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
                double d6 = (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() + 1) - this.lastPortalVec.field_72448_b * (double)blockpattern$patternhelper.func_181119_e();
                if (flag1) {
                    d2 += 1.0;
                }
                if (blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
                    d7 = d2 + (1.0 - this.lastPortalVec.field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
                } else {
                    d5 = d2 + (1.0 - this.lastPortalVec.field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
                }
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                if (blockpattern$patternhelper.func_177669_b().func_176734_d() == this.teleportDirection) {
                    f = 1.0f;
                    f1 = 1.0f;
                } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == this.teleportDirection.func_176734_d()) {
                    f = -1.0f;
                    f1 = -1.0f;
                } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == this.teleportDirection.func_176746_e()) {
                    f2 = 1.0f;
                    f3 = -1.0f;
                } else {
                    f2 = -1.0f;
                    f3 = 1.0f;
                }
                double d3 = entityIn.field_70159_w;
                double d4 = entityIn.field_70179_y;
                entityIn.field_70159_w = d3 * (double)f + d4 * (double)f3;
                entityIn.field_70179_y = d3 * (double)f2 + d4 * (double)f1;
                entityIn.field_70177_z = rotationYaw - (float)(this.teleportDirection.func_176734_d().func_176736_b() * 90) + (float)(blockpattern$patternhelper.func_177669_b().func_176736_b() * 90);
                if (entityIn instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
                } else {
                    entityIn.func_70012_b(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
                }
                return true;
            }
            return false;
        }

        public boolean makePortalPN(Entity entityIn, @Nullable IBlockState portalBlockstate, @Nullable IBlockState portalState) {
            int i = 16;
            double d0 = -1.0;
            int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int k = MathHelper.func_76128_c((double)entityIn.field_70163_u);
            int l = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            int i1 = j;
            int j1 = k;
            int k1 = l;
            int l1 = 0;
            int i2 = this.field_77187_a.nextInt(4);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j2 = j - 16; j2 <= j + 16; ++j2) {
                double d1 = (double)j2 + 0.5 - entityIn.field_70165_t;
                for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                    double d2 = (double)l2 + 0.5 - entityIn.field_70161_v;
                    block2: for (int j3 = this.field_85192_a.func_72940_L() - 1; j3 >= 0; --j3) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2))) continue;
                        while (j3 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2))) {
                            --j3;
                        }
                        for (int k3 = i2; k3 < i2 + 4; ++k3) {
                            int l3 = k3 % 2;
                            int i4 = 1 - l3;
                            if (k3 % 4 >= 2) {
                                l3 = -l3;
                                i4 = -i4;
                            }
                            for (int j4 = 0; j4 < 3; ++j4) {
                                for (int k4 = 0; k4 < 4; ++k4) {
                                    for (int l4 = -1; l4 < 4; ++l4) {
                                        int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                        int j5 = j3 + l4;
                                        int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                        blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                        if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() && this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                    }
                                }
                            }
                            double d5 = (double)j3 + 0.5 - entityIn.field_70163_u;
                            double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                            if (!(d0 < 0.0) && !(d7 < d0)) continue;
                            d0 = d7;
                            i1 = j2;
                            j1 = j3;
                            k1 = l2;
                            l1 = k3 % 4;
                        }
                    }
                }
            }
            if (d0 < 0.0) {
                for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                    double d3 = (double)l5 + 0.5 - entityIn.field_70165_t;
                    for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                        double d4 = (double)j6 + 0.5 - entityIn.field_70161_v;
                        block10: for (int i7 = this.field_85192_a.func_72940_L() - 1; i7 >= 0; --i7) {
                            if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6))) continue;
                            while (i7 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6))) {
                                --i7;
                            }
                            for (int k7 = i2; k7 < i2 + 2; ++k7) {
                                int j8 = k7 % 2;
                                int j9 = 1 - j8;
                                for (int j10 = 0; j10 < 4; ++j10) {
                                    for (int j11 = -1; j11 < 4; ++j11) {
                                        int j12 = l5 + (j10 - 1) * j8;
                                        int i13 = i7 + j11;
                                        int j13 = j6 + (j10 - 1) * j9;
                                        blockpos$mutableblockpos.func_181079_c(j12, i13, j13);
                                        if (j11 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() && this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h || j11 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                    }
                                }
                                double d6 = (double)i7 + 0.5 - entityIn.field_70163_u;
                                double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                                if (!(d0 < 0.0) && !(d8 < d0)) continue;
                                d0 = d8;
                                i1 = l5;
                                j1 = i7;
                                k1 = j6;
                                l1 = k7 % 2;
                            }
                        }
                    }
                }
            }
            int i6 = i1;
            int k2 = j1;
            int k6 = k1;
            int l6 = l1 % 2;
            int i3 = 1 - l6;
            if (l1 % 4 >= 2) {
                l6 = -l6;
                i3 = -i3;
            }
            if (d0 < 0.0) {
                k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
                for (int j7 = -1; j7 <= 1; ++j7) {
                    for (int l7 = 1; l7 < 3; ++l7) {
                        for (int k8 = -1; k8 < 3; ++k8) {
                            int k9 = i6 + (l7 - 1) * l6 + j7 * i3;
                            int k10 = k2 + k8;
                            int k11 = k6 + (l7 - 1) * i3 - j7 * l6;
                            boolean flag = k8 < 0;
                            this.field_85192_a.func_175656_a(new BlockPos(k9, k10 + 1, k11), flag ? portalBlockstate : Blocks.field_150350_a.func_176223_P());
                            if (!flag) continue;
                            BlockPortalBlock.setPortalAsActive((World)this.field_85192_a, (BlockPos)new BlockPos(k9, k10 + 1, k11), (boolean)true, (int)90);
                        }
                    }
                }
            }
            IBlockState iblockstate = portalState.func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(l6 == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
            for (int i8 = 0; i8 < 4; ++i8) {
                for (int l8 = 0; l8 < 4; ++l8) {
                    for (int l9 = -1; l9 < 4; ++l9) {
                        int l10 = i6 + (l8 - 1) * l6;
                        int l11 = k2 + l9;
                        int k12 = k6 + (l8 - 1) * i3;
                        boolean flag1 = l8 == 0 || l8 == 3 || l9 == -1 || l9 == 3;
                        this.field_85192_a.func_180501_a(new BlockPos(l10, l11 + 1, k12), flag1 ? portalBlockstate : iblockstate, 2);
                        if (flag1) {
                            BlockPortalBlock.setPortalAsActive((World)this.field_85192_a, (BlockPos)new BlockPos(l10, l11 + 1, k12), (boolean)true, (int)90);
                            continue;
                        }
                        BlockPortalBlock.setPortalAnimation((World)this.field_85192_a, (BlockPos)new BlockPos(l10, l11 + 1, k12), (l6 != 0 ? 1 : 0) != 0);
                    }
                }
                for (int i9 = 0; i9 < 4; ++i9) {
                    for (int i10 = -1; i10 < 4; ++i10) {
                        int i11 = i6 + (i9 - 1) * l6;
                        int i12 = k2 + i10;
                        int l12 = k6 + (i9 - 1) * i3;
                        BlockPos blockpos = new BlockPos(i11, i12 + 1, l12);
                        this.field_85192_a.func_175685_c(blockpos, this.field_85192_a.func_180495_p(blockpos).func_177230_c(), false);
                    }
                }
            }
            return true;
        }

        public void func_180266_a(Entity entityIn, float rotationYaw) {
            if (this.field_85192_a.field_73011_w.func_186058_p().func_186068_a() != 1) {
                if (!this.func_180620_b(entityIn, rotationYaw)) {
                    this.func_85188_a(entityIn);
                    this.func_180620_b(entityIn, rotationYaw);
                }
            } else {
                int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
                int j = MathHelper.func_76128_c((double)entityIn.field_70163_u) - 1;
                int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
                boolean l = true;
                boolean i1 = false;
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        for (int l1 = -1; l1 < 3; ++l1) {
                            int i2 = i + k1 * 1 + j1 * 0;
                            int j2 = j + l1;
                            int k2 = k + k1 * 0 - j1 * 1;
                            boolean flag = l1 < 0;
                            this.field_85192_a.func_175656_a(new BlockPos(i2, j2, k2), flag ? BlockPortalBlockOrdovician.block.func_176223_P().func_177230_c().func_176223_P() : Blocks.field_150350_a.func_176223_P());
                            if (!flag) continue;
                            BlockPortalBlock.setPortalAsActive((World)this.field_85192_a, (BlockPos)new BlockPos(i2, j2, k2), (boolean)true, (int)90);
                        }
                    }
                }
                entityIn.func_70012_b((double)i, (double)j, (double)k, entityIn.field_70177_z, 0.0f);
                entityIn.field_70159_w = 0.0;
                entityIn.field_70181_x = 0.0;
                entityIn.field_70179_y = 0.0;
            }
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            int i = 128;
            double d0 = -1.0;
            int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            boolean flag = true;
            BlockPos blockpos = BlockPos.field_177992_a;
            long l = ChunkPos.func_77272_a((int)j, (int)k);
            if (this.field_85191_c.containsKey(l)) {
                Teleporter.PortalPosition teleporter$portalposition = (Teleporter.PortalPosition)this.field_85191_c.get(l);
                d0 = 0.0;
                blockpos = teleporter$portalposition;
                teleporter$portalposition.field_85087_d = this.field_85192_a.func_82737_E();
                flag = false;
            } else {
                BlockPos blockpos3 = new BlockPos(entityIn);
                for (int i1 = -128; i1 <= 128; ++i1) {
                    for (int j1 = -128; j1 <= 128; ++j1) {
                        BlockPos blockpos1 = blockpos3.func_177982_a(i1, this.field_85192_a.func_72940_L() - 1 - blockpos3.func_177956_o(), j1);
                        while (blockpos1.func_177956_o() >= 0) {
                            BlockPos blockpos2 = blockpos1.func_177977_b();
                            if (this.field_85192_a.func_180495_p(blockpos1).func_177230_c() == portal) {
                                blockpos2 = blockpos1.func_177977_b();
                                while (this.field_85192_a.func_180495_p(blockpos2).func_177230_c() == portal) {
                                    blockpos1 = blockpos2;
                                    blockpos2 = blockpos2.func_177977_b();
                                }
                                double d1 = blockpos1.func_177951_i((Vec3i)blockpos3);
                                if (d0 < 0.0 || d1 < d0) {
                                    d0 = d1;
                                    blockpos = blockpos1;
                                }
                            }
                            blockpos1 = blockpos2;
                        }
                    }
                }
            }
            if (d0 >= 0.0) {
                if (flag) {
                    this.field_85191_c.put(l, (Object)new Teleporter.PortalPosition((Teleporter)this, blockpos, this.field_85192_a.func_82737_E()));
                }
                double d5 = (double)blockpos.func_177958_n() + 0.5;
                double d7 = (double)blockpos.func_177952_p() + 0.5;
                BlockPattern.PatternHelper blockpattern$patternhelper = portal.func_181089_f((World)this.field_85192_a, blockpos);
                boolean flag1 = blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
                double d2 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
                double d6 = (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() + 1) - this.lastPortalVec.field_72448_b * (double)blockpattern$patternhelper.func_181119_e();
                if (flag1) {
                    d2 += 1.0;
                }
                if (blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
                    d7 = d2 + (1.0 - this.lastPortalVec.field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
                } else {
                    d5 = d2 + (1.0 - this.lastPortalVec.field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
                }
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                if (blockpattern$patternhelper.func_177669_b().func_176734_d() == this.teleportDirection) {
                    f = 1.0f;
                    f1 = 1.0f;
                } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == this.teleportDirection.func_176734_d()) {
                    f = -1.0f;
                    f1 = -1.0f;
                } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == this.teleportDirection.func_176746_e()) {
                    f2 = 1.0f;
                    f3 = -1.0f;
                } else {
                    f2 = -1.0f;
                    f3 = 1.0f;
                }
                double d3 = entityIn.field_70159_w;
                double d4 = entityIn.field_70179_y;
                entityIn.field_70159_w = d3 * (double)f + d4 * (double)f3;
                entityIn.field_70179_y = d3 * (double)f2 + d4 * (double)f1;
                entityIn.field_70177_z = rotationYaw - (float)(this.teleportDirection.func_176734_d().func_176736_b() * 90) + (float)(blockpattern$patternhelper.func_177669_b().func_176736_b() * 90);
                if (entityIn instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
                } else {
                    entityIn.func_70012_b(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
                }
                return true;
            }
            return false;
        }
    }

    public static class WorldProviderMod
    extends WorldProvider {
        public void func_76572_b() {
            this.field_76578_c = new BiomeProviderOrdovician(this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H());
            this.field_76576_e = false;
            this.field_191067_f = true;
        }

        @SideOnly(value=Side.CLIENT)
        public IRenderHandler getSkyRenderer() {
            if (LepidodendronConfig.renderCustomSkies) {
                boolean isShaders = false;
                if (FMLClientHandler.instance().hasOptifine()) {
                    String strFile = null;
                    try {
                        strFile = Minecraft.func_71410_x().field_71412_D.getCanonicalPath() + "\\optionsshaders.txt";
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new FileReader(strFile));
                        while ((line = reader.readLine()) != null) {
                            if (!line.startsWith("shaderPack=") || line.substring(11).equalsIgnoreCase("(internal)") || line.substring(11).equalsIgnoreCase("OFF")) continue;
                            isShaders = true;
                        }
                        reader.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (isShaders) {
                    return super.getSkyRenderer();
                }
                return skyRenderer;
            }
            return super.getSkyRenderer();
        }

        public Biome getBiomeForCoords(BlockPos pos) {
            Biome b = super.getBiomeForCoords(pos);
            if (b instanceof BiomeOrdovician) {
                return b;
            }
            return BiomeOrdovicianSeaIce.biome;
        }

        public DimensionType func_186058_p() {
            return dtype;
        }

        @SideOnly(value=Side.CLIENT)
        public Vec3d func_76562_b(float par1, float par2) {
            if (!LepidodendronConfig.renderFog) {
                return super.func_76562_b(par1, par2);
            }
            float f2 = MathHelper.func_76134_b((float)(par1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            float f3 = 0.8862745f;
            float f4 = 1.0f;
            float f5 = 0.7529412f;
            return new Vec3d((double)(f3 *= f2 * 0.94f + 0.06f), (double)(f4 *= f2 * 0.94f + 0.06f), (double)(f5 *= f2 * 0.91f + 0.09f));
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderOrdovician(this.field_76579_a, this.field_76579_a.func_72905_C() - (long)DIMID);
        }

        public double getMovementFactor() {
            double scaler = LepidodendronConfig.worldDimensionScaler;
            if (scaler < 0.01) {
                scaler = 0.01;
            }
            if (scaler > 100.0) {
                scaler = 100.0;
            }
            return 1.0 / scaler;
        }

        public boolean func_76569_d() {
            return true;
        }

        public boolean func_76567_e() {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76568_b(int par1, int par2) {
            if (!LepidodendronConfig.renderFog) {
                return super.func_76568_b(par1, par2);
            }
            return false;
        }

        public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
            return WorldProvider.WorldSleepResult.ALLOW;
        }

        public boolean func_177500_n() {
            return false;
        }
    }
}

