/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.neoforged.fml.classloading.SecureJar;
import net.neoforged.fml.loading.moddiscovery.locators.JarInJarDependencyLocator;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrashAssistantDependencyLocator
extends JarInJarDependencyLocator
implements IDependencyLocator {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CrashAssistantDependencyLocator");

    public void scanMods(List<IModFile> loadedMods, IDiscoveryPipeline pipeline) {
        try {
            SecureJar secureJar = SecureJar.from((Path[])new Path[]{Path.of(CrashAssistantDependencyLocator.class.getProtectionDomain().getCodeSource().getLocation().toURI())});
            IModFile modFile = IModFile.create((SecureJar)secureJar, JarModsDotTomlModFileReader::manifestParser);
            Method loadModFileFromMethod = JarInJarDependencyLocator.class.getDeclaredMethod("loadModFileFrom", IModFile.class, String.class, IDiscoveryPipeline.class, Map.class);
            loadModFileFromMethod.setAccessible(true);
            HashMap createdModFiles = new HashMap();
            Optional neoForgeMod = (Optional)loadModFileFromMethod.invoke((Object)this, modFile, "META-INF/jarjar/crash_assistant-neoforge.jar", pipeline, createdModFiles);
            pipeline.addModFile((IModFile)neoForgeMod.get());
        }
        catch (Exception e) {
            LOGGER.error("Error while adding crash_assistant-neoforge.jar to pipeline: ", (Throwable)e);
        }
    }
}

