/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperImpl;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ProcessHelperProcessHandleImpl
implements ProcessHelperImpl {
    private final MethodHandle mh_current;
    private final MethodHandle mh_of;
    private final MethodHandle mh_pid;
    private final MethodHandle mh_info;
    private final MethodHandle mh_command;
    private final MethodHandle mh_startInstant;
    private final MethodHandle mh_isAlive;
    private final MethodHandle mh_children;
    private final MethodHandle mh_destroy;
    private final MethodHandle mh_destroyForcibly;

    public ProcessHelperProcessHandleImpl() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Class<?> infoClass = Class.forName("java.lang.ProcessHandle$Info");
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            this.mh_current = lookup.findStatic(phClass, "current", MethodType.methodType(phClass));
            this.mh_of = lookup.findStatic(phClass, "of", MethodType.methodType(Optional.class, Long.TYPE));
            this.mh_pid = lookup.findVirtual(phClass, "pid", MethodType.methodType(Long.TYPE));
            this.mh_info = lookup.findVirtual(phClass, "info", MethodType.methodType(infoClass));
            this.mh_command = lookup.findVirtual(infoClass, "command", MethodType.methodType(Optional.class));
            this.mh_startInstant = lookup.findVirtual(infoClass, "startInstant", MethodType.methodType(Optional.class));
            this.mh_isAlive = lookup.findVirtual(phClass, "isAlive", MethodType.methodType(Boolean.TYPE));
            this.mh_children = lookup.findVirtual(phClass, "children", MethodType.methodType(Stream.class));
            this.mh_destroy = lookup.findVirtual(phClass, "destroy", MethodType.methodType(Boolean.TYPE));
            this.mh_destroyForcibly = lookup.findVirtual(phClass, "destroyForcibly", MethodType.methodType(Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("ProcessHandle API not found \u2013 are you on Java 9+ ?", e);
        }
    }

    @Override
    public long getCurrentProcessId() {
        try {
            Object ph = this.mh_current.invoke();
            return this.mh_pid.invoke(ph);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("current PID", t);
        }
    }

    @Override
    public Optional<String> getCurrentProcessCommand() {
        try {
            Object ph = this.mh_current.invoke();
            Object info = this.mh_info.invoke(ph);
            return this.mh_command.invoke(info);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("current command", t);
        }
    }

    @Override
    public long getCurrentProcessStartTime() {
        try {
            Object ph = this.mh_current.invoke();
            Object info = this.mh_info.invoke(ph);
            Optional ins = this.mh_startInstant.invoke(info);
            return ins.map(Instant::toEpochMilli).orElse(-1L);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("current start time", t);
        }
    }

    @Override
    public long getProcessStartTime(long pid) {
        try {
            Object ph = this.handleOf(pid);
            if (ph == null) {
                return -1L;
            }
            Object info = this.mh_info.invoke(ph);
            Optional ins = this.mh_startInstant.invoke(info);
            return ins.map(Instant::toEpochMilli).orElse(-1L);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("start time for pid " + pid, t);
        }
    }

    @Override
    public boolean isProcessAlive(long pid) {
        try {
            Object ph = this.handleOf(pid);
            return ph != null && this.mh_isAlive.invoke(ph);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("liveness check for pid " + pid, t);
        }
    }

    @Override
    public String getChildProcessesInfo() {
        try {
            Object current = this.mh_current.invoke();
            Stream children = this.mh_children.invoke(current);
            String joined = children.map(ph -> {
                try {
                    long cpid = this.mh_pid.invoke(ph);
                    Object info = this.mh_info.invoke(ph);
                    Optional ins = this.mh_startInstant.invoke(info);
                    return ins.map(i -> cpid + ": " + i.toEpochMilli()).orElse(null);
                }
                catch (Throwable t) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.joining("\n"));
            children.close();
            return joined;
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("child-process list", t);
        }
    }

    @Override
    public boolean destroyProcess(long pid) {
        try {
            Object ph = this.handleOf(pid);
            return ph != null && this.mh_destroy.invoke(ph);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("destroy pid " + pid, t);
        }
    }

    @Override
    public boolean destroyProcessForcibly(long pid) {
        try {
            Object ph = this.handleOf(pid);
            return ph != null && this.mh_destroyForcibly.invoke(ph);
        }
        catch (Throwable t) {
            throw ProcessHelperProcessHandleImpl.fail("forcible destroy pid " + pid, t);
        }
    }

    private Object handleOf(long pid) throws Throwable {
        Optional opt = this.mh_of.invoke(pid);
        return opt.orElse(null);
    }

    private static RuntimeException fail(String what, Throwable t) {
        return new RuntimeException("Failed to obtain " + what + " using ProcessHandle", t);
    }
}

