/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.WinReg;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleLinuxImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleMacOSImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleWinImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperProcessHandleImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.crash_assistant.ExitVMBypass;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class ProcessHelper {
    private static final ProcessHelperImpl impl;

    public static long getCurrentProcessId() {
        return impl.getCurrentProcessId();
    }

    public static Optional<String> getCurrentProcessCommand() {
        return impl.getCurrentProcessCommand();
    }

    public static long getCurrentProcessStartTime() {
        return impl.getCurrentProcessStartTime();
    }

    public static long getProcessStartTime(long pid) {
        return impl.getProcessStartTime(pid);
    }

    public static boolean isProcessAlive(long pid) {
        return impl.isProcessAlive(pid);
    }

    public static String getChildProcessesInfo() {
        return impl.getChildProcessesInfo();
    }

    public static boolean destroyProcess(long pid) {
        return impl.destroyProcess(pid);
    }

    public static boolean destroyProcessForcibly(long pid) {
        return impl.destroyProcessForcibly(pid);
    }

    public static void exitProcess(int status) {
        ExitVMBypass.exit(status);
    }

    public static String getJavaVersion() {
        return System.getProperty("java.runtime.version", "UNDEFINED");
    }

    public static List<Class<?>> getNeededForAppClasses() {
        ArrayList classes = new ArrayList();
        classes.add(LogManager.class);
        classes.add(LoggerContext.class);
        classes.add(ReversedLinesFileReader.class);
        classes.add(Memory.class);
        classes.add(Tlhelp32.class);
        return classes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProcessorName() {
        try {
            List<String> cmd;
            if (PlatformHelp.isWindows()) {
                String name = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "ProcessorNameString");
                if (name == null) return "UNKNOWN";
                if ((name = name.trim()).isEmpty()) return "UNKNOWN";
                return name;
            }
            if (PlatformHelp.isLinux()) {
                cmd = Arrays.asList("bash", "-c", "grep -m1 \"model name\" /proc/cpuinfo | cut -d ':' -f2");
            } else {
                if (!PlatformHelp.isMacOS()) return "UNKNOWN";
                cmd = Arrays.asList("sysctl", "-n", "machdep.cpu.brand_string");
            }
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                process.destroy();
                return "UNKNOWN";
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return "UNKNOWN";
                } while ((line = line.trim()).isEmpty() || PlatformHelp.isWindows() && line.equalsIgnoreCase("Name"));
                String string = line;
                return string;
            }
        }
        catch (Throwable e) {
            JarInJarHelper.LOGGER.error("Error while getting processor name:", e);
            return "UNKNOWN";
        }
    }

    static {
        ProcessHelperImpl tempImpl;
        block4: {
            tempImpl = null;
            try {
                Class.forName("java.lang.ProcessHandle");
                tempImpl = new ProcessHelperProcessHandleImpl();
            }
            catch (Exception e) {
                String osName = System.getProperty("os.name").toLowerCase();
                if (PlatformHelp.isWindows()) {
                    tempImpl = new ProcessHandleWinImpl();
                }
                if (PlatformHelp.isLinux()) {
                    tempImpl = new ProcessHandleLinuxImpl();
                }
                if (!PlatformHelp.isMacOS()) break block4;
                tempImpl = new ProcessHandleMacOSImpl();
            }
        }
        impl = tempImpl;
    }
}

