/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleAbstractImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ProcessHandleWinImpl
extends ProcessHandleAbstractImpl {
    private static final int PROCESS_QUERY_LIMITED_INFORMATION = 4096;
    private static final int PROCESS_TERMINATE = 1;
    private static final int SYNCHRONIZE = 0x100000;
    private static final int WAIT_TIMEOUT = 258;
    private static final Kernel32Ext K32 = Kernel32Ext.INSTANCE;

    private static WinNT.HANDLE openProcess(long pid, int access) {
        return Kernel32.INSTANCE.OpenProcess(access, false, (int)pid);
    }

    private static void closeHandle(WinNT.HANDLE h) {
        if (h != null && !WinBase.INVALID_HANDLE_VALUE.equals(h)) {
            Kernel32.INSTANCE.CloseHandle(h);
        }
    }

    private static long toEpochMillis(FILETIMEX ft) {
        long v = (long)ft.dwHighDateTime << 32 | (long)ft.dwLowDateTime & 0xFFFFFFFFL;
        return v / 10000L - 11644473600000L;
    }

    @Override
    public long getCurrentProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public Optional<String> getCurrentProcessCommand() {
        IntByReference len;
        char[] buf;
        WinNT.HANDLE self = Kernel32.INSTANCE.GetCurrentProcess();
        return K32.QueryFullProcessImageNameW(self, 0, buf = new char[520], len = new IntByReference(buf.length)) ? Optional.of(Native.toString(buf)) : Optional.empty();
    }

    @Override
    public long getCurrentProcessStartTime() {
        return this.getProcessStartTime(this.getCurrentProcessId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getProcessStartTime(long pid) {
        WinNT.HANDLE h = ProcessHandleWinImpl.openProcess(pid, 0x101000);
        if (h == null) {
            return -1L;
        }
        try {
            int wait = Kernel32.INSTANCE.WaitForSingleObject(h, 0);
            if (wait != 258) {
                long l = -1L;
                return l;
            }
            FILETIMEX create = new FILETIMEX();
            boolean ok = K32.GetProcessTimes(h, create, new FILETIMEX(), new FILETIMEX(), new FILETIMEX());
            long l = ok ? ProcessHandleWinImpl.toEpochMillis(create) : -1L;
            return l;
        }
        finally {
            ProcessHandleWinImpl.closeHandle(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProcessAlive(long pid) {
        WinNT.HANDLE h = ProcessHandleWinImpl.openProcess(pid, 0x100000);
        if (h == null) {
            return false;
        }
        try {
            boolean bl = Kernel32.INSTANCE.WaitForSingleObject(h, 0) == 258;
            return bl;
        }
        finally {
            ProcessHandleWinImpl.closeHandle(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildProcessesInfo() {
        long parent = this.getCurrentProcessId();
        WinNT.HANDLE snap = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        if (WinBase.INVALID_HANDLE_VALUE.equals(snap)) {
            return "";
        }
        ArrayList<String> rows = new ArrayList<String>();
        try {
            PROCESSENTRY32Fix e = new PROCESSENTRY32Fix();
            if (Kernel32.INSTANCE.Process32First(snap, e)) {
                do {
                    long child;
                    long start;
                    if (e.th32ParentProcessID.longValue() != parent || (start = this.getProcessStartTime(child = e.th32ProcessID.longValue())) == -1L) continue;
                    rows.add(child + ": " + start);
                } while (Kernel32.INSTANCE.Process32Next(snap, e));
            }
        }
        finally {
            ProcessHandleWinImpl.closeHandle(snap);
        }
        return String.join((CharSequence)"\n", rows);
    }

    @Override
    public boolean destroyProcess(long pid) {
        return ProcessHandleWinImpl.terminate(pid);
    }

    @Override
    public boolean destroyProcessForcibly(long pid) {
        return ProcessHandleWinImpl.terminate(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean terminate(long pid) {
        WinNT.HANDLE h = ProcessHandleWinImpl.openProcess(pid, 1);
        if (h == null) {
            return false;
        }
        try {
            boolean bl = Kernel32.INSTANCE.TerminateProcess(h, 1);
            return bl;
        }
        finally {
            ProcessHandleWinImpl.closeHandle(h);
        }
    }

    private static interface Kernel32Ext
    extends Kernel32 {
        public static final Kernel32Ext INSTANCE = Native.loadLibrary("kernel32", Kernel32Ext.class);

        public boolean QueryFullProcessImageNameW(WinNT.HANDLE var1, int var2, char[] var3, IntByReference var4);

        public boolean GetProcessTimes(WinNT.HANDLE var1, FILETIMEX var2, FILETIMEX var3, FILETIMEX var4, FILETIMEX var5);
    }

    public static class PROCESSENTRY32Fix
    extends Tlhelp32.PROCESSENTRY32.ByReference {
        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("dwSize", "cntUsage", "th32ProcessID", "th32DefaultHeapID", "th32ModuleID", "cntThreads", "th32ParentProcessID", "pcPriClassBase", "dwFlags", "szExeFile");
        }

        public PROCESSENTRY32Fix() {
            this.dwSize = new WinDef.DWORD((long)this.size());
        }
    }

    public static class FILETIMEX
    extends Structure {
        public int dwLowDateTime;
        public int dwHighDateTime;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("dwLowDateTime", "dwHighDateTime");
        }

        boolean isZero() {
            return this.dwLowDateTime == 0 && this.dwHighDateTime == 0;
        }

        public static class ByReference
        extends FILETIMEX
        implements Structure.ByReference {
        }
    }
}

