/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.forge;

import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common.commands.CrashAssistantCommands;
import dev.kostromdan.mods.crash_assistant.common.events.CrashAssistantEvents;
import dev.kostromdan.mods.crash_assistant.forge_coremod.CrashAssistantHooks;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="crash_assistant", version="1.10.0", name="Crash Assistant", acceptedMinecraftVersions="[1.12.2]")
public final class CrashAssistantForge {
    private boolean mainMenuOpened = false;
    private int ticksAfterMainMenu = 0;
    private static final int TICKS_TO_WAIT = 1;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            CrashAssistant.init();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            this.registerClientCommands();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            CrashAssistantHooks.afterMinecraftInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerClientCommands() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CrashAssistantCommands());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        CrashAssistantEvents.onGameJoin();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mainMenuOpened) {
            ++this.ticksAfterMainMenu;
            if (this.ticksAfterMainMenu >= 1) {
                CrashAssistantHooks.onClientLoaded();
                this.mainMenuOpened = false;
                this.ticksAfterMainMenu = 0;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            this.mainMenuOpened = true;
            this.ticksAfterMainMenu = 0;
        }
    }
}

