/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.loading_utils;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarLocatingException;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class LibrariesJarLocator {
    public static String getLibraryJarPath(Class cls) throws JarLocatingException, URISyntaxException {
        return LibrariesJarLocator.getLibraryJarPath(cls, true);
    }

    public static String getLibraryJarPath(Class cls, boolean checkExistence) throws JarLocatingException, URISyntaxException {
        Path path = LibrariesJarLocator.getPathFromClass(cls);
        if (path == null) {
            throw new JarLocatingException("getPathFromClass returned null, class: " + cls.getName());
        }
        if (checkExistence && !path.toFile().exists()) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + String.valueOf(cls) + "',but it does not exist; path: `" + String.valueOf(path));
        }
        if (checkExistence && !Files.isRegularFile(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + String.valueOf(cls) + "',but it is not regular file; path: `" + String.valueOf(path));
        }
        return path.toAbsolutePath().toString();
    }

    public static String getOurModJarPath() throws JarLocatingException, URISyntaxException {
        try {
            String result = LibrariesJarLocator.getLibraryJarPath(JarInJarHelper.class);
            if (!PlatformHelp.modLoadedWithConnector) {
                return result;
            }
            Path jarPath = Paths.get(result, new String[0]);
            String fileNameMapped = jarPath.getFileName().toString();
            Path modsFolder = jarPath.getParent().getParent();
            String modNameOriginal = fileNameMapped.split("_mapped_")[0] + ".jar";
            return modsFolder.resolve(modNameOriginal).toAbsolutePath().toString();
        }
        catch (Exception e) {
            if (PlatformHelp.platform == PlatformHelp.QUILT) {
                try {
                    Class<?> fabricLoaderClass = Class.forName("net.fabricmc.loader.api.FabricLoader");
                    Method getInstanceMethod = fabricLoaderClass.getMethod("getInstance", new Class[0]);
                    Object loaderInstance = getInstanceMethod.invoke(null, new Object[0]);
                    Method getModContainerMethod = fabricLoaderClass.getMethod("getModContainer", String.class);
                    Optional modContainerOptional = (Optional)getModContainerMethod.invoke(loaderInstance, "crash_assistant");
                    if (modContainerOptional.isPresent()) {
                        Object modContainer = modContainerOptional.get();
                        Method getOriginMethod = modContainer.getClass().getMethod("getOrigin", new Class[0]);
                        Object modOrigin = getOriginMethod.invoke(modContainer, new Object[0]);
                        Method getPathsMethod = modOrigin.getClass().getMethod("getPaths", new Class[0]);
                        List originPaths = (List)getPathsMethod.invoke(modOrigin, new Object[0]);
                        return originPaths.stream().filter(p -> p.toString().toLowerCase().endsWith(".jar")).findFirst().map(p -> p.toAbsolutePath().toString()).orElseThrow(() -> new JarLocatingException("Could not find JAR path from Quilt ModOrigin paths"));
                    }
                    throw new JarLocatingException("Could not find ModContainer for 'crash_assistant' on Quilt");
                }
                catch (Exception reflectionEx) {
                    throw new JarLocatingException("Failed to get mod JAR path on Quilt via reflection: " + reflectionEx.getMessage());
                }
            }
            throw e;
        }
    }

    public static String getLibraryJarPathFromResource(String resource) throws JarLocatingException {
        Path path = LibrariesJarLocator.getPathFromResource(resource);
        if (path == null) {
            throw new JarLocatingException("getPathFromClass returned null, resource: " + resource);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + resource + "',but it does not exist; path: `" + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + resource + "',but it is not regular file; path: `" + String.valueOf(path));
        }
        String absolutePath = path.toAbsolutePath().toString();
        if (!absolutePath.endsWith(".jar")) {
            throw new JarLocatingException("Successfully parsed path of `" + resource + "',but it is not .jar file" + String.valueOf(path));
        }
        return absolutePath;
    }

    public static Path getPathFromClass(Class cls) {
        String resourcePath = cls.getName().replace('.', '/') + ".class";
        return LibrariesJarLocator.getPathFromResource(resourcePath);
    }

    public static void setupLoaderJarName(Class cls) {
        try {
            PlatformHelp.loaderJarName = Paths.get(LibrariesJarLocator.getLibraryJarPath(cls, false), new String[0]).getFileName().toString();
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.error("Error while trying to get loader jar path: ", (Throwable)e);
        }
    }

    public static void setupLoaderJarName(String version) {
        PlatformHelp.loaderJarName = version;
    }

    private static Path getPathFromResource(String resource) {
        ClassLoader cl;
        ArrayList<ClassLoader> toTry = new ArrayList<ClassLoader>();
        toTry.add(LibrariesJarLocator.class.getClassLoader());
        toTry.add(ClassLoader.getSystemClassLoader());
        URL url = null;
        Iterator iterator = toTry.iterator();
        while (iterator.hasNext() && (url = (cl = (ClassLoader)iterator.next()).getResource(resource)) == null) {
        }
        if (url == null) {
            return null;
        }
        return LibrariesJarLocator.getPath(url, resource);
    }

    private static Path getPath(URL url, String resource) {
        Object str = url.toString();
        int len = resource.length();
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            str = ((String)str).substring(0, ((String)str).length() - (len += 2));
        } else if ("union".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            str = "file://" + ((String)str).substring(0, ((String)str).lastIndexOf(".jar") + 4);
        }
        return Paths.get(URI.create((String)str));
    }
}

