/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.forge_coremod;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CrashAssistantTransformer
implements IClassTransformer,
Opcodes {
    public static final Logger LOGGER = LogManager.getLogger((String)"CrashAssistantTransformer");
    private static final List<String> TRANSFORM_CLASSES = Arrays.asList("net.minecraft.client.Minecraft", "net.minecraft.client.gui.GuiErrorScreen");
    private static final Map<String, String> SHUTDOWN_METHOD = new HashMap<String, String>();
    private static final Map<String, String> INIT_GUI_METHOD = new HashMap<String, String>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!TRANSFORM_CLASSES.contains(transformedName)) {
            return basicClass;
        }
        try {
            ClassNode classNode = new ClassNode();
            new ClassReader(basicClass).accept((ClassVisitor)classNode, 8);
            switch (transformedName) {
                case "net.minecraft.client.Minecraft": {
                    this.transformMinecraft(classNode);
                    break;
                }
                case "net.minecraft.client.gui.GuiErrorScreen": {
                    this.transformGuiErrorScreen(classNode);
                }
            }
            ClassWriter cw = new ClassWriter(1);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        catch (Exception ex) {
            LOGGER.error("Error while transforming class {}", new Object[]{transformedName, ex});
            return basicClass;
        }
    }

    private void transformMinecraft(ClassNode cn) {
        for (Object methodObj : cn.methods) {
            MethodNode m = (MethodNode)methodObj;
            if (!SHUTDOWN_METHOD.containsKey(m.name) || !m.desc.equals(SHUTDOWN_METHOD.get(m.name))) continue;
            CrashAssistantTransformer.injectBeforeReturn(m, "dev/kostromdan/mods/crash_assistant/forge_coremod/CrashAssistantHooks", "onMinecraftShutdown", "()V");
        }
    }

    private void transformGuiErrorScreen(ClassNode cn) {
        for (Object methodObj : cn.methods) {
            MethodNode m = (MethodNode)methodObj;
            if (!INIT_GUI_METHOD.containsKey(m.name) || !m.desc.equals(INIT_GUI_METHOD.get(m.name))) continue;
            CrashAssistantTransformer.injectBeforeReturn(m, "dev/kostromdan/mods/crash_assistant/forge_coremod/CrashAssistantHooks", "onErrorScreenInit", "()V");
        }
    }

    private static void injectBeforeReturn(MethodNode method, String owner, String name, String desc) {
        InsnList call = new InsnList();
        call.add((AbstractInsnNode)new MethodInsnNode(184, owner, name, desc, false));
        for (AbstractInsnNode insn = method.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
            if (insn.getOpcode() != 177) continue;
            method.instructions.insertBefore(insn, call);
            break;
        }
    }

    static {
        SHUTDOWN_METHOD.put("shutdown", "()V");
        SHUTDOWN_METHOD.put("n", "()V");
        INIT_GUI_METHOD.put("initGui", "()V");
        INIT_GUI_METHOD.put("b", "()V");
    }
}

