/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashAssistantDependencyLocator
extends AbstractJarFileLocator {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantDependencyLocator");

    public List<IModFile> scanMods() {
        ArrayList<IModFile> mods = new ArrayList<IModFile>();
        try {
            Path mod = JarInJarHelper.extractJarInJar("crash_assistant-forge.jar", "crash_assistant-forge.jar");
            Optional<IModFile> modFile = this.createModWithReflection(mod);
            if (modFile.isPresent()) {
                mods.add(modFile.get());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while loading crash_assistant-forge.jar from jar in jar: ", (Throwable)e);
        }
        return mods;
    }

    private Optional<IModFile> createModWithReflection(Path path) {
        try {
            try {
                Method createModMethod = AbstractJarFileLocator.class.getDeclaredMethod("createMod", Path.class);
                createModMethod.setAccessible(true);
                return (Optional)createModMethod.invoke((Object)this, path);
            }
            catch (NoSuchMethodException e) {
                Class<?> clazz = Class.forName("net.minecraftforge.fml.loading.moddiscovery.AbstractModLocator");
                Method createModMethod = clazz.getDeclaredMethod("createMod", Path[].class);
                createModMethod.setAccessible(true);
                Path[] paths = new Path[]{path};
                return (Optional)createModMethod.invoke((Object)this, new Object[]{paths});
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to access createMod method via reflection", (Throwable)e);
            return Optional.empty();
        }
    }

    public Stream<Path> scanCandidates() {
        return Stream.empty();
    }

    public String name() {
        return "CrashAssistantDependencyLocator";
    }

    public void initArguments(Map<String, ?> map) {
    }
}

