/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.loading_utils;

import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LauncherLogger {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static volatile Thread SHUTDOWN_HOOK;
    private static volatile AsyncLogWriter activeWorker;
    private static final BlockingQueue<LogEvent> LOG_QUEUE;
    private static final String LOGS_DIR_NAME = "logs";
    private static final String LOG_FILE_NAME = "stderr_stream.log";

    private LauncherLogger() {
    }

    public static void redirectToFile() {
        if (!INSTALLED.compareAndSet(false, true)) {
            return;
        }
        PrintStream originalErr = System.err;
        try {
            File logsDir = new File(LOGS_DIR_NAME);
            if (logsDir.exists() && !logsDir.isDirectory()) {
                originalErr.println("[LauncherLogger] Error: Logs path exists but is not a directory: " + logsDir.getAbsolutePath());
                INSTALLED.set(false);
                return;
            }
            if (!logsDir.exists() && !logsDir.mkdirs()) {
                originalErr.println("[LauncherLogger] Error: Failed to create logs directory: " + logsDir.getAbsolutePath());
                INSTALLED.set(false);
                return;
            }
            File logFile = new File(logsDir, LOG_FILE_NAME);
            Charset consoleCs = LauncherLogger.detectConsoleCharset(originalErr);
            FileOutputStream directConsoleStream = null;
            try {
                directConsoleStream = new FileOutputStream(FileDescriptor.err);
            }
            catch (Throwable t) {
                originalErr.println("[LauncherLogger] Warning: FileDescriptor.err unavailable; console mirroring disabled.");
            }
            AsyncLogWriter worker = new AsyncLogWriter();
            worker.init(logFile, directConsoleStream, consoleCs);
            worker.start();
            activeWorker = worker;
            AsyncQueueOutputStream queueStream = new AsyncQueueOutputStream();
            boolean injectionSuccess = LauncherLogger.injectAsyncStream(originalErr, queueStream);
            if (!injectionSuccess) {
                originalErr.println("[LauncherLogger] Warning: Stream injection failed; legacy loggers may retain blocking behavior.");
            }
            try {
                PrintStream proxyStream = new PrintStream((OutputStream)queueStream, true, consoleCs.name());
                System.setErr(proxyStream);
            }
            catch (Throwable t) {
                originalErr.println("[LauncherLogger] Warning: Failed to update System.err proxy.");
            }
            try {
                SHUTDOWN_HOOK = new Thread(() -> {
                    AsyncLogWriter w = activeWorker;
                    if (w != null) {
                        w.signalShutdown();
                    }
                }, "LauncherLogger-ShutdownHook");
                Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
            }
            catch (Throwable t) {
                originalErr.println("[LauncherLogger] Warning: Failed to register shutdown hook.");
            }
        }
        catch (Exception e) {
            try {
                System.setErr(originalErr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (activeWorker != null) {
                activeWorker.signalShutdown();
                activeWorker = null;
            }
            INSTALLED.set(false);
            e.printStackTrace(originalErr);
        }
    }

    private static boolean injectAsyncStream(PrintStream stream, OutputStream replacement) {
        if (!(stream instanceof FilterOutputStream)) {
            return false;
        }
        try {
            Object downstream;
            OutputStream current = stream;
            Field outField = FilterOutputStream.class.getDeclaredField("out");
            outField.setAccessible(true);
            while ((downstream = outField.get(current)) instanceof FilterOutputStream) {
                current = (OutputStream)downstream;
            }
            outField.set(current, replacement);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Charset detectConsoleCharset(PrintStream ps) {
        String[] props;
        for (String p : props = new String[]{"sun.stderr.encoding", "sun.stdout.encoding", "native.encoding", "file.encoding"}) {
            try {
                String v = System.getProperty(p);
                if (v == null || v.isEmpty()) continue;
                return Charset.forName(v);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Method m = PrintStream.class.getDeclaredMethod("charset", new Class[0]);
            m.setAccessible(true);
            return (Charset)m.invoke((Object)ps, new Object[0]);
        }
        catch (Throwable throwable) {
            return Charset.defaultCharset();
        }
    }

    static {
        LOG_QUEUE = new LinkedBlockingQueue<LogEvent>();
    }

    private static final class AsyncQueueOutputStream
    extends OutputStream {
        private AsyncQueueOutputStream() {
        }

        @Override
        public void write(int b) {
            LOG_QUEUE.offer(new LogEvent(b));
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            byte[] copy = new byte[len];
            System.arraycopy(b, off, copy, 0, len);
            LOG_QUEUE.offer(new LogEvent(copy));
        }

        @Override
        public void flush() {
            LOG_QUEUE.offer(new LogEvent(true));
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    private static class AsyncLogWriter
    extends Thread {
        private BufferedOutputStream fileOut;
        private OutputStream rawConsoleOut;
        private Charset charset;
        private volatile boolean running = true;
        private final SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss:SSS", Locale.ROOT);
        private final Date dateReuse = new Date();
        private boolean atLineStart = true;

        AsyncLogWriter() {
            super("LauncherLogger-Worker");
            this.setDaemon(true);
        }

        void init(File file, OutputStream rawConsole, Charset cs) throws FileNotFoundException {
            this.charset = cs;
            this.rawConsoleOut = rawConsole != null ? new BufferedOutputStream(rawConsole) : null;
            this.fileOut = new BufferedOutputStream(new FileOutputStream(file, false), 65536);
            try {
                this.writeHeader();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void signalShutdown() {
            this.running = false;
            this.interrupt();
            try {
                this.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (this.running || !LOG_QUEUE.isEmpty()) {
                try {
                    LogEvent event = (LogEvent)LOG_QUEUE.poll(500L, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    if (event.isFlush) {
                        this.performFlush();
                        continue;
                    }
                    this.processData(event);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {}
            }
            this.performFlush();
            this.closeStreams();
        }

        private void processData(LogEvent event) {
            byte[] b = event.data;
            int len = b.length;
            try {
                this.dateReuse.setTime(event.timestamp);
                String timeStr = this.timeFmt.format(this.dateReuse);
                byte[] prefixBytes = null;
                for (int i = 0; i < len; ++i) {
                    if (this.atLineStart) {
                        if (prefixBytes == null) {
                            prefixBytes = ("[" + timeStr + "] [STDERR]: ").getBytes(this.charset);
                        }
                        this.fileOut.write(prefixBytes);
                        this.atLineStart = false;
                    }
                    this.fileOut.write(b[i]);
                    if (b[i] != 10) continue;
                    this.atLineStart = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.rawConsoleOut != null) {
                try {
                    this.rawConsoleOut.write(b);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void performFlush() {
            try {
                if (this.fileOut != null) {
                    this.fileOut.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.rawConsoleOut != null) {
                    this.rawConsoleOut.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void writeHeader() throws IOException {
            String ls = System.lineSeparator();
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SSS XXX", Locale.ROOT);
            df.setTimeZone(TimeZone.getDefault());
            StringBuilder sb = new StringBuilder();
            sb.append("-----------------------------------------------------------------------------------").append(ls);
            sb.append("DateTime: ").append(df.format(new Date())).append("; PID: ").append(ProcessHelper.getCurrentProcessId()).append(ls);
            sb.append("This file contains the stderr stream of the Minecraft process logged to a file.").append(ls);
            sb.append("It does not include stdout or log (log4j) messages to avoid performance impact.").append(ls);
            sb.append("-----------------------------------------------------------------------------------").append(ls);
            this.fileOut.write(sb.toString().getBytes(this.charset));
            this.fileOut.flush();
        }

        private void closeStreams() {
            try {
                if (this.fileOut != null) {
                    this.fileOut.flush();
                    this.fileOut.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.rawConsoleOut != null) {
                    this.rawConsoleOut.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class LogEvent {
        final byte[] data;
        final long timestamp;
        final boolean isFlush;

        LogEvent(byte[] data) {
            this.data = data;
            this.timestamp = System.currentTimeMillis();
            this.isFlush = false;
        }

        LogEvent(int singleByte) {
            this.data = new byte[]{(byte)singleByte};
            this.timestamp = System.currentTimeMillis();
            this.isFlush = false;
        }

        LogEvent(boolean isFlush) {
            this.data = null;
            this.timestamp = 0L;
            this.isFlush = isFlush;
        }
    }
}

