/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Tlhelp32;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleLinuxImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleMacOSImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleWinImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperProcessHandleImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.fml.crash_assistant.ExitVMBypass;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Core;

public class ProcessHelper {
    private static final ProcessHelperImpl impl;

    public static long getCurrentProcessId() {
        return impl.getCurrentProcessId();
    }

    public static Optional<String> getCurrentProcessCommand() {
        return impl.getCurrentProcessCommand();
    }

    public static long getCurrentProcessStartTime() {
        return impl.getCurrentProcessStartTime();
    }

    public static long getProcessStartTime(long pid) {
        return impl.getProcessStartTime(pid);
    }

    public static boolean isProcessAlive(long pid) {
        return impl.isProcessAlive(pid);
    }

    public static String getChildProcessesInfo() {
        return impl.getChildProcessesInfo();
    }

    public static boolean destroyProcess(long pid) {
        return impl.destroyProcess(pid);
    }

    public static boolean destroyProcessForcibly(long pid) {
        return impl.destroyProcessForcibly(pid);
    }

    public static void exitProcess(int status) {
        ExitVMBypass.exit(status);
    }

    public static String getJavaVersion() {
        return System.getProperty("java.runtime.version", "UNDEFINED");
    }

    public static List<Class<?>> getNeededForAppClasses() {
        ArrayList classes = new ArrayList();
        classes.add(LogManager.class);
        classes.add(Core.class);
        classes.add(ReversedLinesFileReader.class);
        classes.add(Memory.class);
        classes.add(Tlhelp32.class);
        return classes;
    }

    public static String getProcessorName() {
        try {
            try {
                Class<?> sysInfoCls = Class.forName("oshi.SystemInfo");
                Object sysInfo = sysInfoCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object hardware = sysInfoCls.getMethod("getHardware", new Class[0]).invoke(sysInfo, new Object[0]);
                Object[] processors = (Object[])hardware.getClass().getMethod("getProcessors", new Class[0]).invoke(hardware, new Object[0]);
                return String.format("%s", processors[0]).replaceAll("\\s+", " ");
            }
            catch (NoSuchMethodError | NoSuchMethodException ex) {
                Class<?> systemInfoCls = Class.forName("oshi.SystemInfo");
                Object systemInfo = systemInfoCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method mGetHardware = systemInfoCls.getMethod("getHardware", new Class[0]);
                Object hardware = mGetHardware.invoke(systemInfo, new Object[0]);
                Method mGetProcessor = hardware.getClass().getMethod("getProcessor", new Class[0]);
                Object processor = mGetProcessor.invoke(hardware, new Object[0]);
                Method mGetIdentifier = processor.getClass().getMethod("getProcessorIdentifier", new Class[0]);
                Object identifier = mGetIdentifier.invoke(processor, new Object[0]);
                Method mGetName = identifier.getClass().getMethod("getName", new Class[0]);
                return (String)mGetName.invoke(identifier, new Object[0]);
            }
        }
        catch (Throwable e) {
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.matches(".*Failed to create temporary file for /com/sun/jna/.*\\.dll library: .*")) {
                JarInJarHelper.LOGGER.error(errorMessage + "\n   \n   Most likely you have permission issues in your file system.\n   OSHI failed init because it failed to create its tmp files for natives.\n   This won't crash Vanilla, but can crash many other mods using OSHI, like Embeddium.\n   Try reinstalling your launcher / trying another launcher, make sure to NOT activate admin rights on install,\n   as this is most likely the cause of this permission issue.\n    \n   If you seeing Crash Assistant in the stacktrace somewhere upper, it's not the cause of the crash!\n   It's just the first thing tried to use OSHI, which failed to init.\n   ");
            } else {
                JarInJarHelper.LOGGER.error("Error while getting processor name:", e);
            }
            return "UNKNOWN";
        }
    }

    static {
        ProcessHelperImpl tempImpl;
        block4: {
            tempImpl = null;
            try {
                Class.forName("java.lang.ProcessHandle");
                tempImpl = new ProcessHelperProcessHandleImpl();
            }
            catch (Exception e) {
                String osName = System.getProperty("os.name").toLowerCase();
                if (PlatformHelp.isWindows()) {
                    tempImpl = new ProcessHandleWinImpl();
                }
                if (PlatformHelp.isLinux()) {
                    tempImpl = new ProcessHandleLinuxImpl();
                }
                if (!PlatformHelp.isMacOS()) break block4;
                tempImpl = new ProcessHandleMacOSImpl();
            }
        }
        impl = tempImpl;
    }
}

