/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.lang;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.file.FileConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lang {
    public HashMap<String, String> lang;
    public static FileConfig BCCConfig;

    public Lang(HashMap<String, String> lang) {
        this.lang = lang;
    }

    public String get(String key) {
        return this.get(key, new HashMap<String, String>());
    }

    public String get(String key, HashMap<String, String> placeHoldersSurroundedWithHref) {
        String value = this.lang.getOrDefault(key, LanguageProvider.languages.get((Object)"en_us").lang.get(key));
        return Lang.applyPlaceHolders(value, placeHoldersSurroundedWithHref);
    }

    public static String applyPlaceHolders(String value, HashMap<String, String> placeHoldersSurroundedWithHref) {
        if (!value.contains("$")) {
            return value;
        }
        value = Lang.applyPlaceHolder("$CONFIG.", value, CrashAssistantConfig::get, placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$LANG.", value, key -> LanguageProvider.get(key, placeHoldersSurroundedWithHref), placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$BCC.", value, Lang::getBCCValue, placeHoldersSurroundedWithHref);
        value = Lang.applyPlaceHolder("$LINK.", value, LinksProvider::getLinkByKey, placeHoldersSurroundedWithHref);
        return value;
    }

    private static String applyPlaceHolder(String placeHolderStart, String value, Function<String, String> configGetFunction, HashMap<String, String> placeHoldersSurroundedWithHref) {
        while (value.contains(placeHolderStart)) {
            int placeHolderStartLength = placeHolderStart.length();
            int placeHolderStartIndex = value.indexOf(placeHolderStart);
            int placeHolderEndIndex = value.indexOf("$", placeHolderStartIndex + placeHolderStartLength) + 1;
            String placeholder = value.substring(placeHolderStartIndex, placeHolderEndIndex);
            String configKey = placeholder.substring(placeHolderStartLength, placeholder.length() - 1);
            String configValue = placeHolderStart.equals("$CONFIG.") && (configKey.equals("text.support_place") || configKey.equals("text.support_name")) ? (configKey.equals("text.support_place") ? PlatformHelp.getActualHelpChannel() : PlatformHelp.getActualHelpName()) : configGetFunction.apply(configKey);
            if (placeHoldersSurroundedWithHref.containsKey(placeholder) || placeHolderStart.equals("$LINK.")) {
                String placeHolderValue = placeHoldersSurroundedWithHref.get(placeholder);
                configValue = placeHolderValue == null ? (placeHolderStart.equals("$LINK.") ? "<a href='" + configValue + "'>" + configValue + "</a>" : "<a href='" + placeholder.substring(1, placeholder.length() - 1) + "'>" + configValue + "</a>") : "<a href='" + configValue + "'>" + placeHolderValue + "</a>";
            }
            value = value.replaceAll(Pattern.quote(placeholder), Matcher.quoteReplacement(configValue));
        }
        return value;
    }

    public static String getBCCValue(String key) {
        Path BCCConfigForgePath = Paths.get("config", "bcc-common.toml");
        Path BCCConfigFabricPath = Paths.get("config", "bcc.json");
        try {
            if (BCCConfig == null) {
                if (!Files.exists(BCCConfigForgePath, new LinkOption[0]) && !Files.exists(BCCConfigFabricPath, new LinkOption[0])) {
                    JarInJarHelper.LOGGER.error("BCC config file not found");
                    return "<BCC config file not found>";
                }
                BCCConfig = FileConfig.builder(BCCConfigForgePath.toFile().exists() ? BCCConfigForgePath : BCCConfigFabricPath).build();
                BCCConfig.load();
            }
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.error("Failed to load BCC config:", (Throwable)e);
            BCCConfig = null;
            return "<BCC config parsing error>";
        }
        key = BCCConfigForgePath.toFile().exists() ? "general." + key : key;
        String value = (String)BCCConfig.get(key);
        if (value == null) {
            return "<" + key + " not found in BCC config>";
        }
        return value;
    }
}

