/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.lang;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.Lang;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Path OPTIONS_PATH = Paths.get("options.txt", new String[0]);
    public static Path LANG_PATH = Paths.get("config", "crash_assistant", "lang");
    public static HashMap<String, Lang> languages = new HashMap();
    public static String currentLangName;
    public static String msgLangName;

    public static String get(String key) {
        return languages.getOrDefault(currentLangName, languages.get("en_us")).get(key);
    }

    public static String getMsgLang(String key) {
        if (msgLangName == null) {
            msgLangName = (String)CrashAssistantConfig.get("generated_message.generated_msg_lang");
        }
        return languages.getOrDefault(msgLangName, languages.get("en_us")).get(key);
    }

    public static String get(String key, HashMap<String, String> placeHoldersSurroundedWithHref) {
        return languages.getOrDefault(currentLangName, languages.get("en_us")).get(key, placeHoldersSurroundedWithHref);
    }

    public static void updateLang() {
        currentLangName = LanguageProvider.getCurrentLang();
    }

    public static String getCurrentLang() {
        if (!Files.exists(OPTIONS_PATH, new LinkOption[0])) {
            return (String)CrashAssistantConfig.get("general.default_lang");
        }
        try {
            List<String> lines = Files.readAllLines(OPTIONS_PATH);
            for (String line : lines) {
                if (!line.startsWith("lang:")) continue;
                return line.split(":", 2)[1].trim();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error while reading " + OPTIONS_PATH.getFileName() + " file. Default lang will be used.");
        }
        return (String)CrashAssistantConfig.get("general.default_lang");
    }

    public static void unzipAndUpdateLangFiles() {
        CrashAssistantConfig.executeWithLock(() -> {
            LANG_PATH.toFile().mkdirs();
            HashSet<String> langFilesInJarNames = new HashSet<String>();
            langFilesInJarNames.add("lang/en_us.json");
            langFilesInJarNames.add("lang/ru_ru.json");
            langFilesInJarNames.add("lang/zh_cn.json");
            langFilesInJarNames.add("lang/es_es.json");
            langFilesInJarNames.add("lang/it_it.json");
            langFilesInJarNames.add("lang/README.md");
            HashMap jarLangFiles = new HashMap();
            for (String langFile : langFilesInJarNames) {
                if (langFile.endsWith("/")) continue;
                String langFileName = langFile.split("/")[1];
                if (!langFile.endsWith(".json")) {
                    JarInJarHelper.unzipFromJar(langFile, LANG_PATH.resolve(langFileName));
                    continue;
                }
                jarLangFiles.put(langFileName.split("\\.json")[0], JarInJarHelper.readJsonFromJar(langFile));
            }
            HashSet<Path> langFilesInConfigNames = LanguageProvider.getLangFilesInConfigPaths();
            HashMap configLangFiles = new HashMap();
            for (Path path : langFilesInConfigNames) {
                configLangFiles.put(path.getFileName().toString().split("\\.json")[0], JarInJarHelper.readJsonFromFile(path));
            }
            HashSet allLanguages = new HashSet();
            allLanguages.addAll(configLangFiles.keySet());
            allLanguages.addAll(jarLangFiles.keySet());
            Lang en_us_jar = new Lang((HashMap)jarLangFiles.get("en_us"));
            for (String langName : allLanguages) {
                Lang jar = new Lang(jarLangFiles.getOrDefault(langName, new HashMap()));
                Lang unmodified_jar = new Lang((HashMap)jar.lang.clone());
                Lang config = new Lang(configLangFiles.getOrDefault(langName, new HashMap()));
                config.lang.forEach((key, value) -> {
                    if (en_us_jar.lang.containsKey(key) && !Objects.equals(value, "$DEFAULT")) {
                        jar.lang.put((String)key, (String)value);
                    }
                });
                languages.put(langName, jar);
                HashMap<String, String> outputJson = new HashMap<String, String>();
                en_us_jar.lang.forEach((key, value) -> {
                    String outputValue = Objects.equals(config.lang.get(key), "$DEFAULT") ? "$DEFAULT" : (Objects.equals(unmodified_jar.lang.get(key), config.lang.get(key)) ? "$DEFAULT" : (!unmodified_jar.lang.containsKey(key) && Objects.equals(value, config.lang.get(key)) ? "$DEFAULT" : config.lang.getOrDefault(key, "$DEFAULT")));
                    outputJson.put((String)key, outputValue);
                });
                JarInJarHelper.writeJsonToFile(outputJson, LANG_PATH.resolve(langName + ".json"));
            }
        });
    }

    public static HashSet<Path> getLangFilesInConfigPaths() {
        HashSet<Path> langFilesInConfigNames = new HashSet<Path>();
        try {
            Files.list(LANG_PATH).forEach(path -> {
                if (path.getFileName().toString().endsWith(".json")) {
                    langFilesInConfigNames.add((Path)path);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to list lang files in " + LANG_PATH.getFileName().toString(), (Throwable)e);
        }
        return langFilesInConfigNames;
    }

    public static Function<String, String> getLangFunction(boolean forMsg) {
        return forMsg ? LanguageProvider::getMsgLang : LanguageProvider::get;
    }

    static {
        LanguageProvider.updateLang();
        LanguageProvider.unzipAndUpdateLangFiles();
    }
}

