/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.lang;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.Lang;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Path OPTIONS_PATH = Paths.get("options.txt", new String[0]);
    public static Path LANG_PATH = Paths.get("config", "crash_assistant", "crash_assistant_localization_overrides");
    public static HashMap<String, Lang> languages = new HashMap();
    public static String currentLangName;
    public static String msgLangName;

    private static void migrateLangDirectory() {
        Path oldLangPath = Paths.get("config", "crash_assistant", "lang");
        if (Files.exists(oldLangPath, new LinkOption[0]) && Files.isDirectory(oldLangPath, new LinkOption[0])) {
            try {
                LANG_PATH.toFile().mkdirs();
                Files.list(oldLangPath).forEach(file -> {
                    try {
                        Files.move(file, LANG_PATH.resolve(file.getFileName()), new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        LOGGER.warn("Tried to migrate file {}, but seems like it's already migrated, removing from the old folder...", file);
                        try {
                            Files.deleteIfExists(file);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to move file: " + String.valueOf(file), (Throwable)e);
                    }
                });
                Files.delete(oldLangPath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to migrate lang directory", (Throwable)e);
            }
        }
    }

    public static String get(String key) {
        return languages.getOrDefault(currentLangName, languages.get("en_us")).get(key);
    }

    public static String getMsgLang(String key) {
        if (msgLangName == null) {
            msgLangName = (String)CrashAssistantConfig.get("generated_message.generated_msg_lang");
        }
        return languages.getOrDefault(msgLangName, languages.get("en_us")).get(key);
    }

    public static String get(String key, HashMap<String, String> placeHoldersSurroundedWithHref) {
        return languages.getOrDefault(currentLangName, languages.get("en_us")).get(key, placeHoldersSurroundedWithHref);
    }

    public static void updateLang() {
        currentLangName = LanguageProvider.getCurrentLang();
    }

    public static String getCurrentLang() {
        if (!Files.exists(OPTIONS_PATH, new LinkOption[0])) {
            return (String)CrashAssistantConfig.get("general.default_lang");
        }
        try {
            List<String> lines = Files.readAllLines(OPTIONS_PATH);
            for (String line : lines) {
                if (!line.startsWith("lang:")) continue;
                return line.split(":", 2)[1].trim().toLowerCase();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error while reading " + String.valueOf(OPTIONS_PATH.getFileName()) + " file. Default lang will be used.");
        }
        return (String)CrashAssistantConfig.get("general.default_lang");
    }

    public static void unzipAndUpdateLangFiles() {
        CrashAssistantConfig.executeWithLock(() -> {
            String value;
            String key;
            boolean generateLocalizationFolderWithReadme = (Boolean)CrashAssistantConfig.get("general.generate_localization_overrides_folder_with_readme");
            String priorityLangForOverrides = (String)CrashAssistantConfig.get("general.priority_lang_for_overrides");
            if (generateLocalizationFolderWithReadme) {
                LANG_PATH.toFile().mkdirs();
            }
            HashSet<String> langFilesInJarNames = new HashSet<String>();
            langFilesInJarNames.add("crash_assistant_localization/de_de.json");
            langFilesInJarNames.add("crash_assistant_localization/en_us.json");
            langFilesInJarNames.add("crash_assistant_localization/ru_ru.json");
            langFilesInJarNames.add("crash_assistant_localization/zh_cn.json");
            langFilesInJarNames.add("crash_assistant_localization/es_es.json");
            langFilesInJarNames.add("crash_assistant_localization/it_it.json");
            langFilesInJarNames.add("crash_assistant_localization/README.md");
            HashMap jarLangFiles = new HashMap();
            HashMap configLangFiles = new HashMap();
            for (String langFile : langFilesInJarNames) {
                if (langFile.endsWith("/")) continue;
                String langFileName = langFile.split("/")[1];
                if (!langFile.endsWith(".json")) {
                    if (!generateLocalizationFolderWithReadme) continue;
                    JarInJarHelper.unzipFromJar(langFile, LANG_PATH.resolve(langFileName));
                    continue;
                }
                jarLangFiles.put(langFileName.split("\\.json")[0], JarInJarHelper.readJsonFromJar(langFile));
            }
            Lang en_usFromFar = new Lang((HashMap)jarLangFiles.get("en_us"));
            HashSet<Path> langFilesInConfigNames = LanguageProvider.getLangFilesInConfigPaths();
            HashSet<Path> langFilesToRemove = new HashSet<Path>();
            for (Path path : langFilesInConfigNames) {
                HashMap<String, String> lang = JarInJarHelper.readJsonFromFile(path);
                if (lang.isEmpty()) {
                    langFilesToRemove.add(path);
                    continue;
                }
                String langName = path.getFileName().toString().split("\\.json")[0];
                HashSet<String> keysToRemove = new HashSet<String>();
                for (Map.Entry<String, String> entry : lang.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (!en_usFromFar.lang.containsKey(key)) {
                        keysToRemove.add(key);
                        continue;
                    }
                    if (value.equals("$DEFAULT")) {
                        keysToRemove.add(key);
                        continue;
                    }
                    if (!jarLangFiles.containsKey(langName) || !((HashMap)jarLangFiles.get(langName)).containsKey(key) || !((String)((HashMap)jarLangFiles.get(langName)).get(key)).equals(value)) continue;
                    keysToRemove.add(key);
                }
                for (String string : keysToRemove) {
                    lang.remove(string);
                }
                if (lang.isEmpty()) {
                    langFilesToRemove.add(path);
                    continue;
                }
                if (!keysToRemove.isEmpty()) {
                    JarInJarHelper.writeJsonToFile(lang, path);
                }
                configLangFiles.put(langName, lang);
            }
            for (Path path : langFilesToRemove) {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {}
            }
            HashSet allLanguages = new HashSet();
            allLanguages.addAll(configLangFiles.keySet());
            allLanguages.addAll(jarLangFiles.keySet());
            HashMap FirstPriorityLangForOverrides = configLangFiles.getOrDefault(priorityLangForOverrides, new HashMap());
            for (String langName : allLanguages) {
                HashMap<String, String> lang = configLangFiles.getOrDefault(langName, new HashMap());
                for (Map.Entry<String, String> entry : FirstPriorityLangForOverrides.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (lang.containsKey(key)) continue;
                    lang.put(key, value);
                }
                for (Map.Entry<String, String> entry : jarLangFiles.getOrDefault(langName, new HashMap()).entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (lang.containsKey(key)) continue;
                    lang.put(key, value);
                }
                languages.put(langName, new Lang(lang));
            }
        });
    }

    public static HashSet<Path> getLangFilesInConfigPaths() {
        HashSet<Path> langFilesInConfigNames = new HashSet<Path>();
        if (!Files.exists(LANG_PATH, new LinkOption[0])) {
            return langFilesInConfigNames;
        }
        try {
            Files.list(LANG_PATH).forEach(path -> {
                if (path.getFileName().toString().endsWith(".json")) {
                    langFilesInConfigNames.add((Path)path);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to list lang files in " + LANG_PATH.getFileName().toString(), (Throwable)e);
        }
        return langFilesInConfigNames;
    }

    public static Function<String, String> getLangFunction(boolean forMsg) {
        return forMsg ? LanguageProvider::getMsgLang : LanguageProvider::get;
    }

    static {
        LanguageProvider.migrateLangDirectory();
        LanguageProvider.updateLang();
        LanguageProvider.unzipAndUpdateLangFiles();
    }
}

