/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common.utils.ManualCrashThrower;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.HeapDumper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ThreadDumper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CrashAssistantCommands {
    public static final HashMap<String, String> supportedCrashCommands = new HashMap<String, String>(){
        {
            this.put("game", "Minecraft");
            this.put("jvm", "JVM");
            this.put("no_crash", "noCrash");
        }
    };
    public static final HashSet<String> supportedCrashArgs = new HashSet<String>(){
        {
            this.add("--withThreadDump");
            this.add("--withHeapDump");
            this.add("--GCBeforeHeapDump");
        }
    };
    public static Instant lastCrashCommand = Instant.ofEpochMilli(0L);
    public static boolean isDeadLocked = false;

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"crash_assistant").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"modlist").then(LiteralArgumentBuilder.literal((String)"save").executes(CrashAssistantCommands::saveModlist))).then(LiteralArgumentBuilder.literal((String)"diff").executes(CrashAssistantCommands::showDiff)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"crash").requires(c -> CrashAssistantConfig.getBoolean("crash_command.enabled"))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"to_crash", (ArgumentType)StringArgumentType.string()).suggests(new CrashCommandsSuggestionProvider()).executes(CrashAssistantCommands::crash)).then(CrashAssistantCommands.getCrashArg(1).then(CrashAssistantCommands.getCrashArg(2).then(CrashAssistantCommands.getCrashArg(3))))));
    }

    public static ITextComponent getModConfigComponent() {
        StringTextComponent component = new StringTextComponent("[mod config]");
        Style style = new Style().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, CrashAssistantConfig.getConfigPath().toAbsolutePath().toString())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(LanguageProvider.get("commands.mod_config_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static ITextComponent getCopyNicknameComponent(String playerNickname) {
        StringTextComponent component = new StringTextComponent("[nickname]");
        Style style = new Style().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, '\"' + playerNickname + '\"')).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(LanguageProvider.get("commands.nickname_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static ITextComponent getCopyDiffComponent(ModListDiffStringBuilder diff) {
        StringTextComponent component = new StringTextComponent("[" + LanguageProvider.get("commands.diff_copy") + "]");
        Style style = new Style().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, diff.toText())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(LanguageProvider.get("commands.diff_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static void sendClientMsg(ITextComponent message) {
        Minecraft.func_71410_x().execute(() -> Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(message));
    }

    public static boolean checkModlistFeatureEnabled() {
        LanguageProvider.updateLang();
        if (CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return true;
        }
        StringTextComponent msg = new StringTextComponent("");
        msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.modlist_disabled_error_msg")));
        msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
        msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return false;
    }

    public static int saveModlist(CommandContext<?> context) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return 0;
        }
        StringTextComponent msg = new StringTextComponent("");
        if (CrashAssistantConfig.getModpackCreators().contains(CrashAssistant.playerNickname)) {
            ModListUtils.saveCurrentModList();
            msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.modlist_overwritten_success")));
            if (CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
                StringTextComponent autoUpdateMsg = new StringTextComponent(LanguageProvider.get("commands.modlist_auto_update_msg"));
                autoUpdateMsg.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
                msg.func_150257_a((ITextComponent)autoUpdateMsg);
            } else {
                StringTextComponent enableAutoUpdateMsg = new StringTextComponent(LanguageProvider.get("commands.modlist_enable_auto_update_msg"));
                enableAutoUpdateMsg.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
                msg.func_150257_a((ITextComponent)enableAutoUpdateMsg);
            }
            msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
            msg.func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
        } else {
            msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.not_creator_error_msg")));
            msg.func_150257_a(CrashAssistantCommands.getCopyNicknameComponent(CrashAssistant.playerNickname));
            msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.add_to_creator_list_msg")));
            msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
            msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return 0;
    }

    public static int showDiff(CommandContext<?> context) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return 0;
        }
        ModListDiff diff = ModListDiff.getDiff(false);
        StringTextComponent msg = new ComponentModListDiffStringBuilder(diff.generateDiffMsg(false)).toComponent();
        msg.func_150257_a(CrashAssistantCommands.getCopyDiffComponent(diff.generateDiffMsg(true)));
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return 0;
    }

    private static int deadlockIntegratedServer(CommandContext<?> context) {
        Minecraft.func_71410_x().func_71401_C().execute(() -> {
            isDeadLocked = true;
            while (isDeadLocked) {
            }
        });
        return 0;
    }

    private static int releaseIntegratedServer(CommandContext<?> context) {
        isDeadLocked = false;
        return 0;
    }

    public static int crash(CommandContext<?> context) {
        LanguageProvider.updateLang();
        StringTextComponent msg = new StringTextComponent("");
        String toCrash = "null";
        try {
            toCrash = (String)context.getArgument("to_crash", String.class);
            if (!supportedCrashCommands.containsKey(toCrash)) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ignored) {
            StringTextComponent errorMsg = new StringTextComponent(LanguageProvider.get("commands.crash_command_validation_failed_to_crash") + " '" + toCrash + "'");
            errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
            return 0;
        }
        toCrash = supportedCrashCommands.get(toCrash);
        int secondsToCrash = (Integer)CrashAssistantConfig.get("crash_command.seconds");
        boolean noCrash = Objects.equals(toCrash, "noCrash");
        if (secondsToCrash <= 0 || Instant.now().isBefore(lastCrashCommand.plusSeconds(secondsToCrash)) || noCrash) {
            List<String> args = CrashAssistantCommands.parseCrashArgs(context);
            String finalToCrash = toCrash;
            new Thread(() -> {
                if (!CrashAssistantCommands.validateCrashArgs(args)) {
                    return;
                }
                if (!args.isEmpty()) {
                    StringTextComponent applyingArgsMsg = new StringTextComponent(LanguageProvider.get("commands.crash_command_applying_args"));
                    applyingArgsMsg.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                    CrashAssistantCommands.sendClientMsg((ITextComponent)applyingArgsMsg);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (args.contains("--withThreadDump")) {
                    CrashAssistant.LOGGER.error("Detected '--withThreadDump' crash command argument. ThreadDump:\n" + ThreadDumper.obtainThreadDump());
                }
                if (args.contains("--withHeapDump")) {
                    if (args.contains("--GCBeforeHeapDump")) {
                        CrashAssistant.LOGGER.error("Detected '--GCBeforeHeapDump' crash command argument. Performing garbage collection before heap dump.");
                        System.gc();
                    }
                    CrashAssistant.LOGGER.error("Detected '--withHeapDump' crash command argument. Creating heap dump.");
                    try {
                        CrashAssistant.LOGGER.error("Created heap dump at: " + HeapDumper.createHeapDump());
                    }
                    catch (Exception e) {
                        CrashAssistant.LOGGER.error("Failed to create heap dump.", (Throwable)e);
                    }
                }
                if (!noCrash) {
                    StringTextComponent crashingMsg = new StringTextComponent(LanguageProvider.get("commands.crash_command_crashing"));
                    crashingMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                    CrashAssistantCommands.sendClientMsg((ITextComponent)crashingMsg);
                } else {
                    CrashAssistantCommands.sendClientMsg((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.crash_command_done")));
                }
                if (Objects.equals(finalToCrash, "Minecraft")) {
                    Minecraft.func_71410_x().execute(() -> ManualCrashThrower.crashGame("Minecraft crashed by '/crash_assistant crash' command."));
                } else if (Objects.equals(finalToCrash, "JVM")) {
                    CrashAssistant.LOGGER.error("JVM crashed by '/crash_assistant crash jvm' command.");
                    NativeUtil.func_216393_a();
                }
            }).start();
            return 0;
        }
        lastCrashCommand = Instant.now();
        msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.crash_command_1")));
        StringTextComponent toCrashComponent = new StringTextComponent(toCrash);
        toCrashComponent.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        msg.func_150257_a((ITextComponent)toCrashComponent);
        msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.crash_command_2")));
        StringTextComponent secondsComponent = new StringTextComponent(Integer.toString(secondsToCrash));
        secondsComponent.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        msg.func_150257_a((ITextComponent)secondsComponent);
        msg.func_150257_a((ITextComponent)new StringTextComponent(LanguageProvider.get("commands.crash_command_3")));
        msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return 0;
    }

    public static boolean validateCrashArgs(List<String> args) {
        for (String arg : args) {
            if (supportedCrashArgs.contains(arg)) continue;
            StringTextComponent errorMsg = new StringTextComponent(LanguageProvider.get("commands.crash_command_validation_failed") + " '" + arg + "'");
            errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
            return false;
        }
        return true;
    }

    public static List<String> parseCrashArgs(CommandContext<?> context) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 1; i <= supportedCrashArgs.size(); ++i) {
            try {
                args.add((String)context.getArgument("arg" + i, String.class));
                continue;
            }
            catch (IllegalArgumentException ignored) {
                break;
            }
        }
        return args;
    }

    public static ArgumentBuilder getCrashArg(int i) {
        return RequiredArgumentBuilder.argument((String)("arg" + i), (ArgumentType)StringArgumentType.string()).suggests(new CrashArgsSuggestionProvider()).executes(CrashAssistantCommands::crash);
    }

    public static class CrashCommandsSuggestionProvider<S>
    implements SuggestionProvider<S> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (String crashCommand : supportedCrashCommands.keySet()) {
                builder.suggest(crashCommand);
            }
            return builder.buildFuture();
        }
    }

    public static class ComponentModListDiffStringBuilder
    extends ModListDiffStringBuilder {
        ComponentModListDiffStringBuilder(ModListDiffStringBuilder modListDiffStringBuilder) {
            this.sb = modListDiffStringBuilder.sb;
        }

        public StringTextComponent toComponent() {
            StringTextComponent msg = new StringTextComponent("");
            for (ModListDiffStringBuilder.ColoredString cs : this.sb) {
                StringTextComponent part = new StringTextComponent(cs.getText());
                if (!cs.getColor().isEmpty()) {
                    TextFormatting color = TextFormatting.valueOf((String)cs.getColor().toUpperCase());
                    part.func_150255_a(new Style().func_150238_a(color));
                }
                msg.func_150257_a((ITextComponent)part);
                if (!cs.isEndsWithNewLine()) continue;
                msg.func_150257_a((ITextComponent)new StringTextComponent("\n"));
            }
            return msg;
        }
    }

    public static class CrashArgsSuggestionProvider<S>
    implements SuggestionProvider<S> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            List<String> existingArgs = CrashAssistantCommands.parseCrashArgs(context);
            for (String e : supportedCrashArgs) {
                if (existingArgs.contains(e) || Objects.equals(e, "--GCBeforeHeapDump") && !existingArgs.contains("--withHeapDump")) continue;
                builder.suggest(e);
            }
            return builder.buildFuture();
        }
    }
}

