/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.mod_list.AnsiColor;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ModListDiffStringBuilder {
    public List<ColoredString> sb = new ArrayList<ColoredString>();

    public void append(String text, String color, boolean endsWithNewLine) {
        this.sb.add(new ColoredString(text, color, endsWithNewLine));
    }

    public void append(String text, String color) {
        this.append(text, color, true);
    }

    public void append(String text, boolean endsWithNewLine) {
        this.append(text, "", false);
    }

    public void append(String text) {
        this.append(text, "");
    }

    public String toText() {
        StringBuilder result = new StringBuilder();
        for (ColoredString cs : this.sb) {
            result.append(cs.getText());
            if (!cs.isEndsWithNewLine()) continue;
            result.append("\n");
        }
        return result.toString().trim();
    }

    public String toHtml() {
        StringBuilder result = new StringBuilder();
        result.append("<html><body style='font-family: Arial; font-size: 12px;white-space: nowrap;'>");
        for (ColoredString cs : this.sb) {
            result.append("<span" + (String)(cs.getColor().isEmpty() ? "" : " style='color: " + cs.getColor() + ";'") + ">" + cs.getText() + "</span>");
            if (!cs.isEndsWithNewLine()) continue;
            result.append("<br>");
        }
        result.append("</body></html>");
        return result.toString();
    }

    public String toAnsi() {
        return this.toAnsi(false);
    }

    public String toAnsi(boolean withoutFirstString) {
        StringBuilder result = new StringBuilder();
        if (!withoutFirstString) {
            result.append(ModListDiff.getFilePrefix());
            result.append(ModListDiff.getFirstString(true, false, null));
            result.append("\n");
        }
        result.append("```ansi\n");
        boolean first = !withoutFirstString;
        for (ColoredString cs : this.sb) {
            if (first) {
                first = false;
                continue;
            }
            if (!cs.getColor().isEmpty()) {
                result.append(Enum.valueOf(AnsiColor.class, cs.getColor().toUpperCase()).getColorPrefix());
                result.append(cs.getText());
                result.append("\u001b[0m");
            } else {
                result.append(cs.getText());
            }
            if (!cs.isEndsWithNewLine()) continue;
            result.append("\n");
        }
        return result.toString().trim() + "\n```";
    }

    public static class ColoredString {
        private final String text;
        private final String color;
        private final boolean endsWithNewLine;

        public ColoredString(String text, String color, boolean endsWithNewLine) {
            this.text = text;
            this.color = color;
            this.endsWithNewLine = endsWithNewLine;
        }

        public String getText() {
            return this.text;
        }

        public String getColor() {
            return this.color;
        }

        public boolean isEndsWithNewLine() {
            return this.endsWithNewLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredString that = (ColoredString)o;
            return this.endsWithNewLine == that.endsWithNewLine && Objects.equals(this.text, that.text) && Objects.equals(this.color, that.color);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.color, this.endsWithNewLine);
        }

        public String toString() {
            return "ColoredString{text='" + this.text + "', color='" + this.color + "', endsWithNewLine=" + this.endsWithNewLine + "}";
        }
    }
}

