/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleLinuxImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleMacOSImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleWinImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperImpl;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelperProcessHandleImpl;
import java.util.Optional;

public class ProcessHelper {
    private static final ProcessHelperImpl impl;

    public static long getCurrentProcessId() {
        return impl.getCurrentProcessId();
    }

    public static Optional<String> getCurrentProcessCommand() {
        return impl.getCurrentProcessCommand();
    }

    public static long getCurrentProcessStartTime() {
        return impl.getCurrentProcessStartTime();
    }

    public static long getProcessStartTime(long pid) {
        return impl.getProcessStartTime(pid);
    }

    public static boolean isProcessAlive(long pid) {
        return impl.isProcessAlive(pid);
    }

    public static String getChildProcessesInfo() {
        return impl.getChildProcessesInfo();
    }

    public static boolean destroyProcess(long pid) {
        return impl.destroyProcess(pid);
    }

    public static boolean destroyProcessForcibly(long pid) {
        return impl.destroyProcessForcibly(pid);
    }

    public static void exitProcess(int status) {
        System.exit(status);
    }

    static {
        ProcessHelperImpl tempImpl;
        block4: {
            tempImpl = null;
            try {
                Class.forName("java.lang.ProcessHandle");
                tempImpl = new ProcessHelperProcessHandleImpl();
            }
            catch (Exception e) {
                String osName = System.getProperty("os.name").toLowerCase();
                if (PlatformHelp.isWindows()) {
                    tempImpl = new ProcessHandleWinImpl();
                }
                if (PlatformHelp.isLinux()) {
                    tempImpl = new ProcessHandleLinuxImpl();
                }
                if (!PlatformHelp.isMacOS()) break block4;
                tempImpl = new ProcessHandleMacOSImpl();
            }
        }
        impl = tempImpl;
    }
}

