/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.loading_utils;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarLocatingException;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LibrariesJarLocator {
    public static String getLibraryJarPath(Class cls) throws JarLocatingException, URISyntaxException {
        Path path = LibrariesJarLocator.getPathFromClass(cls);
        if (path == null) {
            throw new JarLocatingException("getPathFromClass returned null, class: " + cls.getName());
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + String.valueOf(cls) + "',but it does not exist; path: `" + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + String.valueOf(cls) + "',but it is not regular file; path: `" + String.valueOf(path));
        }
        return path.toAbsolutePath().toString();
    }

    public static String getLibraryJarPathFromResource(String resource) throws JarLocatingException {
        Path path = LibrariesJarLocator.getPathFromResource(resource);
        if (path == null) {
            throw new JarLocatingException("getPathFromClass returned null, resource: " + resource);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + resource + "',but it does not exist; path: `" + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new JarLocatingException("Successfully parsed '.jar' path of `" + resource + "',but it is not regular file; path: `" + String.valueOf(path));
        }
        String absolutePath = path.toAbsolutePath().toString();
        if (!absolutePath.endsWith(".jar")) {
            throw new JarLocatingException("Successfully parsed path of `" + resource + "',but it is not .jar file" + String.valueOf(path));
        }
        return absolutePath;
    }

    public static Path getPathFromClass(Class cls) {
        String resourcePath = cls.getName().replace('.', '/') + ".class";
        return LibrariesJarLocator.getPathFromResource(resourcePath);
    }

    public static void setupLoaderJarName(Class cls) {
        try {
            PlatformHelp.loaderJarName = Paths.get(LibrariesJarLocator.getLibraryJarPath(cls), new String[0]).getFileName().toString();
        }
        catch (URISyntaxException e) {
            JarInJarHelper.LOGGER.error("Error while trying to get loader jar path: ", (Throwable)e);
        }
    }

    public static void setupLoaderJarName(String version) {
        PlatformHelp.loaderJarName = version;
    }

    private static Path getPathFromResource(String resource) {
        ClassLoader cl = LibrariesJarLocator.class.getClassLoader();
        URL url = cl.getResource(resource);
        if (url == null) {
            return null;
        }
        return LibrariesJarLocator.getPath(url, resource);
    }

    private static Path getPath(URL url, String resource) {
        Object str = url.toString();
        int len = resource.length();
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            str = ((String)str).substring(0, ((String)str).length() - (len += 2));
        } else if ("union".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            str = "file://" + ((String)str).substring(0, ((String)str).lastIndexOf(".jar") + 4);
        }
        return Paths.get(URI.create((String)str));
    }
}

