/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common.commands;

import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.HeapDumper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ThreadDumper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class CrashAssistantCommands
extends CommandBase {
    private static Unsafe UNSAFE;
    private static String latestDiffText;
    private static String latestNickname;
    private static final Map<String, String> SUPPORTED_CRASH_CMDS;
    private static final Set<String> SUPPORTED_CRASH_ARGS;
    private static long lastCrashCommandTime;

    public String func_71517_b() {
        return "crash_assistant";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/crash_assistant <modlist|crash> \u2026";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        LanguageProvider.updateLang();
        if (args.length == 0) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red(this.func_71518_a(sender)));
            return;
        }
        switch (args[0]) {
            case "modlist": {
                this.handleModlist(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "crash": {
                this.handleCrash(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "copy_to_clipboard": {
                this.handleCopyToClipboard(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red(this.func_71518_a(sender)));
            }
        }
    }

    private void handleModlist(String[] args) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return;
        }
        if (args.length == 0) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red("/crash_assistant modlist <save|diff>"));
            return;
        }
        switch (args[0]) {
            case "save": {
                this.saveModlist();
                break;
            }
            case "diff": {
                this.showDiff();
                break;
            }
            default: {
                CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red("/crash_assistant modlist <save|diff>"));
            }
        }
    }

    private void saveModlist() {
        ChatComponentText msg = new ChatComponentText("");
        if (CrashAssistantConfig.getModpackCreators().contains(CrashAssistant.playerNickname)) {
            ModListUtils.saveCurrentModList();
            msg.func_150257_a((IChatComponent)CrashAssistantCommands.green(LanguageProvider.get("commands.modlist_overwritten_success")));
            msg.func_150257_a((IChatComponent)new ChatComponentText(" "));
            if (CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
                msg.func_150257_a((IChatComponent)CrashAssistantCommands.white(LanguageProvider.get("commands.modlist_auto_update_msg")));
            } else {
                msg.func_150257_a((IChatComponent)CrashAssistantCommands.white(LanguageProvider.get("commands.modlist_enable_auto_update_msg")));
            }
            msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
        } else {
            msg.func_150257_a((IChatComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.not_creator_error_msg")));
            msg.func_150257_a(CrashAssistantCommands.getCopyNicknameComponent(CrashAssistant.playerNickname));
            msg.func_150257_a((IChatComponent)CrashAssistantCommands.white(LanguageProvider.get("commands.add_to_creator_list_msg")));
            msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
        }
        CrashAssistantCommands.sendClientMsg((IChatComponent)msg);
    }

    private void showDiff() {
        ModListDiff diff = ModListDiff.getDiff(false);
        ModListDiffStringBuilder builder = diff.generateDiffMsg(false);
        ComponentModListDiffStringBuilder compBuilder = new ComponentModListDiffStringBuilder(builder);
        ChatComponentText comp = compBuilder.toComponent();
        comp.func_150257_a(CrashAssistantCommands.getCopyDiffComponent(diff.generateDiffMsg(true)));
        CrashAssistantCommands.sendClientMsg((IChatComponent)comp);
    }

    private void handleCopyToClipboard(String[] args) {
        boolean isNickname;
        boolean bl = isNickname = args.length > 0 && "nickname".equals(args[0]);
        if (isNickname) {
            if (latestNickname.isEmpty()) {
                CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red("No nickname available to copy"));
                return;
            }
            GuiScreen.func_146275_d((String)latestNickname);
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.green("Nickname copied to clipboard"));
        } else {
            if (latestDiffText.isEmpty()) {
                CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red("No diff text available to copy"));
                return;
            }
            GuiScreen.func_146275_d((String)latestDiffText);
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.green("Mod list diff copied to clipboard"));
        }
    }

    private void handleCrash(String[] args) {
        if (!CrashAssistantConfig.getBoolean("crash_command.enabled")) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red("Crash-command is disabled in the config."));
            return;
        }
        if (args.length == 0) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red("/crash_assistant crash <game|jvm|no_crash> [args]"));
            return;
        }
        String toCrashKey = args[0];
        if (!SUPPORTED_CRASH_CMDS.containsKey(toCrashKey)) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.crash_command_validation_failed_to_crash") + " '" + toCrashKey + "'"));
            return;
        }
        final String toCrash = SUPPORTED_CRASH_CMDS.get(toCrashKey);
        final List<String> flags = Arrays.asList(args).subList(1, args.length);
        boolean noCrash = "noCrash".equals(toCrash);
        int seconds = (Integer)CrashAssistantConfig.get("crash_command.seconds");
        if (seconds <= 0 || System.currentTimeMillis() < lastCrashCommandTime + (long)(seconds * 1000) || noCrash) {
            if (!CrashAssistantCommands.validateCrashArgs(flags)) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CrashAssistantCommands.this.actuallyCrash(toCrash, flags);
                }
            }).start();
            return;
        }
        lastCrashCommandTime = System.currentTimeMillis();
        ChatComponentText msg = new ChatComponentText("");
        msg.func_150257_a((IChatComponent)new ChatComponentText(LanguageProvider.get("commands.crash_command_1")));
        ChatComponentText crashTypeText = new ChatComponentText(toCrash);
        ChatStyle crashTypeStyle = new ChatStyle();
        crashTypeStyle.func_150238_a(EnumChatFormatting.YELLOW);
        crashTypeText.func_150255_a(crashTypeStyle);
        msg.func_150257_a((IChatComponent)crashTypeText);
        msg.func_150257_a((IChatComponent)new ChatComponentText(LanguageProvider.get("commands.crash_command_2")));
        ChatComponentText secondsText = new ChatComponentText(Integer.toString(seconds));
        ChatStyle secondsStyle = new ChatStyle();
        secondsStyle.func_150238_a(EnumChatFormatting.YELLOW);
        secondsText.func_150255_a(secondsStyle);
        msg.func_150257_a((IChatComponent)secondsText);
        ChatComponentText part3 = new ChatComponentText(LanguageProvider.get("commands.crash_command_3"));
        ChatStyle part3Style = new ChatStyle();
        part3Style.func_150238_a(EnumChatFormatting.RED);
        part3.func_150255_a(part3Style);
        msg.func_150257_a((IChatComponent)part3);
        ChatStyle msgStyle = new ChatStyle();
        msgStyle.func_150238_a(EnumChatFormatting.RED);
        msg.func_150255_a(msgStyle);
        CrashAssistantCommands.sendClientMsg((IChatComponent)msg);
    }

    private void actuallyCrash(String toCrash, List<String> flags) {
        if (!flags.isEmpty()) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.yellow(LanguageProvider.get("commands.crash_command_applying_args")));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (flags.contains("--withThreadDump")) {
            CrashAssistant.LOGGER.error("ThreadDump:\n" + ThreadDumper.obtainThreadDump());
        }
        if (flags.contains("--withHeapDump")) {
            if (flags.contains("--GCBeforeHeapDump")) {
                CrashAssistant.LOGGER.info("GC before heap dump");
                System.gc();
            }
            try {
                CrashAssistant.LOGGER.error("Created heap dump at: " + HeapDumper.createHeapDump());
            }
            catch (Exception e) {
                CrashAssistant.LOGGER.error("Failed to create heap dump", (Throwable)e);
            }
        }
        if ("noCrash".equals(toCrash)) {
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.green(LanguageProvider.get("commands.crash_command_done")));
            return;
        }
        CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.crash_command_crashing")));
        if ("Minecraft".equals(toCrash)) {
            String reason = "Minecraft crashed by '/crash_assistant crash'";
            CrashReport report = CrashReport.func_85055_a((Throwable)new Throwable(reason), (String)reason);
            if (Minecraft.func_71410_x().field_71441_e != null) {
                Minecraft.func_71410_x().func_71396_d(report);
            }
            Minecraft.func_71410_x().func_71377_b(report);
        } else {
            CrashAssistant.LOGGER.error("JVM crashed by '/crash_assistant crash jvm'");
            UNSAFE.setMemory(0L, 1L, (byte)0);
        }
    }

    private static boolean checkModlistFeatureEnabled() {
        LanguageProvider.updateLang();
        if (CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return true;
        }
        ChatComponentText msg = CrashAssistantCommands.red(LanguageProvider.get("commands.modlist_disabled_error_msg"));
        msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
        CrashAssistantCommands.sendClientMsg((IChatComponent)msg);
        return false;
    }

    private static boolean validateCrashArgs(List<String> args) {
        for (String arg : args) {
            if (SUPPORTED_CRASH_ARGS.contains(arg)) continue;
            CrashAssistantCommands.sendClientMsg((IChatComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.crash_command_validation_failed") + " '" + arg + "'"));
            return false;
        }
        return true;
    }

    public static void sendClientMsg(IChatComponent root) {
        Minecraft mc = Minecraft.func_71410_x();
        for (IChatComponent line : CrashAssistantCommands.splitIntoLines(root)) {
            mc.field_71456_v.func_146158_b().func_146227_a(line);
        }
    }

    private static List<IChatComponent> splitIntoLines(IChatComponent root) {
        LineBuilder lb = new LineBuilder();
        CrashAssistantCommands.walk(root, lb);
        lb.finishCurrent();
        return lb.lines;
    }

    private static void walk(IChatComponent comp, LineBuilder lb) {
        if (comp instanceof ChatComponentText) {
            ChatComponentText txt = (ChatComponentText)comp;
            String[] parts = txt.func_150265_g().split("\\n", -1);
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    lb.newLine();
                }
                if (parts[i].isEmpty()) continue;
                ChatComponentText frag = new ChatComponentText(parts[i]);
                frag.func_150255_a(txt.func_150256_b());
                lb.current.func_150257_a((IChatComponent)frag);
            }
        } else {
            lb.current.func_150257_a(comp.func_150259_f());
        }
        for (IChatComponent sib : comp.func_150253_a()) {
            CrashAssistantCommands.walk(sib, lb);
        }
    }

    public int compareTo(@NotNull Object o) {
        return 0;
    }

    private static ChatComponentText colored(String txt, EnumChatFormatting fmt) {
        ChatComponentText component = new ChatComponentText(txt);
        component.func_150256_b().func_150238_a(fmt);
        return component;
    }

    private static ChatComponentText red(String txt) {
        return CrashAssistantCommands.colored(txt, EnumChatFormatting.RED);
    }

    private static ChatComponentText green(String txt) {
        return CrashAssistantCommands.colored(txt, EnumChatFormatting.GREEN);
    }

    private static ChatComponentText white(String txt) {
        return CrashAssistantCommands.colored(txt, EnumChatFormatting.WHITE);
    }

    private static ChatComponentText yellow(String txt) {
        return CrashAssistantCommands.colored(txt, EnumChatFormatting.YELLOW);
    }

    public static IChatComponent getModConfigComponent() {
        ChatComponentText component = new ChatComponentText("[mod config]");
        ChatStyle style = new ChatStyle();
        style.func_150238_a(EnumChatFormatting.YELLOW);
        style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, CrashAssistantConfig.getConfigPath().toAbsolutePath().toString()));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(LanguageProvider.get("commands.mod_config_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static IChatComponent getCopyNicknameComponent(String name) {
        latestNickname = name;
        ChatComponentText component = new ChatComponentText("[nickname]");
        ChatStyle style = new ChatStyle();
        style.func_150238_a(EnumChatFormatting.YELLOW);
        style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/crash_assistant copy_to_clipboard nickname"));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(LanguageProvider.get("commands.nickname_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static IChatComponent getCopyDiffComponent(ModListDiffStringBuilder diff) {
        latestDiffText = diff.toText();
        ChatComponentText component = new ChatComponentText("[" + LanguageProvider.get("commands.diff_copy") + "]");
        ChatStyle style = new ChatStyle();
        style.func_150238_a(EnumChatFormatting.YELLOW);
        style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/crash_assistant copy_to_clipboard"));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(LanguageProvider.get("commands.diff_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CrashAssistantCommands.func_71530_a((String[])args, (String[])new String[]{"modlist", "crash"});
        }
        if ("modlist".equals(args[0]) && args.length == 2) {
            return CrashAssistantCommands.func_71530_a((String[])args, (String[])new String[]{"save", "diff"});
        }
        if ("crash".equals(args[0])) {
            if (args.length == 2) {
                return CrashAssistantCommands.func_71530_a((String[])args, (String[])SUPPORTED_CRASH_CMDS.keySet().toArray(new String[0]));
            }
            ArrayList<String> left = new ArrayList<String>(SUPPORTED_CRASH_ARGS);
            left.removeAll(Arrays.asList(args).subList(2, args.length));
            if (!Arrays.asList(args).contains("--withHeapDump")) {
                left.remove("--GCBeforeHeapDump");
            }
            return CrashAssistantCommands.func_71530_a((String[])args, (String[])left.toArray(new String[0]));
        }
        return Collections.emptyList();
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            CrashAssistant.LOGGER.error("Failed to get Unsafe instance", (Throwable)e);
        }
        latestDiffText = "";
        latestNickname = "";
        SUPPORTED_CRASH_CMDS = new HashMap<String, String>(){
            {
                this.put("game", "Minecraft");
                this.put("jvm", "JVM");
                this.put("no_crash", "noCrash");
            }
        };
        SUPPORTED_CRASH_ARGS = new HashSet<String>(Arrays.asList("--withThreadDump", "--withHeapDump", "--GCBeforeHeapDump"));
        lastCrashCommandTime = 0L;
    }

    public static class ComponentModListDiffStringBuilder
    extends ModListDiffStringBuilder {
        public ComponentModListDiffStringBuilder(ModListDiffStringBuilder sb) {
            this.sb = sb.sb;
        }

        public ChatComponentText toComponent() {
            ChatComponentText base = new ChatComponentText("");
            for (ModListDiffStringBuilder.ColoredString cs : this.sb) {
                ChatComponentText part = new ChatComponentText(cs.getText());
                if (!cs.getColor().isEmpty()) {
                    ChatStyle style = new ChatStyle();
                    style.func_150238_a(EnumChatFormatting.valueOf((String)cs.getColor().toUpperCase()));
                    part.func_150255_a(style);
                }
                base.func_150257_a((IChatComponent)part);
                if (!cs.isEndsWithNewLine()) continue;
                base.func_150257_a((IChatComponent)new ChatComponentText("\n"));
            }
            return base;
        }
    }

    private static class LineBuilder {
        final List<IChatComponent> lines = new ArrayList<IChatComponent>();
        ChatComponentText current = new ChatComponentText("");

        private LineBuilder() {
        }

        void newLine() {
            this.lines.add((IChatComponent)this.current);
            this.current = new ChatComponentText("");
        }

        void finishCurrent() {
            this.lines.add((IChatComponent)this.current);
        }
    }
}

