/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.core_mod.utils.IModLocatorInjector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CrashAssistantTransformationService
implements ITransformationService {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantTransformationService");
    private static String earlyLaunchTarget = "unknown";
    private static String earlyMinecraftVersion = "unknown";

    public CrashAssistantTransformationService() {
        try {
            CrashAssistantTransformationService.reflectivelyExtractLaunchData();
            PlatformHelp.platform = PlatformHelp.FORGE;
            PlatformHelp.minecraftVersion = earlyMinecraftVersion;
            LibrariesJarLocator.setupLoaderJarName(FMLLoader.class);
            JarInJarHelper.launchCrashAssistantApp(earlyLaunchTarget);
            JarInJarHelper.checkDuplicatedCrashAssistantMod(true);
        }
        catch (Throwable throwable) {
            LOGGER.error("A critical error occurred during Crash Assistant setup: ", throwable);
        }
    }

    private static void reflectivelyExtractLaunchData() {
        try {
            Field argumentHandlerField = Launcher.class.getDeclaredField("argumentHandler");
            argumentHandlerField.setAccessible(true);
            Object argumentHandler = argumentHandlerField.get(Launcher.INSTANCE);
            Field argsField = ArgumentHandler.class.getDeclaredField("args");
            argsField.setAccessible(true);
            String[] rawArgs = (String[])argsField.get(argumentHandler);
            if (rawArgs == null) {
                LOGGER.warn("Could not find raw launch arguments via reflection; they were null.");
                return;
            }
            for (int i = 0; i < rawArgs.length - 1; ++i) {
                if ("--launchTarget".equals(rawArgs[i])) {
                    earlyLaunchTarget = rawArgs[i + 1];
                }
                if (!"--fml.mcVersion".equals(rawArgs[i])) continue;
                earlyMinecraftVersion = rawArgs[i + 1];
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Failed to reflectively access ModLauncher arguments. This might happen with a future ModLauncher update.", (Throwable)e);
        }
    }

    @NotNull
    public String name() {
        return "crash_assistant";
    }

    public void initialize(IEnvironment environment) {
    }

    public void beginScanning(IEnvironment iEnvironment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        IModLocatorInjector.inject();
    }

    @NotNull
    public List<ITransformer> transformers() {
        ArrayList<ITransformer> list = new ArrayList<ITransformer>();
        list.add(new InnerCrashAssistantTransformer());
        return list;
    }

    private static class InnerCrashAssistantTransformer
    implements ITransformer<ClassNode>,
    Opcodes {
        private static final List<String> TRANSFORM_CLASSES = Arrays.asList("net.minecraft.client.Minecraft");
        private static final Map<String, String> SHUTDOWN_METHOD = new HashMap<String, String>();

        private InnerCrashAssistantTransformer() {
        }

        public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
            try {
                String transformedName = input.name.replace('/', '.');
                if (!TRANSFORM_CLASSES.contains(transformedName)) {
                    return input;
                }
                switch (transformedName) {
                    case "net.minecraft.client.Minecraft": {
                        this.transformMinecraft(input);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return input;
        }

        private void transformMinecraft(ClassNode cn) {
            for (MethodNode m : cn.methods) {
                if (!SHUTDOWN_METHOD.containsKey(m.name) || !m.desc.equals(SHUTDOWN_METHOD.get(m.name))) continue;
                InnerCrashAssistantTransformer.injectBeforeReturn(m, "dev/kostromdan/mods/crash_assistant/common/CrashAssistantHooks", "onMinecraftShutdown", "()V");
            }
        }

        private static void injectBeforeReturn(MethodNode method, String owner, String name, String desc) {
            InsnList call = new InsnList();
            call.add((AbstractInsnNode)new MethodInsnNode(184, owner, name, desc, false));
            for (AbstractInsnNode insn = method.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                if (insn.getOpcode() != 177) continue;
                method.instructions.insertBefore(insn, call);
                break;
            }
        }

        public Set<ITransformer.Target> targets() {
            HashSet<ITransformer.Target> set = new HashSet<ITransformer.Target>();
            set.add(ITransformer.Target.targetClass((String)"net.minecraft.client.Minecraft"));
            return set;
        }

        public TransformerVoteResult castVote(ITransformerVotingContext context) {
            return TransformerVoteResult.YES;
        }

        static {
            SHUTDOWN_METHOD.put("shutdown", "()V");
            SHUTDOWN_METHOD.put("func_71400_g", "()V");
        }
    }
}

