/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.utils;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;

public class IModLocatorInjector {
    public static void inject() {
        IModLocatorInjector.getJarPath().ifPresent(ModDirTransformerDiscoverer.getExtraLocators()::add);
    }

    public static Optional<URL> getOurJar() {
        Path p;
        URL url = IModLocatorInjector.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            p = Paths.get(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (p.getFileName().toString().toLowerCase().endsWith(".jar")) {
            return Optional.of(url);
        }
        return Optional.empty();
    }

    public static Optional<Path> getJarPath() {
        return IModLocatorInjector.getOurJar().map(url -> {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        });
    }
}

