/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.VersionInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrashAssistantTransformationService
implements ITransformationService {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CrashAssistantTransformationService");
    private static String earlyLaunchTarget = "unknown";

    public CrashAssistantTransformationService() {
        try {
            CrashAssistantTransformationService.reflectivelyExtractLaunchData();
            PlatformHelp.platform = PlatformHelp.FORGE;
            PlatformHelp.minecraftVersion = FMLLoader.versionInfo().mcVersion();
            LibrariesJarLocator.setupLoaderJarName(VersionInfo.class);
            JarInJarHelper.launchCrashAssistantApp(earlyLaunchTarget);
            JarInJarHelper.checkDuplicatedCrashAssistantMod(true);
        }
        catch (Throwable throwable) {
            LOGGER.error("A critical error occurred during Crash Assistant setup: ", throwable);
        }
    }

    private static void reflectivelyExtractLaunchData() {
        try {
            Field argumentHandlerField = Launcher.class.getDeclaredField("argumentHandler");
            argumentHandlerField.setAccessible(true);
            Object argumentHandler = argumentHandlerField.get(Launcher.INSTANCE);
            Field argsField = ArgumentHandler.class.getDeclaredField("args");
            argsField.setAccessible(true);
            String[] rawArgs = (String[])argsField.get(argumentHandler);
            if (rawArgs == null) {
                LOGGER.warn("Could not find raw launch arguments via reflection; they were null.");
                return;
            }
            for (int i = 0; i < rawArgs.length - 1; ++i) {
                if (!"--launchTarget".equals(rawArgs[i])) continue;
                earlyLaunchTarget = rawArgs[i + 1];
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Failed to reflectively access ModLauncher arguments. This might happen with a future ModLauncher update.", (Throwable)e);
        }
    }

    @NotNull
    public String name() {
        return "crash_assistant";
    }

    public void initialize(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    @NotNull
    public List<ITransformer> transformers() {
        return new ArrayList<ITransformer>();
    }
}

