/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Mod {
    private final String jarName;
    private final String modId;
    private final String version;
    private final Boolean isMCreator;
    private final HashSet<String> mixinConfigs;
    private final List<Mod> jarJarMods;
    private final String pathFromJarJar;
    public static final Type TYPE = new TypeToken<LinkedHashSet<Mod>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TYPE, (Object)new ModAdapter()).setPrettyPrinting().create();

    public Mod(String jarName, String modId, String version, Boolean isMCreator, HashSet<String> mixinConfigs, List<Mod> jarJarMods, String pathFromJarJar) {
        this.jarName = jarName;
        this.modId = modId;
        this.version = version;
        this.isMCreator = isMCreator;
        this.mixinConfigs = mixinConfigs;
        this.jarJarMods = jarJarMods;
        this.pathFromJarJar = pathFromJarJar;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getModId() {
        return this.modId;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean IsMCreator() {
        return this.isMCreator;
    }

    public HashSet<String> getMixinConfigs() {
        return this.mixinConfigs;
    }

    public List<Mod> getJarJarMods() {
        return this.jarJarMods;
    }

    public String getPathFromJarJar() {
        return this.pathFromJarJar;
    }

    public static void writeModlistTxt(Path modListTxtPath, final Collection<Mod> mods) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(modListTxtPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write("Mods count: " + mods.size() + "\n \n");
            final Mod tableColumnNames = new Mod("jar name", "mod id (isMCreator)", null, null, new HashSet<String>(){
                {
                    this.add("mixin configs");
                }
            }, new ArrayList<Mod>(), "");
            ArrayList<Mod> finalMods = new ArrayList<Mod>(){
                {
                    this.add(tableColumnNames);
                    this.addAll(mods);
                }
            };
            int[] maxLens = Mod.computeMaxLengths((Collection<Mod>)finalMods, 0);
            int maxJarNameLength = maxLens[0];
            int maxModIdLength = maxLens[1];
            for (Mod mod : finalMods) {
                Mod.writeModWithFormatting(writer, mod, 0, maxJarNameLength, maxModIdLength);
            }
        }
    }

    private static int[] computeMaxLengths(Collection<Mod> mods, int indentLevel) {
        int maxJarLen = 0;
        int maxModIdLen = 0;
        for (Mod mod : mods) {
            String jarName = mod.getJarName() != null ? mod.getJarName() : "";
            String pathFromJarJar = mod.getPathFromJarJar() != null ? mod.getPathFromJarJar() : "";
            String modId = mod.getModId() != null ? mod.getModId() : "";
            int jarLen = indentLevel * 4 + jarName.length() + pathFromJarJar.length();
            maxJarLen = Math.max(maxJarLen, jarLen);
            int modIdLen = indentLevel * 4 + modId.length();
            if (Boolean.TRUE.equals(mod.IsMCreator())) {
                modIdLen += " (MCreator mod)".length();
            }
            maxModIdLen = Math.max(maxModIdLen, modIdLen);
            if (mod.getJarJarMods() == null || mod.getJarJarMods().isEmpty()) continue;
            int[] childLens = Mod.computeMaxLengths(mod.getJarJarMods(), indentLevel + 1);
            maxJarLen = Math.max(maxJarLen, childLens[0]);
            maxModIdLen = Math.max(maxModIdLen, childLens[1]);
        }
        return new int[]{maxJarLen, maxModIdLen};
    }

    private static void writeModWithFormatting(BufferedWriter writer, Mod mod, int indentLevel, int maxJarNameLength, int maxModIdLength) throws IOException {
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            indentBuilder.append("    ");
        }
        String indent = indentBuilder.toString();
        StringBuilder line = new StringBuilder();
        line.append(String.format("%-" + maxJarNameLength + "s", indent + (mod.getPathFromJarJar() != null ? mod.getPathFromJarJar() : "") + mod.getJarName()));
        String mCreatorString = mod.IsMCreator() != null && mod.IsMCreator() != false ? " (MCreator mod)" : "";
        line.append(" | ").append(String.format("%-" + maxModIdLength + "s", (mod.getModId() == null ? "" : mod.getModId()) + mCreatorString));
        line.append(" | ").append(String.join((CharSequence)", ", mod.getMixinConfigs() == null ? new HashSet<String>() : mod.getMixinConfigs()));
        writer.write(line.toString());
        writer.newLine();
        if (mod.getJarJarMods() != null && !mod.getJarJarMods().isEmpty()) {
            for (Mod jarJarMod : mod.getJarJarMods()) {
                Mod.writeModWithFormatting(writer, jarJarMod, indentLevel + 1, maxJarNameLength, maxModIdLength);
            }
        }
    }

    public boolean isModMessedUpWithVersion() {
        if (this.version == null || this.modId == null) {
            return true;
        }
        String normVersion = this.version.toLowerCase().replaceAll("mc\\d+(\\.\\d+)*", "").replaceAll("fabric|neo|forge", "").replaceAll("[+._\\-]", "").trim();
        String normJarName = this.jarName.toLowerCase().replaceAll("mc\\d+(\\.\\d+)*", "").replaceAll("fabric|neo|forge", "").replaceAll("[+._\\-]", "").trim();
        return !normJarName.contains(normVersion);
    }

    public String toString() {
        return "Mod{fileName='" + this.jarName + '\'' + ", modId='" + this.modId + '\'' + ", version='" + this.version + '\'' + ", isMCreator='" + this.isMCreator + '\'' + ", mixinConfigs='" + this.mixinConfigs + '\'' + ", jarJarMods='" + this.jarJarMods + '\'' + ", pathFromJarJar='" + this.pathFromJarJar + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mod mod = (Mod)o;
        return Objects.equals(this.jarName, mod.jarName);
    }

    public int hashCode() {
        return Objects.hash(this.jarName);
    }

    public static class ModAdapter
    implements JsonDeserializer<LinkedHashSet<Mod>>,
    JsonSerializer<LinkedHashSet<Mod>> {
        public LinkedHashSet<Mod> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            LinkedHashSet<Mod> mods;
            block3: {
                block2: {
                    mods = new LinkedHashSet<Mod>();
                    if (!json.isJsonArray()) break block2;
                    for (JsonElement element : json.getAsJsonArray()) {
                        mods.add(new Mod(element.getAsString(), null, null, null, new HashSet<String>(), new ArrayList<Mod>(), null));
                    }
                    break block3;
                }
                if (!json.isJsonObject()) break block3;
                for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                    String jarName = (String)entry.getKey();
                    JsonObject modObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    Mod mod = this.deserializeModObject(modObj, jarName);
                    mods.add(mod);
                }
            }
            return mods;
        }

        private Mod deserializeMod(JsonElement element) {
            if (element.isJsonPrimitive()) {
                return new Mod(element.getAsString(), null, null, null, new HashSet<String>(), new ArrayList<Mod>(), null);
            }
            if (element.isJsonObject()) {
                JsonObject modObj = element.getAsJsonObject();
                String jarName = modObj.has("jarName") ? modObj.get("jarName").getAsString() : null;
                return this.deserializeModObject(modObj, jarName);
            }
            return new Mod("unknown", null, null, null, new HashSet<String>(), new ArrayList<Mod>(), null);
        }

        private Mod deserializeModObject(JsonObject modObj, String jarName) {
            String modId = modObj.has("modId") ? modObj.get("modId").getAsString() : null;
            String version = modObj.has("version") ? modObj.get("version").getAsString() : null;
            return new Mod(jarName, modId, version, null, new HashSet<String>(), new ArrayList<Mod>(), null);
        }

        public JsonElement serialize(LinkedHashSet<Mod> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            for (Mod mod : src) {
                JsonObject modDetails = this.createModJsonObject(mod);
                root.add(mod.getJarName(), (JsonElement)modDetails);
            }
            return root;
        }

        private JsonObject createModJsonObject(Mod mod) {
            JsonObject modObj = new JsonObject();
            if (mod.getJarName() != null) {
                modObj.addProperty("jarName", mod.getJarName());
            }
            if (mod.getModId() != null) {
                modObj.addProperty("modId", mod.getModId());
            }
            if (mod.getVersion() != null) {
                modObj.addProperty("version", mod.getVersion());
            }
            return modObj;
        }
    }
}

