/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.loading_utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sun.management.OperatingSystemMXBean;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.ProblematicModsConfig;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.IncompatibleMod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModDataParser;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Core;
import oshi.SystemInfo;

public class JarInJarHelper {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantJarInJarHelper");
    public static boolean isClient = false;

    public static void launchCrashAssistantApp(String launchTarget) {
        if (!launchTarget.toLowerCase().contains("client")) {
            LOGGER.warn("launchTarget: " + launchTarget + ". Crash Assistant is client only mod. Mod will do nothing!");
            return;
        }
        isClient = true;
        try {
            Path crashAssistantModJarPath = Paths.get(LibrariesJarLocator.getLibraryJarPath(JarInJarHelper.class), new String[0]).toAbsolutePath();
            LOGGER.info("Launching CrashAssistantApp ({})", (Object)crashAssistantModJarPath.getFileName().toString());
            long currentProcessId = ProcessHelper.getCurrentProcessId();
            String currentProcessData = Objects.toString(currentProcessId) + "_" + Objects.toString(ProcessHelper.getProcessStartTime(currentProcessId));
            Path extractedJarPath = JarInJarHelper.extractJarInJar("app.jar", currentProcessData + "_app.jar");
            String childProcess = ProcessHelper.getChildProcessesInfo();
            if (!childProcess.isEmpty()) {
                PlatformHelp.childProcessesPIDs = childProcess;
            }
            ProcessBuilder crashAssistantAppProcessBuilder = new ProcessBuilder(JavaBinaryLocator.getJavaBinary(), "-XX:+UseSerialGC", "-XX:MaxHeapFreeRatio=30", "-XX:MinHeapFreeRatio=10", "-XX:MaxGCPauseMillis=10000", "-Xms8m", "-Xmx512m", "-jar", extractedJarPath.toAbsolutePath().toString(), "-jarPath", extractedJarPath.toAbsolutePath().toString(), "-parentPID", Objects.toString(ProcessHelper.getCurrentProcessId()), "-parentStarted", Objects.toString(ProcessHelper.getProcessStartTime(ProcessHelper.getCurrentProcessId())), "-parentXms", JarInJarHelper.getJvmArgValue("Xms", "unknown"), "-parentXmx", JarInJarHelper.getJvmArgValue("Xmx", "unknown"), "-systemRAM", JarInJarHelper.formatMemorySize(JarInJarHelper.getTotalPhysicalMemory()), "-platform", PlatformHelp.platform.toString(), "-loaderJarName", PlatformHelp.loaderJarName, "-minecraftVersion", PlatformHelp.minecraftVersion, "-childProcessesPIDs", Base64.getEncoder().encodeToString(PlatformHelp.childProcessesPIDs.getBytes(StandardCharsets.UTF_8)), "-crashAssistantModJarPath", crashAssistantModJarPath.toString(), "-log4jApi", LibrariesJarLocator.getLibraryJarPath(LogManager.class), "-log4jCore", LibrariesJarLocator.getLibraryJarPath(Core.class), "-googleGson", LibrariesJarLocator.getLibraryJarPath(Gson.class), "-commonIo", LibrariesJarLocator.getLibraryJarPath(ReversedLinesFileReader.class), "-processor", new SystemInfo().getHardware().getProcessor().getProcessorIdentifier().getName());
            crashAssistantAppProcessBuilder.start();
            ProblematicModsConfig.crashIfProblematicMod();
        }
        catch (Exception e) {
            LOGGER.error("Error while launching GUI: ", (Throwable)e);
        }
    }

    public static long getTotalPhysicalMemory() {
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return osBean.getTotalPhysicalMemorySize();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public static List<Path> getModJarPathsContainingPart(String part) {
        try {
            return Files.list(Paths.get("mods", new String[0])).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().contains(part.toLowerCase()) && path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<Path>();
        }
    }

    public static List<Mod> mapPathsToMods(List<Path> paths) {
        return paths.stream().map(ModDataParser::parseModData).collect(Collectors.toList());
    }

    public static List<Mod> getModsContainingPart(String ... parts) {
        HashSet<Mod> resultSet = new HashSet<Mod>();
        for (String part : parts) {
            resultSet.addAll(JarInJarHelper.mapPathsToMods(JarInJarHelper.getModJarPathsContainingPart(part)));
        }
        return new ArrayList<Mod>(resultSet);
    }

    public static List<Mod> checkDuplicatedCrashAssistantMod(boolean crashIfDuplicated) {
        try {
            List<Mod> mods = JarInJarHelper.getModsContainingPart("crash_assistant-", "CrashAssistant-");
            if (mods.size() < 2) {
                return new ArrayList<Mod>();
            }
            List modsWithSameModId = mods.stream().filter(mod -> Objects.equals(mod.getModId(), "crash_assistant")).collect(Collectors.toList());
            String duplicatedMods = String.join((CharSequence)"\n", mods.stream().map(Mod::getJarName).collect(Collectors.toList()));
            if (modsWithSameModId.size() > 1) {
                LOGGER.error("Found more than one mod with modid \"crash_assistant\". Crash Assistant is duplicated." + (crashIfDuplicated ? " Crashing!" : "") + "\nDuplicated mods:\n" + duplicatedMods);
                if (crashIfDuplicated) {
                    System.exit(-1);
                }
            } else {
                LOGGER.error("Found more than one mod starting with \"crash_assistant-\":\n" + duplicatedMods + "\nAssuming Crash Assistant is duplicated. Duplicated coremods can produce wired issues.");
            }
            return mods;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking duplicated mods", (Throwable)e);
            return new ArrayList<Mod>();
        }
    }

    public static Optional<IncompatibleMod> checkForIncompatibleMods(boolean crashIfIncompatibleModDetected) {
        if (!isClient && crashIfIncompatibleModDetected) {
            return Optional.empty();
        }
        for (IncompatibleMod incompatibleMod : IncompatibleMod.incompatibleMods) {
            List<Mod> mods;
            List<Path> modPaths = JarInJarHelper.getModJarPathsContainingPart(incompatibleMod.getJarNamePart());
            if (modPaths.isEmpty() || (mods = JarInJarHelper.mapPathsToMods(modPaths).stream().filter(mod -> Objects.equals(mod.getModId(), incompatibleMod.getModId())).collect(Collectors.toList())).isEmpty()) continue;
            incompatibleMod.addDetectedMods(mods);
            if (crashIfIncompatibleModDetected) {
                String incompatibleModsString = String.join((CharSequence)", ", mods.stream().map(Mod::getJarName).collect(Collectors.toList()));
                String crashAssistantString = "Crash Assistant";
                try {
                    crashAssistantString = Paths.get(LibrariesJarLocator.getLibraryJarPath(JarInJarHelper.class), new String[0]).getFileName().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String incompatibleMessage = crashAssistantString + " and " + incompatibleModsString + "are incompatible.";
                if (CrashAssistantConfig.getBoolean("compatibility.enabled")) {
                    LOGGER.error("Crash Assistant detected incompatible mod(s), crashing to prevent potential issues:\n{}", (Object)(incompatibleMessage + " Remove one of them."));
                    System.exit(-1);
                } else {
                    LOGGER.warn("Crash Assistant detected incompatible mod(s). Compatibility check is disabled! Issues may arise!\n{}", (Object)(incompatibleMessage + " Continue at your own risk!"));
                }
            }
            return Optional.of(incompatibleMod);
        }
        return Optional.empty();
    }

    public static Path extractJarInJar(String embeddedName, String outputName) throws IOException {
        Path outputDirectory = Paths.get("local", "crash_assistant");
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        Path extractedJarPath = outputDirectory.resolve(outputName);
        Files.list(outputDirectory).forEach(path -> {
            block9: {
                String processInfo;
                String fileName = path.getFileName().toString();
                if (Files.isRegularFile(path, new LinkOption[0]) && fileName.endsWith("app.jar")) {
                    String processInfo2 = fileName.split("_app.jar")[0];
                    Path processInfoPath = outputDirectory.resolve(processInfo2 + ".info");
                    try {
                        Files.deleteIfExists(path);
                        Files.deleteIfExists(processInfoPath);
                    }
                    catch (IOException e) {
                        Long app_pid;
                        if (!Files.exists(processInfoPath, new LinkOption[0]) || !CrashAssistantConfig.getBoolean("general.kill_old_app")) break block9;
                        Long minecraft_pid = Long.parseLong(processInfo2.split("_")[0]);
                        Long start_time = Long.parseLong(processInfo2.split("_")[1]);
                        try {
                            byte[] bytes = Files.readAllBytes(processInfoPath);
                            String content = new String(bytes, StandardCharsets.UTF_8);
                            app_pid = Long.parseLong(content);
                        }
                        catch (IOException ex) {
                            LOGGER.error("Error while reading " + String.valueOf(processInfoPath) + ". This should never happen:", (Throwable)ex);
                            throw new RuntimeException(ex);
                        }
                        boolean isAppProcessAlive = ProcessHelper.isProcessAlive(app_pid);
                        long minecraftStartTime = ProcessHelper.getProcessStartTime(minecraft_pid);
                        if (isAppProcessAlive && (!ProcessHelper.isProcessAlive(minecraft_pid) || minecraftStartTime != start_time)) {
                            LOGGER.warn("Closed old CrashAssistantApp process to prevent confusing the player with window containing information from old crash.");
                            ProcessHelper.destroyProcess(app_pid);
                            new Timer().schedule(new TimerTask((Path)path, processInfoPath){
                                final /* synthetic */ Path val$path;
                                final /* synthetic */ Path val$processInfoPath;
                                {
                                    this.val$path = path;
                                    this.val$processInfoPath = path2;
                                }

                                @Override
                                public void run() {
                                    try {
                                        Files.deleteIfExists(this.val$path);
                                        Files.deleteIfExists(this.val$processInfoPath);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }, 5000L);
                        }
                        break block9;
                    }
                }
                if (Files.isRegularFile(path, new LinkOption[0]) && fileName.endsWith(".info") && fileName.contains("_") && !Files.exists(outputDirectory.resolve((processInfo = fileName.split("\\.info")[0]) + "_app.jar"), new LinkOption[0])) {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        JarInJarHelper.unzipFromJar("/META-INF/jarjar/" + embeddedName, extractedJarPath);
        return extractedJarPath;
    }

    public static void unzipFromJar(String embeddedPath, Path extractedPath) {
        if (!((String)embeddedPath).startsWith("/")) {
            embeddedPath = "/" + (String)embeddedPath;
        }
        try {
            InputStream jarStream = JarInJarHelper.class.getResourceAsStream((String)embeddedPath);
            if (jarStream == null) {
                throw new FileNotFoundException("Could not find embedded JAR: " + (String)embeddedPath);
            }
            try (OutputStream out = Files.newOutputStream(extractedPath, new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = jarStream.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to unzip file from jar " + (String)embeddedPath, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static HashMap<String, String> readJsonFromJar(String embeddedPath) {
        if (!((String)embeddedPath).startsWith("/")) {
            embeddedPath = "/" + (String)embeddedPath;
        }
        try (InputStream jarStream = JarInJarHelper.class.getResourceAsStream((String)embeddedPath);){
            HashMap hashMap;
            if (jarStream == null) {
                throw new FileNotFoundException("Could not find embedded JAR: " + (String)embeddedPath);
            }
            try (InputStreamReader reader = new InputStreamReader(jarStream, StandardCharsets.UTF_8);){
                JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                if (jsonElement == null || !jsonElement.isJsonObject()) {
                    throw new IllegalStateException("JSON content is not a valid JSON object.");
                }
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
                hashMap = (HashMap)new Gson().fromJson((JsonElement)jsonObject, mapType);
            }
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read json from jar: {}", embeddedPath, (Object)e);
            return new HashMap<String, String>();
        }
    }

    public static HashMap<String, String> readJsonFromFile(Path path) {
        block12: {
            HashMap<String, String> hashMap;
            block11: {
                BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    hashMap = JarInJarHelper.convertJsonToMap(new JsonParser().parse((Reader)reader).getAsJsonObject());
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonSyntaxException e) {
                        LOGGER.error("Failed to read corrupted json from file '{}'. Renaming to .bak", (Object)path, (Object)e);
                        String fileName = path.getFileName().toString();
                        try {
                            path.toFile().renameTo(Paths.get(path.getParent().toString(), fileName + ".bak").toFile());
                        }
                        catch (Exception e1) {
                            LOGGER.error("Failed to rename '" + fileName + "' to '" + fileName + ".bak': ", (Throwable)e1);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to read json from file " + path.toString(), (Throwable)e);
                    }
                }
                ((Reader)reader).close();
            }
            return hashMap;
        }
        return new HashMap<String, String>();
    }

    public static void writeJsonToFile(Map<String, String> json, Path path) {
        try (FileWriter writer = new FileWriter(path.toFile());){
            Gson GSON = new GsonBuilder().setPrettyPrinting().create();
            GSON.toJson(json, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving json " + String.valueOf(path), (Throwable)e);
        }
    }

    public static HashMap<String, String> convertJsonToMap(JsonObject json) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry entry : json.entrySet()) {
            values.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return values;
    }

    public static Path getJarInJar(String name) throws IOException, URISyntaxException {
        Path pathInModFile = Paths.get(JarInJarHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI()).resolve("META-INF/jarjar/" + name);
        URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
        Map<String, Path> outerFsArgs = Collections.singletonMap("packagePath", pathInModFile);
        FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
        return zipFS.getPath("/", new String[0]);
    }

    public static String getJvmArgValue(String argName, String fallback) {
        try {
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : inputArgs) {
                if (!arg.startsWith("-" + argName)) continue;
                if (arg.length() > argName.length() + 1) {
                    return arg.substring(argName.length() + 1);
                }
                return arg.substring(1);
            }
            if (argName.equals("Xmx") && fallback.equals("unknown")) {
                return JarInJarHelper.formatMemorySize(Runtime.getRuntime().maxMemory());
            }
            return fallback;
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving JVM argument {}: {}", (Object)argName, (Object)e.getMessage());
            return fallback;
        }
    }

    private static String formatMemorySize(long bytes) {
        if (bytes >= 0x40000000L) {
            double gb = (double)bytes / 1.073741824E9;
            String formatted = String.format(Locale.US, "%.1f", gb).replace(".0", "");
            return formatted + "g";
        }
        double mb = (double)bytes / 1048576.0;
        String formatted = String.format(Locale.US, "%.1f", mb).replace(".0", "");
        return formatted + "m";
    }
}

