/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common.commands;

import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.HeapDumper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ThreadDumper;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.IClientCommand;

public class CrashAssistantCommands
extends CommandBase
implements IClientCommand {
    private static String latestDiffText = "";
    private static String latestNickname = "";
    private static final Map<String, String> SUPPORTED_CRASH_CMDS = new HashMap<String, String>(){
        {
            this.put("game", "Minecraft");
            this.put("jvm", "JVM");
            this.put("no_crash", "noCrash");
        }
    };
    private static final Set<String> SUPPORTED_CRASH_ARGS = new HashSet<String>(Arrays.asList("--withThreadDump", "--withHeapDump", "--GCBeforeHeapDump"));
    private static Instant lastCrashCommand = Instant.EPOCH;

    public String getName() {
        return "crash_assistant";
    }

    public String getUsage(ICommandSender sender) {
        return "/crash_assistant <modlist|crash> \u2026";
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        LanguageProvider.updateLang();
        if (args.length == 0) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red(this.getUsage(sender)));
            return;
        }
        switch (args[0]) {
            case "modlist": {
                this.handleModlist(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "crash": {
                this.handleCrash(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "copy_to_clipboard": {
                this.handleCopyToClipboard(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red(this.getUsage(sender)));
            }
        }
    }

    private void handleModlist(String[] args) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return;
        }
        if (args.length == 0) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red("/crash_assistant modlist <save|diff>"));
            return;
        }
        switch (args[0]) {
            case "save": {
                this.saveModlist();
                break;
            }
            case "diff": {
                this.showDiff();
                break;
            }
            default: {
                CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red("/crash_assistant modlist <save|diff>"));
            }
        }
    }

    private void saveModlist() {
        TextComponentString msg = new TextComponentString("");
        if (CrashAssistantConfig.getModpackCreators().contains(CrashAssistant.playerNickname)) {
            ModListUtils.saveCurrentModList();
            msg.appendSibling((ITextComponent)CrashAssistantCommands.green(LanguageProvider.get("commands.modlist_overwritten_success")));
            msg.appendSibling((ITextComponent)new TextComponentString(" "));
            if (CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
                msg.appendSibling((ITextComponent)CrashAssistantCommands.white(LanguageProvider.get("commands.modlist_auto_update_msg")));
            } else {
                msg.appendSibling((ITextComponent)CrashAssistantCommands.white(LanguageProvider.get("commands.modlist_enable_auto_update_msg")));
            }
            msg.appendSibling(CrashAssistantCommands.getModConfigComponent());
        } else {
            msg.appendSibling((ITextComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.not_creator_error_msg")));
            msg.appendSibling(CrashAssistantCommands.getCopyNicknameComponent(CrashAssistant.playerNickname));
            msg.appendSibling((ITextComponent)CrashAssistantCommands.white(LanguageProvider.get("commands.add_to_creator_list_msg")));
            msg.appendSibling(CrashAssistantCommands.getModConfigComponent());
        }
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
    }

    private void showDiff() {
        ModListDiff diff = ModListDiff.getDiff(false);
        ModListDiffStringBuilder builder = diff.generateDiffMsg(false);
        ComponentModListDiffStringBuilder compBuilder = new ComponentModListDiffStringBuilder(builder);
        TextComponentString comp = compBuilder.toComponent();
        comp.appendSibling(CrashAssistantCommands.getCopyDiffComponent(diff.generateDiffMsg(true)));
        CrashAssistantCommands.sendClientMsg((ITextComponent)comp);
    }

    private void handleCopyToClipboard(String[] args) {
        boolean isNickname;
        boolean bl = isNickname = args.length > 0 && "nickname".equals(args[0]);
        if (isNickname) {
            if (latestNickname.isEmpty()) {
                CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red("No nickname available to copy"));
                return;
            }
            GuiScreen.setClipboardString((String)latestNickname);
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.green("Nickname copied to clipboard"));
        } else {
            if (latestDiffText.isEmpty()) {
                CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red("No diff text available to copy"));
                return;
            }
            GuiScreen.setClipboardString((String)latestDiffText);
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.green("Mod list diff copied to clipboard"));
        }
    }

    private void handleCrash(String[] args) {
        if (!CrashAssistantConfig.getBoolean("crash_command.enabled")) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red("Crash-command is disabled in the config."));
            return;
        }
        if (args.length == 0) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red("/crash_assistant crash <game|jvm|no_crash> [args]"));
            return;
        }
        String toCrashKey = args[0];
        if (!SUPPORTED_CRASH_CMDS.containsKey(toCrashKey)) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.crash_command_validation_failed_to_crash") + " '" + toCrashKey + "'"));
            return;
        }
        String toCrash = SUPPORTED_CRASH_CMDS.get(toCrashKey);
        List<String> flags = Arrays.asList(args).subList(1, args.length);
        boolean noCrash = "noCrash".equals(toCrash);
        int seconds = (Integer)CrashAssistantConfig.get("crash_command.seconds");
        if (seconds <= 0 || Instant.now().isBefore(lastCrashCommand.plusSeconds(seconds)) || noCrash) {
            if (!CrashAssistantCommands.validateCrashArgs(flags)) {
                return;
            }
            new Thread(() -> this.actuallyCrash(toCrash, flags)).start();
            return;
        }
        lastCrashCommand = Instant.now();
        TextComponentString msg = new TextComponentString("");
        msg.appendSibling((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_1")));
        msg.appendSibling(new TextComponentString(toCrash).setStyle(new Style().setColor(TextFormatting.YELLOW)));
        msg.appendSibling((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_2")));
        msg.appendSibling(new TextComponentString(Integer.toString(seconds)).setStyle(new Style().setColor(TextFormatting.YELLOW)));
        msg.appendSibling((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_3"))).setStyle(new Style().setColor(TextFormatting.RED));
        msg.setStyle(new Style().setColor(TextFormatting.RED));
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
    }

    private void actuallyCrash(String toCrash, List<String> flags) {
        if (!flags.isEmpty()) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.yellow(LanguageProvider.get("commands.crash_command_applying_args")));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (flags.contains("--withThreadDump")) {
            CrashAssistant.LOGGER.error("ThreadDump:\n" + ThreadDumper.obtainThreadDump());
        }
        if (flags.contains("--withHeapDump")) {
            if (flags.contains("--GCBeforeHeapDump")) {
                CrashAssistant.LOGGER.info("GC before heap dump");
                System.gc();
            }
            try {
                CrashAssistant.LOGGER.error("Created heap dump at: " + HeapDumper.createHeapDump());
            }
            catch (Exception e) {
                CrashAssistant.LOGGER.error("Failed to create heap dump", (Throwable)e);
            }
        }
        if ("noCrash".equals(toCrash)) {
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.green(LanguageProvider.get("commands.crash_command_done")));
            return;
        }
        CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.crash_command_crashing")));
        if ("Minecraft".equals(toCrash)) {
            Minecraft.getMinecraft().addScheduledTask((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    String reason = "Minecraft crashed by '/crash_assistant crash'";
                    CrashReport report = CrashReport.makeCrashReport((Throwable)new Throwable(reason), (String)reason);
                    if (Minecraft.getMinecraft().world != null) {
                        Minecraft.getMinecraft().addGraphicsAndWorldToCrashReport(report);
                    }
                    Minecraft.getMinecraft().displayCrashReport(report);
                    return null;
                }
            });
        } else {
            CrashAssistant.LOGGER.error("JVM crashed by '/crash_assistant crash jvm'");
            UnsafeAccess.UNSAFE.setMemory(0L, 1L, (byte)0);
        }
    }

    private static boolean checkModlistFeatureEnabled() {
        LanguageProvider.updateLang();
        if (CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return true;
        }
        TextComponentString msg = CrashAssistantCommands.red(LanguageProvider.get("commands.modlist_disabled_error_msg"));
        msg.appendSibling(CrashAssistantCommands.getModConfigComponent());
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return false;
    }

    private static boolean validateCrashArgs(List<String> args) {
        for (String arg : args) {
            if (SUPPORTED_CRASH_ARGS.contains(arg)) continue;
            CrashAssistantCommands.sendClientMsg((ITextComponent)CrashAssistantCommands.red(LanguageProvider.get("commands.crash_command_validation_failed") + " '" + arg + "'"));
            return false;
        }
        return true;
    }

    public static void sendClientMsg(ITextComponent comp) {
        Minecraft mc = Minecraft.getMinecraft();
        mc.addScheduledTask(() -> mc.ingameGUI.getChatGUI().printChatMessage(comp));
    }

    private static TextComponentString colored(String txt, TextFormatting fmt) {
        TextComponentString component = new TextComponentString(txt);
        component.setStyle(new Style().setColor(fmt));
        return component;
    }

    private static TextComponentString red(String txt) {
        return CrashAssistantCommands.colored(txt, TextFormatting.RED);
    }

    private static TextComponentString green(String txt) {
        return CrashAssistantCommands.colored(txt, TextFormatting.GREEN);
    }

    private static TextComponentString white(String txt) {
        return CrashAssistantCommands.colored(txt, TextFormatting.WHITE);
    }

    private static TextComponentString yellow(String txt) {
        return CrashAssistantCommands.colored(txt, TextFormatting.YELLOW);
    }

    public static ITextComponent getModConfigComponent() {
        return new TextComponentString("[mod config]").setStyle(new Style().setColor(TextFormatting.YELLOW).setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, CrashAssistantConfig.getConfigPath().toAbsolutePath().toString())).setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LanguageProvider.get("commands.mod_config_tooltip")))));
    }

    public static ITextComponent getCopyNicknameComponent(String name) {
        latestNickname = name;
        return new TextComponentString("[nickname]").setStyle(new Style().setColor(TextFormatting.YELLOW).setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/crash_assistant copy_to_clipboard nickname")).setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LanguageProvider.get("commands.nickname_tooltip")))));
    }

    public static ITextComponent getCopyDiffComponent(ModListDiffStringBuilder diff) {
        latestDiffText = diff.toText();
        return new TextComponentString("[" + LanguageProvider.get("commands.diff_copy") + "]").setStyle(new Style().setColor(TextFormatting.YELLOW).setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/crash_assistant copy_to_clipboard")).setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LanguageProvider.get("commands.diff_tooltip")))));
    }

    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CrashAssistantCommands.getListOfStringsMatchingLastWord((String[])args, Arrays.asList("modlist", "crash"));
        }
        if ("modlist".equals(args[0]) && args.length == 2) {
            return CrashAssistantCommands.getListOfStringsMatchingLastWord((String[])args, Arrays.asList("save", "diff"));
        }
        if ("crash".equals(args[0])) {
            if (args.length == 2) {
                return CrashAssistantCommands.getListOfStringsMatchingLastWord((String[])args, SUPPORTED_CRASH_CMDS.keySet());
            }
            ArrayList<String> left = new ArrayList<String>(SUPPORTED_CRASH_ARGS);
            left.removeAll(Arrays.asList(args).subList(2, args.length));
            if (!Arrays.asList(args).contains("--withHeapDump")) {
                left.remove("--GCBeforeHeapDump");
            }
            return CrashAssistantCommands.getListOfStringsMatchingLastWord((String[])args, left);
        }
        return Collections.emptyList();
    }

    public boolean allowUsageWithoutPrefix(ICommandSender sender, String message) {
        return false;
    }

    public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public static class ComponentModListDiffStringBuilder
    extends ModListDiffStringBuilder {
        public ComponentModListDiffStringBuilder(ModListDiffStringBuilder sb) {
            this.sb = sb.sb;
        }

        public TextComponentString toComponent() {
            TextComponentString base = new TextComponentString("");
            for (ModListDiffStringBuilder.ColoredString cs : this.sb) {
                TextComponentString part = new TextComponentString(cs.getText());
                if (!cs.getColor().isEmpty()) {
                    part.setStyle(new Style().setColor(TextFormatting.valueOf((String)cs.getColor().toUpperCase())));
                }
                base.appendSibling((ITextComponent)part);
                if (!cs.isEndsWithNewLine()) continue;
                base.appendSibling((ITextComponent)new TextComponentString("\n"));
            }
            return base;
        }
    }
}

