/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.loading_utils;

import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LauncherLogger {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static volatile PrintStream ORIGINAL_ERR;
    private static volatile PrintStream INSTALLED_ERR;
    private static volatile Thread SHUTDOWN_HOOK;
    private static final String LOGS_DIR_NAME = "logs";
    private static final String LOG_FILE_NAME = "stderr_stream.log";

    private LauncherLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirectToFile() {
        if (!INSTALLED.compareAndSet(false, true)) {
            return;
        }
        boolean systemErrSwapped = false;
        FilterOutputStream bufferedFile = null;
        try {
            ORIGINAL_ERR = System.err;
            File logsDir = new File(LOGS_DIR_NAME);
            if (logsDir.exists() && !logsDir.isDirectory()) {
                ORIGINAL_ERR.println("[LauncherLogger] Path exists and is not a directory: " + logsDir.getAbsolutePath());
                INSTALLED.set(false);
                return;
            }
            if (!logsDir.exists() && !logsDir.mkdirs()) {
                ORIGINAL_ERR.println("[LauncherLogger] Failed to create logs directory: " + logsDir.getAbsolutePath());
                INSTALLED.set(false);
                return;
            }
            File logFile = new File(logsDir, LOG_FILE_NAME);
            FileOutputStream fos = new FileOutputStream(logFile, false);
            bufferedFile = new BufferedOutputStream(fos, 65536);
            Charset consoleCs = LauncherLogger.detectConsoleCharset(ORIGINAL_ERR);
            LauncherLogger.writeFileHeader((BufferedOutputStream)bufferedFile, consoleCs);
            NonClosingOutputStream consoleSide = new NonClosingOutputStream(ORIGINAL_ERR);
            FilterOutputStream fileSide = bufferedFile;
            TeeOutputStream tee = new TeeOutputStream(consoleSide, fileSide, consoleCs);
            INSTALLED_ERR = new PrintStream((OutputStream)tee, true, consoleCs.name());
            System.setErr(INSTALLED_ERR);
            systemErrSwapped = true;
            SHUTDOWN_HOOK = new Thread(() -> {
                block6: {
                    try {
                        PrintStream ps = INSTALLED_ERR;
                        if (ps == null) break block6;
                        try {
                            System.setErr(ORIGINAL_ERR);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, "LauncherLogger-Stderr-ShutdownHook");
            try {
                Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            try {
                if (systemErrSwapped) {
                    System.setErr(ORIGINAL_ERR);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (INSTALLED_ERR != null) {
                    INSTALLED_ERR.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            INSTALLED_ERR = null;
            try {
                if (bufferedFile != null) {
                    bufferedFile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (SHUTDOWN_HOOK != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SHUTDOWN_HOOK = null;
            }
            try {
                if (ORIGINAL_ERR != null) {
                    e.printStackTrace(ORIGINAL_ERR);
                } else {
                    e.printStackTrace();
                }
            }
            finally {
                INSTALLED.set(false);
            }
        }
    }

    private static void writeFileHeader(BufferedOutputStream out, Charset cs) throws IOException {
        String ls = System.lineSeparator();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm XXX", Locale.ROOT);
        df.setTimeZone(TimeZone.getDefault());
        String dateTime = df.format(new Date());
        StringBuilder sb = new StringBuilder(256);
        sb.append("-----------------------------------------------------------------------------------").append(ls);
        sb.append("DateTime: ").append(dateTime).append("; PID: ").append(ProcessHelper.getCurrentProcessId()).append(ls);
        sb.append("This file contains the stderr stream of the Minecraft process logged to a file.").append(ls);
        sb.append("It does not include stdout or log (log4j) messages to avoid performance impact.").append(ls);
        sb.append("-----------------------------------------------------------------------------------").append(ls);
        out.write(sb.toString().getBytes(cs));
        out.flush();
    }

    private static Charset detectConsoleCharset(PrintStream ps) {
        String[] props;
        for (String p : props = new String[]{"sun.stderr.encoding", "sun.stdout.encoding", "native.encoding", "file.encoding"}) {
            try {
                String v = System.getProperty(p);
                if (v == null || v.isEmpty()) continue;
                try {
                    return Charset.forName(v);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Method m = PrintStream.class.getDeclaredMethod("charset", new Class[0]);
            m.setAccessible(true);
            Object cs = m.invoke((Object)ps, new Object[0]);
            if (cs instanceof Charset) {
                return (Charset)cs;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    private static final class NonClosingOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        NonClosingOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.flush();
        }
    }

    private static final class TeeOutputStream
    extends OutputStream {
        private final OutputStream left;
        private final OutputStream right;
        private final Charset cs;
        private boolean atLineStart = true;
        private final SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
        private final Date tsReuse = new Date();

        TeeOutputStream(OutputStream left, OutputStream right, Charset cs) {
            this.left = left;
            this.right = right;
            this.cs = cs;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.atLineStart) {
                this.writePrefixToFile();
                this.atLineStart = false;
            }
            IOException leftEx = null;
            try {
                this.left.write(b);
            }
            catch (IOException e) {
                leftEx = e;
            }
            try {
                this.right.write(b);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (b == 10) {
                block11: {
                    try {
                        this.right.flush();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        this.left.flush();
                    }
                    catch (IOException e) {
                        if (leftEx != null) break block11;
                        leftEx = e;
                    }
                }
                this.atLineStart = true;
            }
            if (leftEx != null) {
                throw leftEx;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int chunkLen;
            int end = off + len;
            IOException leftEx = null;
            for (int i = off; i < end; i += chunkLen) {
                block13: {
                    block12: {
                        int j;
                        if (this.atLineStart) {
                            this.writePrefixToFile();
                            this.atLineStart = false;
                        }
                        for (j = i; j < end && b[j] != 10; ++j) {
                        }
                        chunkLen = j < end && b[j] == 10 ? j - i + 1 : j - i;
                        try {
                            this.left.write(b, i, chunkLen);
                        }
                        catch (IOException e) {
                            if (leftEx != null) break block12;
                            leftEx = e;
                        }
                    }
                    try {
                        this.right.write(b, i, chunkLen);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (chunkLen <= 0 || b[i + chunkLen - 1] != 10) continue;
                    try {
                        this.right.flush();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        this.left.flush();
                    }
                    catch (IOException e) {
                        if (leftEx != null) break block13;
                        leftEx = e;
                    }
                }
                this.atLineStart = true;
            }
            if (leftEx != null) {
                throw leftEx;
            }
        }

        @Override
        public void flush() throws IOException {
            IOException leftEx = null;
            try {
                this.left.flush();
            }
            catch (IOException e) {
                leftEx = e;
            }
            try {
                this.right.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (leftEx != null) {
                throw leftEx;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.left.close();
            }
            finally {
                try {
                    this.right.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void writePrefixToFile() {
            try {
                this.tsReuse.setTime(System.currentTimeMillis());
                String t = this.timeFmt.format(this.tsReuse);
                StringBuilder sb = new StringBuilder(32);
                sb.append('[').append(t).append(']').append(' ').append("[STDERR]: ").append("");
                byte[] bytes = sb.toString().getBytes(this.cs);
                this.right.write(bytes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

