/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.forge;

import com.mojang.brigadier.CommandDispatcher;
import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common.CrashAssistantHooks;
import dev.kostromdan.mods.crash_assistant.common.commands.CrashAssistantCommands;
import dev.kostromdan.mods.crash_assistant.common.events.CrashAssistantEvents;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod(value="crash_assistant")
public final class CrashAssistantForge {
    public CrashAssistantForge() {
        CrashAssistant.init();
    }

    @Mod.EventBusSubscriber(modid="crash_assistant", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientModEvents {
        private static boolean mainMenuOpened = false;
        private static int ticksAfterMainMenu = 0;
        private static final int TICKS_TO_WAIT = 1;

        @SubscribeEvent
        public static void onServerStarting(FMLServerStartingEvent event) {
            CommandDispatcher dispatcher = event.getCommandDispatcher();
            dispatcher.register(CrashAssistantCommands.getCommands());
        }

        @SubscribeEvent
        public static void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            CrashAssistantEvents.onGameJoin();
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && mainMenuOpened && ++ticksAfterMainMenu >= 1) {
                CrashAssistantHooks.onClientLoaded();
                mainMenuOpened = false;
                ticksAfterMainMenu = 0;
            }
        }

        @SubscribeEvent
        public static void onGuiOpen(GuiOpenEvent event) {
            Screen gui = event.getGui();
            if (gui != null && gui instanceof MainMenuScreen) {
                mainMenuOpened = true;
                ticksAfterMainMenu = 0;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="crash_assistant", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            CrashAssistantHooks.afterMinecraftInit();
        }
    }
}

