/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.config;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.Config;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.file.FileConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.io.ParsingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProblematicModsConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "crash_assistant", "problematic_mods_config.json");

    public static List<ProblematicMod> getProblematicModsFromConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object config = FileConfig.builder(CONFIG_PATH).preserveInsertionOrder().build();
        try {
            config.load();
        }
        catch (ParsingException e) {
            JarInJarHelper.LOGGER.error("Error while loading problematic_mods_config.json, saved old problematic config as 'problematic_mods_config.json.bak', resetting config to default values:", (Throwable)e);
            try {
                CONFIG_PATH.toFile().renameTo(Paths.get(CONFIG_PATH.getParent().toString(), "problematic_mods_config.json.bak").toFile());
            }
            catch (Exception e1) {
                JarInJarHelper.LOGGER.error("Failed to rename 'problematic_mods_config.json' to 'problematic_mods_config.json.bak': ", (Throwable)e1);
            }
            config.clear();
        }
        ProblematicModsConfig.setUpDefaultConfig(config);
        config.save();
        ArrayList<ProblematicMod> problematicMods = new ArrayList<ProblematicMod>();
        for (Map.Entry<String, Object> entry : config.valueMap().entrySet()) {
            String modid = entry.getKey();
            if (modid.equals("example_modid")) continue;
            Object value = entry.getValue();
            if (value instanceof Config) {
                Config modConfig = (Config)value;
                boolean shouldCrash = modConfig.getOrElse("should_crash_on_startup", Boolean.valueOf(false));
                boolean displayButtons = modConfig.getOrElse("display_remove_disable_buttons", Boolean.valueOf(false));
                String msg = modConfig.getOrElse("msg", "");
                problematicMods.add(new ProblematicMod(modid, null, shouldCrash, msg));
                continue;
            }
            JarInJarHelper.LOGGER.warn("Invalid config entry for modid '{}': expected a config object, got {}", (Object)modid, value);
        }
        return problematicMods;
    }

    public static List<ProblematicMod> getCurrentProblematicMods() {
        List<ProblematicMod> problematicMods = ProblematicModsConfig.getProblematicModsFromConfig();
        LinkedHashSet<Mod> currentMods = ModListUtils.getCurrentModList(true);
        Map<String, ProblematicMod> configMap = problematicMods.stream().collect(Collectors.toMap(ProblematicMod::modid, pm -> pm));
        return currentMods.stream().filter(mod -> configMap.containsKey(mod.getModId())).map(mod -> {
            ProblematicMod fromConfig = (ProblematicMod)configMap.get(mod.getModId());
            return new ProblematicMod(fromConfig.modid(), (Mod)mod, fromConfig.should_crash_on_startup(), fromConfig.msg());
        }).collect(Collectors.toList());
    }

    public static void setUpDefaultConfig(FileConfig config) {
        if (config.isEmpty()) {
            Config exampleModConfig = Config.inMemory();
            exampleModConfig.set("should_crash_on_startup", (Object)true);
            exampleModConfig.set("msg", (Object)"Custom msg on crash for this mod id. You can use $JAR_NAME$ placeholder, which will be replaced with jar name. You can use HTML here, it will work.");
            config.set("example_modid", (Object)exampleModConfig);
        }
    }

    public static void crashIfProblematicMod() {
        List<ProblematicMod> problematicModsFromConfig = ProblematicModsConfig.getProblematicModsFromConfig();
        if (problematicModsFromConfig.stream().noneMatch(ProblematicMod::should_crash_on_startup)) {
            return;
        }
        List<ProblematicMod> problematicMods = ProblematicModsConfig.getCurrentProblematicMods();
        boolean shouldCrash = false;
        for (ProblematicMod mod : problematicMods) {
            if (!mod.should_crash_on_startup()) continue;
            shouldCrash = true;
            Mod currentMod = mod.currentMod();
            JarInJarHelper.LOGGER.error("Detected " + currentMod.getJarName() + "(modId: " + mod.modid() + ") in current modlist. It marked as incompatible with this modpack(" + String.valueOf(CONFIG_PATH) + "). Crashing game and starting Crash Assistant.");
        }
        if (shouldCrash) {
            System.exit(-1);
        }
    }

    public record ProblematicMod(String modid, Mod currentMod, boolean should_crash_on_startup, String msg) {
    }
}

