/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MalwareMod {
    private final String jarNamePart;
    private final String modId;
    private final String explainMessage;
    private final List<Mod> detectedMods = new ArrayList<Mod>();
    public static final HashSet<MalwareMod> malwareMods = new HashSet<MalwareMod>(){
        {
            this.add(new MalwareMod("crashdetectormc", "crashdetector", "We have strong reasons to believe that this mod was created by, or in cooperation with, individuals somehow affiliated with the international criminal organisation commonly referred to as \"TLauncher.\" This group is known for covertly monitoring its users, unlawfully collecting data, engaging in espionage, reselling personal information.\n\nOur investigation indicates that the mod uploads game logs to the domain \"securelogger.net\", which we have strong reasons to believe is registered to and controlled by the same organisation. Game logs frequently contain highly sensitive data, including your session accessToken\u2014which, while valid, temporarily enables direct access to your Minecraft account. Uploading this token to infrastructure managed by a hostile entity poses a clear and immediate threat to your privacy and account security.\n\nEven though the domain name \u201csecurelogger.net\u201d sounds trustworthy, the mod doesn\u2019t disclose who runs it\u2014so you can\u2019t know if this hostile group is acting as your data controller without conducting your own investigation.\n\nIn addition, the mod is essentially a poorly implemented copy of Crash Assistant with many critical features removed. There is no legitimate reason to use it, and we suspect that the authors replicated Crash Assistant\u2019s concept solely to collect unauthorised data from licensed Minecraft users.\n\nThe mod is not a virus; if you have not uploaded logs through it, you are safe (at least as of the time of our investigation, provided that no new malware has been added). There are also several other significant privacy issues, but I am discussing them with CurseForge. Until the project and the author\u2019s account are permanently banned, I cannot share these details, as the authors could temporary remediate them.\n\nThese conclusions reflect information available as of May 1, 2025. This notice is provided \"as is\", without warranties of any kind. We are not responsible for any changes that may occur after the date of this notice."));
        }
    };

    public MalwareMod(String jarNamePart, String modId, String explainMessage) {
        this.jarNamePart = jarNamePart;
        this.modId = modId;
        this.explainMessage = explainMessage;
    }

    public String getJarNamePart() {
        return this.jarNamePart;
    }

    public String getModId() {
        return this.modId;
    }

    public String getExplainMessage() {
        return this.explainMessage;
    }

    public List<Mod> getDetectedMods() {
        return this.detectedMods;
    }

    public void addDetectedMod(Mod mod) {
        this.detectedMods.add(mod);
    }

    public void addDetectedMods(List<Mod> mods) {
        this.detectedMods.addAll(mods);
    }
}

