/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.IModLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashAssistantDependencyLocator
extends AbstractJarFileLocator {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantDependencyLocator");

    public List<ModFile> scanMods() {
        return CrashAssistantDependencyLocator.getJarPath().map(p -> {
            ModFile modFile = new ModFile(p, (IModLocator)this);
            this.modJars.compute(modFile, (mf, fs) -> this.createFileSystem((ModFile)mf));
            return Collections.singletonList(modFile);
        }).orElse(Collections.emptyList());
    }

    public String name() {
        return "CrashAssistantDependencyLocator";
    }

    public void initArguments(Map<String, ?> map) {
    }

    public static Optional<URL> getOurJar() {
        Path p;
        URL url = CrashAssistantDependencyLocator.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            p = Paths.get(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (p.getFileName().toString().toLowerCase().endsWith(".jar")) {
            return Optional.of(url);
        }
        return Optional.empty();
    }

    public static Optional<Path> getJarPath() {
        return CrashAssistantDependencyLocator.getOurJar().map(url -> {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        });
    }
}

