/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleUnixAbstractImpl;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.StringTokenizer;

public class ProcessHandleLinuxImpl
extends ProcessHandleUnixAbstractImpl {
    private static final LinuxCLibrary LIBC;
    private static final int _SC_CLK_TCK = 2;
    private static final long CLOCK_TICKS_PER_SECOND;
    private static final long BOOT_TIME_MS;

    @Override
    public Optional<String> getCurrentProcessCommand() {
        long pid = this.getCurrentProcessId();
        try {
            Path cmdlinePath = Paths.get("/proc/" + pid + "/cmdline", new String[0]);
            byte[] data = Files.readAllBytes(cmdlinePath);
            if (data.length > 0) {
                int end;
                for (end = 0; end < data.length && data[end] != 0; ++end) {
                }
                String firstToken = new String(data, 0, end, StandardCharsets.UTF_8);
                if (!firstToken.isEmpty()) {
                    return Optional.of(firstToken);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public long getCurrentProcessStartTime() {
        return this.getProcessStartTime(this.getCurrentProcessId());
    }

    @Override
    public long getProcessStartTime(long pid) {
        String path = "/proc/" + pid + "/stat";
        Pointer fp = null;
        try {
            fp = LIBC.fopen(path, "r");
            if (fp == null) {
                return 0L;
            }
            byte[] buf = new byte[2048];
            int read = LIBC.fread(buf, 1, buf.length - 1, fp);
            LIBC.fclose(fp);
            if (read <= 0) {
                return 0L;
            }
            buf[read] = 0;
            String stat = Native.toString((byte[])buf);
            int lParen = stat.indexOf(40);
            int rParen = stat.lastIndexOf(41);
            if (lParen < 0 || rParen < lParen) {
                return 0L;
            }
            String after = stat.substring(rParen + 1).trim();
            StringTokenizer st = new StringTokenizer(after);
            if (!st.hasMoreTokens()) {
                return 0L;
            }
            st.nextToken();
            if (!st.hasMoreTokens()) {
                return 0L;
            }
            st.nextToken();
            for (int i = 0; i < 17; ++i) {
                if (!st.hasMoreTokens()) {
                    return 0L;
                }
                st.nextToken();
            }
            if (!st.hasMoreTokens()) {
                return 0L;
            }
            long startTicks = Long.parseLong(st.nextToken());
            return BOOT_TIME_MS + startTicks * 1000L / CLOCK_TICKS_PER_SECOND;
        }
        catch (Throwable ignored) {
            if (fp != null) {
                try {
                    LIBC.fclose(fp);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return 0L;
        }
    }

    static {
        long bt;
        block9: {
            LIBC = (LinuxCLibrary)Native.loadLibrary((String)"c", LinuxCLibrary.class);
            long ticks = 100L;
            try {
                long t = LIBC.sysconf(2);
                if (t > 0L) {
                    ticks = t;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            CLOCK_TICKS_PER_SECOND = ticks;
            bt = 0L;
            Pointer fStat = null;
            try {
                fStat = LIBC.fopen("/proc/stat", "r");
                if (fStat == null) break block9;
                byte[] buf = new byte[4096];
                int len = LIBC.fread(buf, 1, buf.length - 1, fStat);
                LIBC.fclose(fStat);
                if (len <= 0) break block9;
                buf[len] = 0;
                String stat = Native.toString((byte[])buf);
                for (String line : stat.split("\n")) {
                    if (!line.startsWith("btime")) continue;
                    String[] parts = line.trim().split("\\s+");
                    if (parts.length >= 2) {
                        bt = Long.parseLong(parts[1]) * 1000L;
                    }
                    break;
                }
            }
            catch (Throwable ignored) {
                if (fStat == null) break block9;
                try {
                    LIBC.fclose(fStat);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        BOOT_TIME_MS = bt;
    }

    private static interface LinuxCLibrary
    extends Library {
        public Pointer fopen(String var1, String var2);

        public int fread(byte[] var1, int var2, int var3, Pointer var4);

        public int fclose(Pointer var1);

        public long sysconf(int var1);
    }
}

