/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleAbstractImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public abstract class ProcessHandleUnixAbstractImpl
extends ProcessHandleAbstractImpl {
    @Override
    public boolean isProcessAlive(long pid) {
        try {
            String stat = ProcessHandleUnixAbstractImpl.execAndReadFirst("ps", "-p", String.valueOf(pid), "-o", "stat=");
            if (stat == null) {
                return false;
            }
            if ((stat = stat.trim()).isEmpty()) {
                return false;
            }
            char c = stat.charAt(0);
            return c != 'Z' && c != 'X';
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public String getChildProcessesInfo() {
        return "";
    }

    @Override
    public boolean destroyProcess(long pid) {
        try {
            ProcessBuilder pb = new ProcessBuilder("kill", String.valueOf(pid));
            Process process = pb.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean destroyProcessForcibly(long pid) {
        try {
            ProcessBuilder pb = new ProcessBuilder("kill", "-9", String.valueOf(pid));
            Process process = pb.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    static String execAndReadFirst(String ... cmd) throws Exception {
        Process p = new ProcessBuilder(cmd).redirectErrorStream(true).start();
        try {
            String string;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                string = br.readLine();
            }
            return string;
        }
        finally {
            p.destroy();
        }
    }
}

