/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.UpdatedPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModListDiff {
    private final LinkedHashSet<Mod> currentMods;
    private final LinkedHashSet<Mod> addedMods;
    private final LinkedHashSet<Mod> removedMods;
    private final LinkedHashSet<UpdatedPair> updatedMods;
    private static String filePrefix = null;

    public ModListDiff(LinkedHashSet<Mod> saved, LinkedHashSet<Mod> current) {
        this.currentMods = current;
        this.addedMods = current.stream().filter(mod -> !saved.contains(mod)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.removedMods = saved.stream().filter(mod -> !current.contains(mod)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.updatedMods = new LinkedHashSet();
        LinkedHashMap<String, UpdatedPair> updatedPairCandidates = new LinkedHashMap<String, UpdatedPair>();
        for (Mod mod2 : saved) {
            if (mod2.getModId() == null) continue;
            updatedPairCandidates.computeIfAbsent(mod2.getModId(), k -> new UpdatedPair(new LinkedHashSet<Mod>(), new LinkedHashSet<Mod>())).getOldMods().add(mod2);
        }
        for (Mod mod2 : current) {
            if (mod2.getModId() == null) continue;
            updatedPairCandidates.computeIfAbsent(mod2.getModId(), k -> new UpdatedPair(new LinkedHashSet<Mod>(), new LinkedHashSet<Mod>())).getNewMods().add(mod2);
        }
        Iterator iterator = updatedPairCandidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            UpdatedPair pair = (UpdatedPair)entry.getValue();
            if (!pair.getOldMods().isEmpty() && !pair.getNewMods().isEmpty() && !pair.oldModsEqualsNewMods()) continue;
            iterator.remove();
        }
        this.updatedMods.addAll(updatedPairCandidates.values());
        this.addedMods.removeIf(addedMod -> updatedPairCandidates.containsKey(addedMod.getModId()));
        this.removedMods.removeIf(removedMod -> updatedPairCandidates.containsKey(removedMod.getModId()));
    }

    public LinkedHashSet<Mod> getCurrentMods() {
        return this.currentMods;
    }

    public LinkedHashSet<Mod> getAddedMods() {
        return this.addedMods;
    }

    public LinkedHashSet<Mod> getRemovedMods() {
        return this.removedMods;
    }

    public LinkedHashSet<UpdatedPair> getUpdatedMods() {
        return this.updatedMods;
    }

    public static synchronized ModListDiff getDiff(boolean useCache) {
        return new ModListDiff(ModListUtils.getSavedModList(), ModListUtils.getCurrentModList(useCache));
    }

    public boolean isEmpty() {
        return this.addedMods.isEmpty() && this.removedMods.isEmpty() && this.updatedMods.isEmpty();
    }

    public static boolean isModpackCreator() {
        ArrayList<String> modpackCreators = CrashAssistantConfig.getModpackCreators();
        if (modpackCreators.isEmpty() && !CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return false;
        }
        return modpackCreators.contains(ModListUtils.getCurrentUsername()) || modpackCreators.isEmpty();
    }

    public static String getFirstString(boolean forMsg, boolean isMd, String link) {
        String secondPart;
        Function<String, String> langFunc = LanguageProvider.getLangFunction(forMsg);
        StringBuilder sb = new StringBuilder();
        if (isMd) {
            sb.append("[");
        }
        if (ModListDiff.isModpackCreator()) {
            sb.append(langFunc.apply("msg.modlist_changes_latest_launch_1"));
            secondPart = langFunc.apply("msg.modlist_changes_latest_launch_2");
        } else {
            sb.append(langFunc.apply("msg.modlist_changes_modpack_1"));
            secondPart = langFunc.apply("msg.modlist_changes_modpack_2");
        }
        if (isMd) {
            sb.append("]").append("(<").append(link).append(">)");
        }
        sb.append(secondPart);
        return sb.toString();
    }

    public ModListDiffStringBuilder generateDiffMsg(boolean forMsg) {
        Function<String, String> langFunc = LanguageProvider.getLangFunction(forMsg);
        ModListDiffStringBuilder sb = new ModListDiffStringBuilder();
        if (!CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return sb;
        }
        sb.append(ModListDiff.getFirstString(forMsg, false, null));
        if (ModListDiff.isModpackCreator() && ModListUtils.getSavedModList().isEmpty() && CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
            sb.append(langFunc.apply("msg.modlist_first_launch"), "blue");
            return sb;
        }
        if (this.isEmpty()) {
            sb.append(langFunc.apply("msg.modlist_unmodified"), "blue");
            return sb;
        }
        if (!this.getAddedMods().isEmpty()) {
            sb.append(langFunc.apply("msg.added_mods"));
            for (Mod mod : this.getAddedMods()) {
                sb.append(mod.getJarName(), "green");
            }
            sb.append("");
        }
        if (!this.getRemovedMods().isEmpty()) {
            sb.append(langFunc.apply("msg.removed_mods"));
            for (Mod mod : this.getRemovedMods()) {
                sb.append(mod.getJarName(), "red");
            }
            sb.append("");
        }
        if (!this.getUpdatedMods().isEmpty()) {
            sb.append(langFunc.apply("msg.updated_mods"));
            for (UpdatedPair updatedPair : this.getUpdatedMods()) {
                if (!updatedPair.isAnyModMessedUpWithVersion()) {
                    sb.append(updatedPair.getModId(), "blue", false);
                    sb.append(" (", false);
                    this.appendModAttributes(sb, updatedPair.getOldMods(), Mod::getVersion, "red");
                    sb.append(" > ", false);
                    this.appendModAttributes(sb, updatedPair.getNewMods(), Mod::getVersion, "green");
                    sb.append(")");
                    continue;
                }
                this.appendModAttributes(sb, updatedPair.getOldMods(), Mod::getJarName, "red");
                sb.append(" > ", false);
                this.appendModAttributes(sb, updatedPair.getNewMods(), Mod::getJarName, "green");
                sb.append("");
            }
        }
        return sb;
    }

    private void appendModAttributes(ModListDiffStringBuilder sb, Collection<Mod> mods, Function<Mod, String> attributeExtractor, String color) {
        if (mods.size() == 1) {
            sb.append(attributeExtractor.apply(mods.iterator().next()), color, false);
        } else {
            sb.append("(", false);
            Iterator<Mod> iterator = mods.iterator();
            while (iterator.hasNext()) {
                Mod mod = iterator.next();
                sb.append(attributeExtractor.apply(mod), color, false);
                if (!iterator.hasNext()) continue;
                sb.append(", ", false);
            }
            sb.append(")", false);
        }
    }

    public static String getFilePrefix() {
        if (filePrefix == null) {
            filePrefix = CrashAssistantConfig.getBoolean("generated_message.h3_prefix") ? "### " : "";
        }
        return filePrefix;
    }
}

