/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CrashAssistantTransformationService
implements ITransformationService {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantTransformationService");
    private static String earlyLaunchTarget = "unknown";
    private static String earlyMinecraftVersion = "unknown";

    public CrashAssistantTransformationService() {
        try {
            URL selfUrl = CrashAssistantTransformationService.class.getProtectionDomain().getCodeSource().getLocation();
            ClassLoader classLoader = Launcher.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addUrlMethod.setAccessible(true);
                addUrlMethod.invoke((Object)classLoader, selfUrl);
            } else {
                LOGGER.warn("ClassLoader is not a URLClassLoader. Cannot inject self. This might be okay if it's already on the classpath.");
            }
        }
        catch (Exception e) {
            LOGGER.error("A critical error occurred while attempting to inject self into classpath.", (Throwable)e);
        }
        try {
            CrashAssistantTransformationService.reflectivelyExtractLaunchData();
            PlatformHelp.platform = PlatformHelp.FORGE;
            PlatformHelp.minecraftVersion = earlyMinecraftVersion;
            LibrariesJarLocator.setupLoaderJarName(FMLLoader.class);
            JarInJarHelper.launchCrashAssistantApp(earlyLaunchTarget);
            JarInJarHelper.checkDuplicatedCrashAssistantMod(true);
        }
        catch (Throwable throwable) {
            LOGGER.error("A critical error occurred during Crash Assistant setup: ", throwable);
        }
    }

    private static void reflectivelyExtractLaunchData() {
        try {
            Field argumentHandlerField = Launcher.class.getDeclaredField("argumentHandler");
            argumentHandlerField.setAccessible(true);
            Object argumentHandler = argumentHandlerField.get(Launcher.INSTANCE);
            Field argsField = ArgumentHandler.class.getDeclaredField("args");
            argsField.setAccessible(true);
            String[] rawArgs = (String[])argsField.get(argumentHandler);
            if (rawArgs == null) {
                return;
            }
            for (int i = 0; i < rawArgs.length - 1; ++i) {
                if ("--launchTarget".equals(rawArgs[i])) {
                    earlyLaunchTarget = rawArgs[i + 1];
                }
                if (!"--fml.mcVersion".equals(rawArgs[i])) continue;
                earlyMinecraftVersion = rawArgs[i + 1];
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to reflectively access ModLauncher arguments.", (Throwable)e);
        }
    }

    @NotNull
    public String name() {
        return "crash_assistant";
    }

    public void initialize(IEnvironment environment) {
    }

    public void beginScanning(IEnvironment iEnvironment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    @NotNull
    public List<ITransformer> transformers() {
        return Arrays.asList(new InnerCrashAssistantTransformer());
    }

    public static class InnerCrashAssistantTransformer
    implements ITransformer<ClassNode>,
    Opcodes {
        private static final String MINECRAFT_CLASS = "net.minecraft.client.Minecraft";

        @NotNull
        public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
            if (input.name.replace('/', '.').equals(MINECRAFT_CLASS)) {
                this.transformMinecraft(input);
            }
            return input;
        }

        private void transformMinecraft(ClassNode cn) {
            HashMap<String, String> SHUTDOWN_METHOD = new HashMap<String, String>();
            SHUTDOWN_METHOD.put("shutdown", "()V");
            SHUTDOWN_METHOD.put("func_71400_g", "()V");
            for (MethodNode m : cn.methods) {
                if (!SHUTDOWN_METHOD.containsKey(m.name) || !m.desc.equals(SHUTDOWN_METHOD.get(m.name))) continue;
                this.injectBeforeReturn(m, "dev/kostromdan/mods/crash_assistant/common/CrashAssistantHooks", "onMinecraftShutdown", "()V");
            }
        }

        private void injectBeforeReturn(MethodNode method, String owner, String name, String desc) {
            InsnList call = new InsnList();
            call.add((AbstractInsnNode)new MethodInsnNode(184, owner, name, desc, false));
            for (AbstractInsnNode insn = method.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                if (insn.getOpcode() != 177) continue;
                method.instructions.insertBefore(insn, call);
                break;
            }
        }

        @NotNull
        public Set<ITransformer.Target> targets() {
            HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>();
            targets.add(ITransformer.Target.targetClass((String)MINECRAFT_CLASS));
            return targets;
        }

        public TransformerVoteResult castVote(ITransformerVotingContext context) {
            return TransformerVoteResult.YES;
        }
    }
}

