/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.config;

import dev.kostromdan.mods.crash_assistant.common_config.lang.Lang;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.AbstractCommentedConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.CommentedConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.ConfigFormat;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.file.CommentedFileConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.io.ParsingException;
import dev.kostromdan.mods.crash_assistant.nightconfig.toml.TomlFormat;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashAssistantConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "crash_assistant", "config.toml").toAbsolutePath().normalize();
    private static final Path CONFIG_LOCK_PATH = Paths.get("local", "crash_assistant", "CONFIG_LOCK.tmp").toAbsolutePath().normalize();
    private static final Logger LOGGER = LogManager.getLogger();
    private static CommentedFileConfig config;
    private static final HashSet<String> usedOptions;
    private static long lastConfigUpdate;

    private static void setupDefaultValues() {
        usedOptions.clear();
        config.setComment("general", "General settings of Crash Assistant mod.");
        if (Objects.equals(config.get("general.help_link"), "https://discord.gg/moddedmc")) {
            config.remove("general.help_link");
        }
        CrashAssistantConfig.addOption("general.help_link", "Link which will be opened in browser on request_help_button pressed.\nIf equals CHANGE_ME, will open Forge/NeoForge/Fabric/Quilt discord link. Names of communities/channels also will be used not from config, but according to this link.\nMust start with 'https://' or 'www.'", "CHANGE_ME");
        CrashAssistantConfig.addOption("general.upload_to", "Anyways log will be uploaded to mclo.gs, but with this option you can wrap link to gnomebot.dev for better formatting.\nIf help_link equals 'CHANGE_ME', this value will be ignored and gnomebot.dev used.\nSupported values: mclo.gs / gnomebot.dev", "gnomebot.dev");
        CrashAssistantConfig.addOption("general.show_on_fml_error_screen", "Show gui on minecraft crashed on modloading and FML error screen displayed.", true);
        CrashAssistantConfig.addOption("general.kill_old_app", "Close old CrashAssistantApp if it's still running when starting a new instance of Minecraft, to avoid confusing player with window from old crash.", true);
        CrashAssistantConfig.addOption("general.default_lang", "If options.txt doesn't exist, the default language will be used.", "en_us");
        CrashAssistantConfig.addOption("general.priority_lang_for_overrides", "By default, crash assistant will get the value for the current language from the overrides folder, then from the jar.\nBy changing this option, it will first try to get it from the current overrides, then (if no override exists for this language)\nfrom the override for the language specified here, and only then from the jar language.\nUse \"NONE\" to disable this feature. Or language key, like \"en_us\" to enable it.", "NONE");
        CrashAssistantConfig.addOption("general.generate_localization_overrides_folder_with_readme", "By changing this value you can disable creating \"crash_assistant_localization_overrides\" folder and placing \"README.md\" file there.", true);
        CrashAssistantConfig.addOption("general.prevent_upload_buttons_delay", "By default our process is scanning for terminated processes(they can appear with delay) and after finish of scan enabling upload buttons.\nThis option can prevent this and enable individual upload buttons immediately after crash.\nHowever can confuse users and make them clicking individual upload buttons instead of Upload All Button.", false);
        CrashAssistantConfig.addOption("general.enable_privacy_policy_acceptance", "Before uploading the first log, requires the user to accept the privacy policy.\nDisabling this option may be illegal in some countries if you are modpack creator. Disable at your own risk.", true);
        CrashAssistantConfig.addOption("general.enable_mclogs_anti_ip_like_version_censorer", "Unfortunately mclogs censoring ip-like versions as has no way to determine if it's version or IP.\nThis will prevent this by replacing dot's in them to dot-like symbol.\nAnti censoring only versions, IP's are kept censored.", true);
        CrashAssistantConfig.addOption("general.prevent_generating_crash_assistant_app_logs", "Prevents creating \"crash_assistant\" folder in the logs folder.\nSo this option prevents our app logging at all.\nHIGHLY UNRECOMMENDED to disable! Contains many useful info.", false);
        ArrayList defaultBlacklistedLogs = new ArrayList();
        CrashAssistantConfig.addOption("general.blacklisted_logs", "List of blacklisted log files (checked with startswith()). This files won't show in GUI logs list.", defaultBlacklistedLogs);
        List blacklistedLogs = (List)config.get("general.blacklisted_logs");
        if (blacklistedLogs.contains("CrashAssistant: latest.log")) {
            blacklistedLogs.remove("CrashAssistant: latest.log");
            config.set("general.blacklisted_logs", (Object)blacklistedLogs);
        }
        config.setComment("text", "Here you can change text of lang placeHolders.\nAlso you can change any text in lang files.\nYou don't need to modify jar. You can change it in config/crash_assistant/lang. For more info read README.md file located where.");
        if (Objects.equals(config.get("text.support_name"), "Modded Minecraft Discord") || Objects.equals(config.get("text.support_name"), "mod loader Discord")) {
            config.remove("text.support_name");
        }
        CrashAssistantConfig.addOption("text.support_name", "$CONFIG.text.support_name$ in lang files will be replaced with this value.\nFor example this placeHolder used in: \"Request help in the $CONFIG.text.support_name$\"", "example Discord");
        CrashAssistantConfig.addOption("text.support_place", "$CONFIG.text.support_place$ in lang files will be replaced with this value.", "#example channel");
        CrashAssistantConfig.addOption("text.modpack_name", "$CONFIG.text.modpack_name$ in lang files will be replaced with this value.\nFor example this placeHolder used in: \"Oops, $CONFIG.text.modpack_name$ crashed!\"\nSupports Better Compatibility Checker integration. You can use $BCC.modpackName$, $BCC.modpackVersion$, etc and it will be replaced with value from BCC config.", "Minecraft");
        config.setComment("generated_message", "Settings of message generated by Upload all button");
        CrashAssistantConfig.addOption("generated_message.h3_prefix", "Add ### prefix before filename.\nThis can prevent too small, hard to hit on mobile links.", true);
        CrashAssistantConfig.addOption("generated_message.one_line_logs", "Replaces \"\\n\" separator between logs to \"   |   \" to make message vertically smaller.", true);
        CrashAssistantConfig.addOption("generated_message.intel_corrupted_notification", "Adds line in log list about this Intel processor can be corrupted.", true);
        CrashAssistantConfig.addOption("generated_message.generated_msg_lang", "If the modpack is created for a non-English-speaking audience, \u0441hange this to the language the modpack is designed for.\nThis lang will be used only for generating message by \"Upload all...\" button.Do not modify this value if there's a chance that the generated message will be sent to English-speaking communities.", "en_us");
        CrashAssistantConfig.addOption("generated_message.text_under_crashed", "This text will be under \"$CONFIG.text.modpack_name$ crashed!\" in generated message by Upload all button.\nYou can include:\n   * some form, which users should fill out.\n   * additional information like Minecraft version, etc.", "");
        CrashAssistantConfig.addOption("generated_message.warning_after_upload_all_button_press", "With this option you can notify user about something related with posting generated message.\nFor example if they need to fill some option from \"text_under_crashed\", etc.\nSupports html formatting, placeholders.\nLeave empty to prevent showing this warning message.", "");
        CrashAssistantConfig.addOption("generated_message.put_problematic_frame_to_message", "Puts problematic frame from hs_err to message.", true);
        CrashAssistantConfig.addOption("generated_message.put_analysis_result_to_message", "Puts analysis result(names of crash reasons) to message, instead of just count.", true);
        CrashAssistantConfig.addOption("generated_message.color_message", "Color modified mods count/analysis in msg with ANSI.\nCan be needed to be disabled if issues are reported to something not supporting ANSI codeblocks, like GitHub.", true);
        config.setComment("modpack_modlist", "Settings of modlist feature.\nAdds in generated msg block about which mods modpack user added/removed/updated.\nAlso you can see diff by running '/crash_assistant modlist diff' command.");
        CrashAssistantConfig.addOption("modpack_modlist.enabled", "Enable feature.", true);
        CrashAssistantConfig.addOption("modpack_modlist.modpack_creators", "nicknames of players, who considered as modpack creator.\nOnly this players can overwrite modlist.json\nIf this feature is enabled and this array is empty, will be appended with nickname of current player.\n-----------------------------------------------------------------------------------------------------\nWarning! This is not displayed anywhere, it's just tech param used for modlist feature to work correctly.\nHere must be actual nicknames of people who work with the modpack and publishing releases!\n-----------------------------------------------------------------------------------------------------", new ArrayList());
        CrashAssistantConfig.addOption("modpack_modlist.auto_update", "If enabled, modlist.json will be overwritten on every launch(first tick of TitleScreen),\nthen game is launched by modpack creator.\nSo you won't forget to save it before publishing.\nIf you want to save manually: disable this and use '/crash_assistant modlist save' command.", true);
        CrashAssistantConfig.addOption("modpack_modlist.add_resourcepacks", "If enabled, will add resourcepacks to modlist.json\nAfter filename where will be ' (resourcepack)' suffix.", false);
        CrashAssistantConfig.addOption("modpack_modlist.add_modloader_jar_name", "If enabled, will add modloader jar name to modlist, to easily track if user changed version of modloader.", true);
        CrashAssistantConfig.addOption("modpack_modlist.add_modlist_txt_as_log", "If enabled, will add generated modlist.txt, with names of all mods / modids / mixin configs / jarjar mods info to logs.", true);
        config.setComment("analysis", "Settings of analysis feature.\nAnalysing logs for most common reasons of crashes and displaying recommendations with fixes.");
        CrashAssistantConfig.addOption("analysis.enabled", "Enable feature.", true);
        CrashAssistantConfig.addOption("analysis.blacklisted_reasons", "Here you can disable some Analysis by class names.\nList of them can be found here: dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons\nFor example \"Create6Addons\"", new ArrayList());
        config.setComment("analysis_tools", "Settings of analysis tools feature.\nHere you can enable disable showing some analysis tools fot end user.");
        CrashAssistantConfig.addOption("analysis_tools.enabled", "Enable feature.", true);
        CrashAssistantConfig.addOption("analysis_tools.blacklisted_tools", "Here you can disable some Analysis tools by class names.\nList of them can be found here: dev.kostromdan.mods.crash_assistant.app.gui.analysis\nFor example \"MCreatorModDetectorGUI\"", new ArrayList());
        config.setComment("crash_command", "Settings of '/crash_assistant crash' command feature.");
        CrashAssistantConfig.addOption("crash_command.enabled", "Enable feature.", true);
        CrashAssistantConfig.addOption("crash_command.seconds", "To ensure the user really wants to crash the game, the command needs to be run again within this amount of seconds.\nSet to <= 0 to disable the confirmation.", 10);
        config.setComment("intel_corrupted", "Settings of notifying about intel corrupted processors.");
        CrashAssistantConfig.addOption("intel_corrupted.enabled", "Enable feature.", true);
        CrashAssistantConfig.addOption("greeting.shown_greeting", "You don't need to touch this option.\nOn first world join of modpack creator if set to false shows greeting, then self enables.", false);
        config.setComment("gui_customisation", "You can customise GUI with this options.");
        CrashAssistantConfig.addOption("gui_customisation.disable_upload_all_button", "Will hide Upload All Button from GUI.", false);
        CrashAssistantConfig.addOption("gui_customisation.show_dont_send_screenshot_of_gui_notice", "Append comment text with notice about sending screenshot of this gui tells nothing to modpack creators.", true);
        CrashAssistantConfig.addOption("gui_customisation.screenshot_of_gui_notice_animated_border", "Animate border to request user attention even more.", true);
        CrashAssistantConfig.addOption("gui_customisation.upload_all_button_font_size", "You can make Upload All Button bigger/smaller to request user attention.\nDefault Swing font size is 12, Default for this button in crash assistant is 16.\nNot recommended to set it more than 16, as it will affect the increase of GUI size because all text won't fit.", 16);
        CrashAssistantConfig.addOption("gui_customisation.request_help_button_font_size", "Same as upload_all_button_font_size, but for Request Help button.", 16);
        CrashAssistantConfig.addOption("gui_customisation.upload_all_button_foreground_color", "You can change Upload All Button color to request user attention.\nformat is \"R_G_B\", range is 0-255, for example \"255_0_0\" is red color. Use \"default\" to use default swing color.\nDefault for this button is \"0_178_0\" (dark green color).", "0_178_0");
        CrashAssistantConfig.addOption("gui_customisation.request_help_button_foreground_color", "Same as upload_all_button_foreground_color, but for Request Help button.\nDefault for this button is \"0_0_178\" (dark blue color).", "0_0_178");
        CrashAssistantConfig.addOption("gui_customisation.auto_fix_button_font_size", "Same as upload_all_button_font_size, but for Auto-Fix button (in integrated GPU warning).", 16);
        CrashAssistantConfig.addOption("gui_customisation.auto_fix_button_foreground_color", "Same as upload_all_button_foreground_color, but for Auto-Fix button (in integrated GPU warning).\nDefault for this button is \"0_178_0\" (dark green color).", "0_178_0");
        config.setComment("compatibility", "Checks crash_assistant compatibility with other incompatible mods.\nHighly unrecommended to disable!");
        CrashAssistantConfig.addOption("compatibility.enabled", "Enable feature.", true);
        HashSet toRemove = new HashSet();
        config.valueMap().forEach((key, value) -> {
            if (value instanceof AbstractCommentedConfig) {
                ((AbstractCommentedConfig)value).valueMap().forEach((k, v) -> {
                    String mergedKey = key + "." + k;
                    if (!usedOptions.contains(mergedKey)) {
                        toRemove.add(mergedKey);
                    }
                });
            }
            if (!usedOptions.contains(key)) {
                toRemove.add(key);
            }
        });
        toRemove.forEach(key -> {
            config.remove((String)key);
            LOGGER.warn("Removed config option due to it not used in config anymore: " + key);
        });
    }

    private static <T> void addOption(String path, String comment, T defaultValue) {
        usedOptions.add(path);
        usedOptions.add(path.split("\\.")[0]);
        config.setComment(path, comment);
        if (!config.contains(path)) {
            config.set(path, defaultValue);
        } else if (config.get(path).getClass() != defaultValue.getClass()) {
            LOGGER.warn("Error while reading config param: '" + path + "'. Current value class:'" + config.get(path).getClass().getName() + "' is not equal to needed:'" + defaultValue.getClass().getName() + "'. Resetting to default!");
            config.set(path, defaultValue);
        }
    }

    public static ArrayList<String> getBlacklistedLogs() {
        return (ArrayList)CrashAssistantConfig.get("general.blacklisted_logs");
    }

    public static ArrayList<String> getBlacklistedAnalysis() {
        return (ArrayList)CrashAssistantConfig.get("analysis.blacklisted_reasons");
    }

    public static ArrayList<String> getBlacklistedAnalysisTools() {
        return (ArrayList)CrashAssistantConfig.get("analysis_tools.blacklisted_tools");
    }

    public static ArrayList<String> getModpackCreators() {
        return (ArrayList)CrashAssistantConfig.get("modpack_modlist.modpack_creators");
    }

    public static void addModpackCreator(String nickname) {
        ArrayList<String> currentModpackCreators = CrashAssistantConfig.getModpackCreators();
        currentModpackCreators.add(nickname);
        CrashAssistantConfig.set("modpack_modlist.modpack_creators", currentModpackCreators);
    }

    public static Path getConfigPath() {
        return CONFIG_PATH;
    }

    /*
     * Exception decompiling
     */
    public static void executeWithLock(Runnable body) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void update() {
        CrashAssistantConfig.executeWithLock(() -> {
            if (!CONFIG_PATH.toFile().exists() || CONFIG_PATH.toFile().lastModified() > lastConfigUpdate) {
                CrashAssistantConfig.load();
            }
        });
    }

    public static void load() {
        CrashAssistantConfig.executeWithLock(() -> {
            try {
                config.load();
            }
            catch (ParsingException e) {
                LOGGER.error("Error while loading config, saved old problematic config as 'config.toml.bak', resetting 'config.toml' to default values:", (Throwable)e);
                try {
                    CONFIG_PATH.toFile().renameTo(Paths.get(CONFIG_PATH.getParent().toString(), "config.toml.bak").toFile());
                }
                catch (Exception e1) {
                    LOGGER.error("Failed to rename 'config.toml' to 'config.toml.bak': ", (Throwable)e1);
                }
                config.clear();
            }
            int old_values_hash = config.valueMap().hashCode();
            long old_comments_hash = CrashAssistantConfig.getCommentsHash();
            CrashAssistantConfig.setupDefaultValues();
            if (config.valueMap().hashCode() != old_values_hash || CrashAssistantConfig.getCommentsHash() != old_comments_hash) {
                CrashAssistantConfig.save();
            }
            lastConfigUpdate = CONFIG_PATH.toFile().lastModified();
        });
    }

    public static long getCommentsHash() {
        long hash = 0L;
        hash += (long)config.commentMap().hashCode();
        for (Map.Entry<String, Object> entry : config.valueMap().entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof AbstractCommentedConfig)) continue;
            hash += (long)((AbstractCommentedConfig)value).commentMap().hashCode();
        }
        return hash;
    }

    public static void save() {
        CrashAssistantConfig.executeWithLock(() -> {
            config.save();
            lastConfigUpdate = CONFIG_PATH.toFile().lastModified();
        });
    }

    public static synchronized <T> T get(String path) {
        AtomicReference result = new AtomicReference();
        CrashAssistantConfig.executeWithLock(() -> {
            CrashAssistantConfig.update();
            result.set(config.get(path));
        });
        return (T)result.get();
    }

    public static boolean getBoolean(String path) {
        return (Boolean)CrashAssistantConfig.get(path);
    }

    public static int getInteger(String path) {
        return (Integer)CrashAssistantConfig.get(path);
    }

    public static String get(String path, boolean applyPlaceHolders) {
        return applyPlaceHolders ? Lang.applyPlaceHolders((String)config.get(path), new HashMap<String, String>()) : (String)config.get(path);
    }

    public static <T> void set(String path, T value) {
        CrashAssistantConfig.executeWithLock(() -> {
            CrashAssistantConfig.update();
            config.set(path, value);
            CrashAssistantConfig.save();
        });
    }

    public static void main(String[] args) {
    }

    static {
        usedOptions = new HashSet();
        CrashAssistantConfig.executeWithLock(() -> {
            config = (CommentedFileConfig)CommentedFileConfig.builder(CONFIG_PATH, (ConfigFormat<? extends CommentedConfig>)TomlFormat.instance()).preserveInsertionOrder().build();
            CrashAssistantConfig.load();
        });
    }
}

