/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.HeapDumper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ThreadDumper;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CrashAssistantCommands {
    public static final HashMap<String, String> supportedCrashCommands = new HashMap<String, String>(){
        {
            this.put("game", "Minecraft");
            this.put("jvm", "JVM");
            this.put("no_crash", "noCrash");
        }
    };
    public static final HashSet<String> supportedCrashArgs = new HashSet<String>(){
        {
            this.add("--withThreadDump");
            this.add("--withHeapDump");
            this.add("--GCBeforeHeapDump");
        }
    };
    public static Instant lastCrashCommand = Instant.ofEpochMilli(0L);
    public static boolean isDeadLocked = false;
    private static String latestDiffText = "";
    private static String latestNickname = "";

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"crash_assistant").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"modlist").then(LiteralArgumentBuilder.literal((String)"save").executes(CrashAssistantCommands::saveModlist))).then(LiteralArgumentBuilder.literal((String)"diff").executes(CrashAssistantCommands::showDiff)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"crash").requires(c -> CrashAssistantConfig.getBoolean("crash_command.enabled"))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"to_crash", (ArgumentType)StringArgumentType.string()).suggests(new CrashCommandsSuggestionProvider()).executes(CrashAssistantCommands::crash)).then(CrashAssistantCommands.getCrashArg(1).then(CrashAssistantCommands.getCrashArg(2).then(CrashAssistantCommands.getCrashArg(3))))));
    }

    public static ITextComponent getModConfigComponent() {
        TextComponentString component = new TextComponentString("[mod config]");
        Style style = new Style().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, CrashAssistantConfig.getConfigPath().toAbsolutePath().toString())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LanguageProvider.get("commands.mod_config_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static ITextComponent getCopyNicknameComponent(String playerNickname) {
        latestNickname = playerNickname;
        TextComponentString component = new TextComponentString("[nickname]");
        Style style = new Style().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/crash_assistant crash copy_to_clipboard nickname")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LanguageProvider.get("commands.nickname_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static ITextComponent getCopyDiffComponent(ModListDiffStringBuilder diff) {
        latestDiffText = diff.toText();
        TextComponentString component = new TextComponentString("[" + LanguageProvider.get("commands.diff_copy") + "]");
        Style style = new Style().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/crash_assistant crash copy_to_clipboard")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LanguageProvider.get("commands.diff_tooltip"))));
        component.func_150255_a(style);
        return component;
    }

    public static void sendClientMsg(ITextComponent message) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_152344_a(() -> mc.field_71456_v.func_146158_b().func_146227_a(message));
    }

    public static boolean checkModlistFeatureEnabled() {
        LanguageProvider.updateLang();
        if (CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return true;
        }
        TextComponentString msg = new TextComponentString("");
        msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.modlist_disabled_error_msg")));
        msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
        msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return false;
    }

    public static int saveModlist(CommandContext<?> context) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return 0;
        }
        TextComponentString msg = new TextComponentString("");
        if (CrashAssistantConfig.getModpackCreators().contains(CrashAssistant.playerNickname)) {
            ModListUtils.saveCurrentModList();
            msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.modlist_overwritten_success")));
            if (CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
                TextComponentString autoUpdateMsg = new TextComponentString(LanguageProvider.get("commands.modlist_auto_update_msg"));
                autoUpdateMsg.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
                msg.func_150257_a((ITextComponent)autoUpdateMsg);
            } else {
                TextComponentString enableAutoUpdateMsg = new TextComponentString(LanguageProvider.get("commands.modlist_enable_auto_update_msg"));
                enableAutoUpdateMsg.func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
                msg.func_150257_a((ITextComponent)enableAutoUpdateMsg);
            }
            msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
            msg.func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
        } else {
            msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.not_creator_error_msg")));
            msg.func_150257_a(CrashAssistantCommands.getCopyNicknameComponent(CrashAssistant.playerNickname));
            msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.add_to_creator_list_msg")));
            msg.func_150257_a(CrashAssistantCommands.getModConfigComponent());
            msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return 0;
    }

    public static int showDiff(CommandContext<?> context) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return 0;
        }
        ModListDiff diff = ModListDiff.getDiff(false);
        TextComponentString msg = new ComponentModListDiffStringBuilder(diff.generateDiffMsg(false)).toComponent();
        msg.func_150257_a(CrashAssistantCommands.getCopyDiffComponent(diff.generateDiffMsg(true)));
        CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
        return 0;
    }

    private static int deadlockIntegratedServer(CommandContext<?> context) {
        isDeadLocked = true;
        return 0;
    }

    private static int releaseIntegratedServer(CommandContext<?> context) {
        isDeadLocked = false;
        return 0;
    }

    public static int crash(CommandContext<?> context) {
        String text;
        LanguageProvider.updateLang();
        TextComponentString msg = new TextComponentString("");
        String toCrash = "null";
        try {
            toCrash = (String)context.getArgument("to_crash", String.class);
        }
        catch (IllegalArgumentException var7) {
            TextComponentString errorMsg = new TextComponentString(LanguageProvider.get("commands.crash_command_validation_failed_to_crash") + " '" + toCrash + "'");
            errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
            return 0;
        }
        if (!"copy_to_clipboard".equals(toCrash)) {
            if (!supportedCrashCommands.containsKey(toCrash)) {
                TextComponentString errorMsg = new TextComponentString(LanguageProvider.get("commands.crash_command_validation_failed_to_crash") + " '" + toCrash + "'");
                errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
                return 0;
            }
            toCrash = supportedCrashCommands.get(toCrash);
            int secondsToCrash = (Integer)CrashAssistantConfig.get("crash_command.seconds");
            boolean noCrash = Objects.equals(toCrash, "noCrash");
            if (secondsToCrash > 0 && !Instant.now().isBefore(lastCrashCommand.plusSeconds(secondsToCrash)) && !noCrash) {
                lastCrashCommand = Instant.now();
                msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_1")));
                TextComponentString toCrashComponent = new TextComponentString(toCrash);
                toCrashComponent.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                msg.func_150257_a((ITextComponent)toCrashComponent);
                msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_2")));
                TextComponentString secondsComponent = new TextComponentString(Integer.toString(secondsToCrash));
                secondsComponent.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                msg.func_150257_a((ITextComponent)secondsComponent);
                msg.func_150257_a((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_3")));
                msg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                CrashAssistantCommands.sendClientMsg((ITextComponent)msg);
                return 0;
            }
            String toCrashFinal = toCrash;
            boolean noCrashFinal = noCrash;
            List<String> args = CrashAssistantCommands.parseCrashArgs(context);
            new Thread(() -> {
                if (!CrashAssistantCommands.validateCrashArgs(args)) {
                    return;
                }
                if (!args.isEmpty()) {
                    TextComponentString applyingArgsMsg = new TextComponentString(LanguageProvider.get("commands.crash_command_applying_args"));
                    applyingArgsMsg.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                    CrashAssistantCommands.sendClientMsg((ITextComponent)applyingArgsMsg);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (args.contains("--withThreadDump")) {
                    CrashAssistant.LOGGER.error("Detected '--withThreadDump' crash command argument. ThreadDump:\n" + ThreadDumper.obtainThreadDump());
                }
                if (args.contains("--withHeapDump")) {
                    if (args.contains("--GCBeforeHeapDump")) {
                        CrashAssistant.LOGGER.error("Detected '--GCBeforeHeapDump' crash command argument. Performing garbage collection before heap dump.");
                        System.gc();
                    }
                    CrashAssistant.LOGGER.error("Detected '--withHeapDump' crash command argument. Creating heap dump.");
                    try {
                        CrashAssistant.LOGGER.error("Created heap dump at: " + HeapDumper.createHeapDump());
                    }
                    catch (Exception var5x) {
                        CrashAssistant.LOGGER.error("Failed to create heap dump.", (Throwable)var5x);
                    }
                }
                if (!noCrashFinal) {
                    TextComponentString crashingMsg = new TextComponentString(LanguageProvider.get("commands.crash_command_crashing"));
                    crashingMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                    CrashAssistantCommands.sendClientMsg((ITextComponent)crashingMsg);
                } else {
                    CrashAssistantCommands.sendClientMsg((ITextComponent)new TextComponentString(LanguageProvider.get("commands.crash_command_done")));
                }
                if (Objects.equals(toCrashFinal, "Minecraft")) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        String reason = "Minecraft crashed by '/crash_assistant crash' command.";
                        CrashReport report = CrashReport.func_85055_a((Throwable)new Throwable(reason), (String)reason);
                        if (Minecraft.func_71410_x().field_71441_e != null) {
                            Minecraft.func_71410_x().func_71396_d(report);
                        }
                        Minecraft.func_71410_x().func_71377_b(report);
                    });
                } else if (Objects.equals(toCrashFinal, "JVM")) {
                    CrashAssistant.LOGGER.error("JVM crashed by '/crash_assistant crash jvm' command.");
                    try {
                        UnsafeAccess.UNSAFE.setMemory(0L, 1L, (byte)0);
                    }
                    catch (Throwable t) {
                        CrashAssistant.LOGGER.error("Failed to crash JVM via Unsafe", t);
                    }
                }
            }).start();
            return 0;
        }
        List<String> args = CrashAssistantCommands.parseCrashArgs(context);
        boolean isNickname = !args.isEmpty() && Objects.equals(args.get(0), "nickname");
        String string = text = isNickname ? latestNickname : latestDiffText;
        if (text != null && !text.isEmpty()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    Minecraft.func_71410_x().field_195559_v.func_197960_a(text);
                    TextComponentString okMsg = new TextComponentString(isNickname ? "Nickname copied to clipboard" : "Mod list diff copied to clipboard");
                    okMsg.func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
                    CrashAssistantCommands.sendClientMsg((ITextComponent)okMsg);
                }
                catch (Throwable var4x) {
                    TextComponentString errorMsg = new TextComponentString("Failed to copy to clipboard");
                    errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                    CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
                }
            });
            return 0;
        }
        TextComponentString errorMsg = new TextComponentString(isNickname ? "No nickname available to copy" : "No diff text available to copy");
        errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
        return 0;
    }

    public static boolean validateCrashArgs(List<String> args) {
        for (String arg : args) {
            if (supportedCrashArgs.contains(arg)) continue;
            TextComponentString errorMsg = new TextComponentString(LanguageProvider.get("commands.crash_command_validation_failed") + " '" + arg + "'");
            errorMsg.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            CrashAssistantCommands.sendClientMsg((ITextComponent)errorMsg);
            return false;
        }
        return true;
    }

    public static List<String> parseCrashArgs(CommandContext<?> context) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 1; i <= supportedCrashArgs.size(); ++i) {
            try {
                args.add((String)context.getArgument("arg" + i, String.class));
                continue;
            }
            catch (IllegalArgumentException var4) {
                break;
            }
        }
        return args;
    }

    public static ArgumentBuilder getCrashArg(int i) {
        return RequiredArgumentBuilder.argument((String)("arg" + i), (ArgumentType)StringArgumentType.string()).suggests(new CrashArgsSuggestionProvider()).executes(CrashAssistantCommands::crash);
    }

    public static class CrashCommandsSuggestionProvider<S>
    implements SuggestionProvider<S> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (String crashCommand : supportedCrashCommands.keySet()) {
                builder.suggest(crashCommand);
            }
            return builder.buildFuture();
        }
    }

    public static class ComponentModListDiffStringBuilder
    extends ModListDiffStringBuilder {
        ComponentModListDiffStringBuilder(ModListDiffStringBuilder modListDiffStringBuilder) {
            this.sb = modListDiffStringBuilder.sb;
        }

        public TextComponentString toComponent() {
            TextComponentString msg = new TextComponentString("");
            for (ModListDiffStringBuilder.ColoredString cs : this.sb) {
                TextComponentString part = new TextComponentString(cs.getText());
                if (!cs.getColor().isEmpty()) {
                    TextFormatting color = TextFormatting.valueOf((String)cs.getColor().toUpperCase());
                    part.func_150255_a(new Style().func_150238_a(color));
                }
                msg.func_150257_a((ITextComponent)part);
                if (!cs.isEndsWithNewLine()) continue;
                msg.func_150257_a((ITextComponent)new TextComponentString("\n"));
            }
            return msg;
        }
    }

    public static class CrashArgsSuggestionProvider<S>
    implements SuggestionProvider<S> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            List<String> existingArgs = CrashAssistantCommands.parseCrashArgs(context);
            for (String e : supportedCrashArgs) {
                if (existingArgs.contains(e) || Objects.equals(e, "--GCBeforeHeapDump") && !existingArgs.contains("--withHeapDump")) continue;
                builder.suggest(e);
            }
            return builder.buildFuture();
        }
    }
}

