# Localizing and Customizing Crash Assistant

Hello, localizers and modpack creators!

This guide explains how to contribute new translations to the mod and how to customize the text for your own modpack.

## Contributing New Translations

We welcome contributions for new languages or improvements to existing ones!

To contribute, please create a **Pull Request** on our official GitHub repository with your new or modified language
files.

* **GitHub Repository:
  ** [https://github.com/KostromDan/Crash-Assistant/](https://github.com/KostromDan/Crash-Assistant/)
* **Language File Location:** The source files are located at
  `common_config/src/main/resources/crash_assistant_localization` in the repository.

---

## Customizing Text for Your Modpack

If you want to change any text in the mod for your modpack, please **do not edit the JAR file directly**. Instead, use
the built-in override system.

### How to Override Text

1. Navigate to the `config/crash_assistant/crash_assistant_localization_overrides/` directory in your Minecraft
   instance.
2. Create a JSON file named after the language you want to modify (e.g., `en_us.json`, `ru_ru.json`, etc.).
3. Inside this file, you only need to add the keys and values for the text you wish to change. Any key you define here
   will take precedence over the default text packed inside the mod.

This method is perfect for tweaking a few lines of text or even adding a completely new, unsupported language to your
modpack.

### Priority Language Overrides

You can use the `general.priority_lang_for_overrides` config option to specify a primary language for your custom text.

* **How it works:** If you set this option to `"en_us"`, any custom text you place in the `en_us.json` override file
  will be used as the default for **all other languages**, unless a specific override for that key exists in their
  respective language files (e.g., in `de_de.json`). This is useful for ensuring your custom messages appear
  consistently for all users, regardless of their selected language.

### Configuration Options

* You can prevent the `crash_assistant_localization_overrides` folder and this README file from being generated by
  setting `general.generate_localization_overrides_folder_with_readme` to `false`.

### ⚠️ Important Warning

Standard Minecraft localization methods, such as **resource packs** or scripting mods like **KubeJS**, **will not work
**. Crash Assistant uses its own internal system to load language files to ensure it can display messages correctly,
even when the main game has crashed or hasn't fully loaded. Please use the override folder as described above.