/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ModFingerprinter {
    public static IdentificationResult identify(Path path) throws IOException {
        MessageDigest sha1Digest;
        try {
            sha1Digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 algorithm not found in JVM", e);
        }
        ByteArrayOutputStream normalizedBuffer = new ByteArrayOutputStream();
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int read;
            byte[] ioBuffer = new byte[8192];
            while ((read = stream.read(ioBuffer)) != -1) {
                sha1Digest.update(ioBuffer, 0, read);
                for (int i = 0; i < read; ++i) {
                    byte b = ioBuffer[i];
                    if (ModFingerprinter.isWhitespace(b)) continue;
                    normalizedBuffer.write(b);
                }
            }
        }
        String sha1Hex = ModFingerprinter.bytesToHex(sha1Digest.digest());
        byte[] normalizedData = normalizedBuffer.toByteArray();
        long murmurValue = ModFingerprinter.computeMurmur2(normalizedData, normalizedData.length);
        return new IdentificationResult(murmurValue, sha1Hex);
    }

    private static boolean isWhitespace(byte b) {
        return b == 9 || b == 10 || b == 13 || b == 32;
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static long computeMurmur2(byte[] data, int length) {
        int m = 1540483477;
        int r = 24;
        int seed = 1;
        int h = seed ^ length;
        int length4 = length / 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = data[i4] & 0xFF | (data[i4 + 1] & 0xFF) << 8 | (data[i4 + 2] & 0xFF) << 16 | (data[i4 + 3] & 0xFF) << 24;
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        int offset = length4 * 4;
        switch (length % 4) {
            case 3: {
                h ^= (data[offset + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[offset + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[offset] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return (long)h & 0xFFFFFFFFL;
    }

    public static class IdentificationResult {
        private final long curseForgeHash;
        private final String modrinthHash;

        public IdentificationResult(long curseForgeHash, String modrinthHash) {
            this.curseForgeHash = curseForgeHash;
            this.modrinthHash = modrinthHash;
        }

        public long getCurseForgeHash() {
            return this.curseForgeHash;
        }

        public String getModrinthHash() {
            return this.modrinthHash;
        }

        public String toString() {
            return String.format("Result[CF=%d, MR=%s]", this.curseForgeHash, this.modrinthHash);
        }
    }
}

