/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.platform;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public enum PlatformHelp {
    FORGE("https://discord.minecraftforge.net", "Minecraft Forge Discord", "#player-support channel"),
    NEOFORGE("https://discord.neoforged.net", "NeoForge Discord", "#user_support channel"),
    FABRIC("https://discord.gg/v6v4pMv", "Fabric Discord", "#player-support channel"),
    QUILT("https://discord.quiltmc.org/", "QuiltMC Discord", "#player-support channel"),
    UNKNOWN("https://discord.gg/moddedmc", "ModdedMC Discord", "#player-help channel");

    private final String helpLink;
    private final String helpName;
    private final String helpChannel;
    public static PlatformHelp platform;
    public static String loaderJarName;
    public static String minecraftVersion;
    public static final String javaVersion;
    public static String childProcessesPIDs;
    private static final String OS;

    private PlatformHelp(String helpLink, String helpName, String helpChannel) {
        this.helpLink = helpLink;
        this.helpName = helpName;
        this.helpChannel = helpChannel;
    }

    public static boolean isLinkDefault() {
        return Objects.equals(CrashAssistantConfig.get("general.help_link"), "CHANGE_ME");
    }

    public static String getActualHelpLink() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("general.help_link");
        }
        return PlatformHelp.platform.helpLink;
    }

    public static String getActualHelpName() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_name");
        }
        return PlatformHelp.platform.helpName;
    }

    public static String getActualHelpChannel() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_place");
        }
        return PlatformHelp.platform.helpChannel;
    }

    public static List<String> getOrderedInJarPaths() {
        return switch (platform.ordinal()) {
            case 1 -> new ArrayList<String>(){
                {
                    this.add("META-INF/neoforge.mods.toml");
                    this.add("META-INF/mods.toml");
                    this.add("fabric.mod.json");
                }
            };
            case 2, 3 -> new ArrayList<String>(){
                {
                    this.add("fabric.mod.json");
                    this.add("META-INF/mods.toml");
                    this.add("META-INF/neoforge.mods.toml");
                }
            };
            case 0 -> new ArrayList<String>(){
                {
                    this.add("META-INF/mods.toml");
                    this.add("META-INF/neoforge.mods.toml");
                    this.add("fabric.mod.json");
                }
            };
            default -> new ArrayList<String>(){
                {
                    this.add("META-INF/mods.toml");
                    this.add("META-INF/neoforge.mods.toml");
                    this.add("fabric.mod.json");
                }
            };
        };
    }

    public static boolean isLinux() {
        return OS.contains("nux");
    }

    public static boolean isMacOS() {
        return OS.contains("mac");
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isFabricBased() {
        return platform == FABRIC || platform == QUILT;
    }

    public static boolean isForgeBased() {
        return platform == FORGE || platform == NEOFORGE;
    }

    static {
        platform = UNKNOWN;
        loaderJarName = "UNDEFINED";
        minecraftVersion = "UNDEFINED";
        javaVersion = Runtime.version().toString();
        childProcessesPIDs = "UNDEFINED";
        OS = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    }
}

