/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public class Mod {
    private final String jarName;
    private final String modId;
    private final String version;
    public static final Type TYPE = new TypeToken<LinkedHashSet<Mod>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TYPE, (Object)new ModAdapter()).setPrettyPrinting().create();

    public Mod(String jarName, String modId, String version) {
        this.jarName = jarName;
        this.modId = modId;
        this.version = version;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getModId() {
        return this.modId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isModMessedUpWithVersion() {
        if (this.version == null || this.modId == null) {
            return true;
        }
        String normVersion = this.version.toLowerCase().replaceAll("mc\\d+(\\.\\d+)*", "").replaceAll("fabric|neo|forge", "").replaceAll("[+._\\-]", "").trim();
        String normJarName = this.jarName.toLowerCase().replaceAll("mc\\d+(\\.\\d+)*", "").replaceAll("fabric|neo|forge", "").replaceAll("[+._\\-]", "").trim();
        return !normJarName.contains(normVersion);
    }

    public String toString() {
        return "Mod{fileName='" + this.jarName + '\'' + ", modId='" + this.modId + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mod mod = (Mod)o;
        return Objects.equals(this.jarName, mod.jarName);
    }

    public int hashCode() {
        return Objects.hash(this.jarName);
    }

    public static class ModAdapter
    implements JsonDeserializer<LinkedHashSet<Mod>>,
    JsonSerializer<LinkedHashSet<Mod>> {
        public LinkedHashSet<Mod> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            LinkedHashSet<Mod> mods;
            block3: {
                block2: {
                    mods = new LinkedHashSet<Mod>();
                    if (!json.isJsonArray()) break block2;
                    for (JsonElement element : json.getAsJsonArray()) {
                        mods.add(new Mod(element.getAsString(), null, null));
                    }
                    break block3;
                }
                if (!json.isJsonObject()) break block3;
                for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                    JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    String modId = obj.has("modId") ? obj.get("modId").getAsString() : null;
                    String version = obj.has("version") ? obj.get("version").getAsString() : null;
                    mods.add(new Mod((String)entry.getKey(), modId, version));
                }
            }
            return mods;
        }

        public JsonElement serialize(LinkedHashSet<Mod> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            for (Mod mod : src) {
                JsonObject modDetails = new JsonObject();
                if (mod.getModId() != null) {
                    modDetails.addProperty("modId", mod.getModId());
                }
                if (mod.getVersion() != null) {
                    modDetails.addProperty("version", mod.getVersion());
                }
                root.add(mod.getJarName(), (JsonElement)modDetails);
            }
            return root;
        }
    }
}

