/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.platform;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public enum PlatformHelp {
    FORGE("https://discord.minecraftforge.net", "Minecraft Forge Discord", "#player-support channel"),
    NEOFORGE("https://discord.neoforged.net", "NeoForge Discord", "#user_support channel"),
    FABRIC("https://discord.gg/v6v4pMv", "Fabric Discord", "#player-support channel"),
    QUILT("https://discord.quiltmc.org/", "QuiltMC Discord", "#player-support channel"),
    UNKNOWN("https://discord.gg/moddedmc", "ModdedMC Discord", "#player-help channel");

    private final String helpLink;
    private final String helpName;
    private final String helpChannel;
    public static PlatformHelp platform;
    public static String loaderJarName;
    public static String minecraftVersion;
    public static final String javaVersion;
    public static String childProcessesPIDs;
    public static final String OS;

    private PlatformHelp(String helpLink, String helpName, String helpChannel) {
        this.helpLink = helpLink;
        this.helpName = helpName;
        this.helpChannel = helpChannel;
    }

    public static boolean isLinkDefault() {
        return Objects.equals(CrashAssistantConfig.get("general.help_link"), "CHANGE_ME");
    }

    public static String getActualHelpLink() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("general.help_link");
        }
        return PlatformHelp.platform.helpLink;
    }

    public static String getActualHelpName() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_name");
        }
        return PlatformHelp.platform.helpName;
    }

    public static String getActualHelpChannel() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_place");
        }
        return PlatformHelp.platform.helpChannel;
    }

    public static List<String> getOrderedInJarPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        switch (platform.ordinal()) {
            case 1: {
                paths.add("META-INF/neoforge.mods.toml");
                paths.add("META-INF/mods.toml");
                paths.add("fabric.mod.json");
                break;
            }
            case 2: 
            case 3: {
                paths.add("fabric.mod.json");
                paths.add("META-INF/mods.toml");
                paths.add("META-INF/neoforge.mods.toml");
                break;
            }
            case 0: {
                paths.add("META-INF/mods.toml");
                paths.add("META-INF/neoforge.mods.toml");
                paths.add("fabric.mod.json");
                break;
            }
            default: {
                paths.add("META-INF/mods.toml");
                paths.add("META-INF/neoforge.mods.toml");
                paths.add("fabric.mod.json");
            }
        }
        return paths;
    }

    public static boolean isLinux() {
        return OS.contains("nux");
    }

    public static boolean isMacOS() {
        return OS.contains("mac");
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isFabricBased() {
        return platform == FABRIC || platform == QUILT;
    }

    public static boolean isForgeBased() {
        return platform == FORGE || platform == NEOFORGE;
    }

    static {
        platform = UNKNOWN;
        loaderJarName = "UNDEFINED";
        minecraftVersion = "UNDEFINED";
        javaVersion = System.getProperty("java.runtime.version", "UNDEFINED");
        childProcessesPIDs = "UNDEFINED";
        OS = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    }
}

