/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.core_mod.services;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.core_mod.utils.IModLocatorInjector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CrashAssistantTransformationService
implements ITransformationService {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantTransformationService");

    @NotNull
    public String name() {
        return "crash_assistant";
    }

    public void initialize(IEnvironment environment) {
        String launchTarget = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get()).orElse("unknown");
        PlatformHelp.platform = PlatformHelp.FORGE;
        try {
            Field versionField = FMLLoader.class.getDeclaredField("mcVersion");
            versionField.setAccessible(true);
            PlatformHelp.minecraftVersion = String.valueOf(versionField.get(null));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to read Minecraft version from FMLLoader", e);
        }
        LibrariesJarLocator.setupLoaderJarName(FMLLoader.class);
        JarInJarHelper.launchCrashAssistantApp(launchTarget);
        JarInJarHelper.checkForIncompatibleMods(true);
        JarInJarHelper.checkDuplicatedCrashAssistantMod(true);
    }

    public void beginScanning(IEnvironment iEnvironment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        IModLocatorInjector.inject();
    }

    @NotNull
    public List<ITransformer> transformers() {
        return new ArrayList<ITransformer>();
    }
}

