/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.config;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.file.FileConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.json.JsonFormat;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class CrashAssistantLocalConfig {
    private static final FileConfig config;
    private static final Path CONFIG_PATH;

    public static void load() {
        try {
            config.load();
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.error("Failed to load local_config.json... Resetting.", (Throwable)e);
            config.clear();
        }
    }

    public static void save() {
        config.save();
    }

    public static boolean getBoolean(String key) {
        return (Boolean)config.get(key);
    }

    public static Object get(String key) {
        return config.get(key);
    }

    public static void set(String key, Object value) {
        config.set(key, value);
        CrashAssistantLocalConfig.save();
    }

    static {
        CONFIG_PATH = Paths.get("local", "crash_assistant", "local_config.json");
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        config = FileConfig.builder(CONFIG_PATH, JsonFormat.fancyInstance()).build();
        CrashAssistantLocalConfig.load();
    }
}

